package com.biz.eisp.mdm.authobj.transform;

import java.util.ArrayList;
import java.util.List;

import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.google.common.base.Function;

/** 
 * 权限对象po转vo.
 * @author grover
 * @version v1.0
 */
public class TmFuncAuthTransForm implements Function<TmFunAuthEntity, TmFunctionAuthVo> {
	/**
	 * 选中的权限对象
	 */
	private List<TmFunAuthEntity> tmFunAuthEntitys = new ArrayList<TmFunAuthEntity>();
	/**
	 * 数据字典注入
	 */
	private TmDictDataService tmDictDataService = ApplicationContextUtils.getContext().getBean(TmDictDataService.class);
	/**
	 * 构造器.
	 * @param tmFunAuths 选中的权限对象
	 */
	public TmFuncAuthTransForm(List<TmFunAuthEntity> tmFunAuths){
		this.tmFunAuthEntitys = tmFunAuths;
	}
	
	@Override
	public TmFunctionAuthVo apply(TmFunAuthEntity arg0) {
		TmFunctionAuthVo functionAuthVo = new TmFunctionAuthVo();
		functionAuthVo.setAuthobj(arg0.getAuthobj());
		functionAuthVo.setCreateDate(arg0.getCreateDate());
		functionAuthVo.setCreateName(arg0.getCreateName());
		functionAuthVo.setUpdateDate(arg0.getUpdateDate());
		functionAuthVo.setUpdateName(arg0.getUpdateName());
		functionAuthVo.setTmFunction(arg0.getTmFunction());
		functionAuthVo.setId(arg0.getId());
		functionAuthVo.setAuthName(tmDictDataService.findByCode(arg0.getAuthobj(), Globals.AuthObj).getDictValue());
		//处理status
		//设置是否选中
		if(!CollectionUtils.isEmpty(tmFunAuthEntitys)){
			List<TmFunAuthEntity> list = this.tmFunAuthEntitys;
			for (TmFunAuthEntity part : list) {
				if(arg0.getAuthobj().equals(part.getAuthobj())){
					functionAuthVo.setStatus(Globals.User_Normal.toString());
				}
			}
		}
		return functionAuthVo;
	}
}
