package com.biz.eisp.mdm.authobj.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.mdm.authobj.service.TmAuthExendsService;
import org.springframework.beans.BeansException;
import org.springframework.jdbc.core.JdbcTemplate;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.web.pojo.Client;

/** 
 * 权限对象工具类
 * @author 肖胜
 * @version v1.0
 */
public class AuthObjHandler {

	//sql替换添加查询条件
	public static final String SQL = "select t.* from ({0}) t  where {1}"; 
	
	//组织信息当前及下级组织信息查询条件
	public static final String orgSubSql=" t.orgId in (select id from tm_org start with id='?'"
			+ " connect by  parent_id =prior id  )";
	
	//客户组织信息当前及下级客户组织信息查询条件
	public static final String custOrgSubSql=" t.customerOrgId in(select id from tm_customer_org "
			+ "start with id='?' connect by  parent_id =prior id  )";
	
	//职位信息当前及下级职位信息查询条件
	public static final String postSubSql=" t.positionId in(select id from tm_position start with id='?' "
			+ "connect by  parent_id =prior id  )";
	
	/**
	 *权限对象处理入口
	 * @param sql 查询sql语句
	 * @return
	 */
	@SuppressWarnings("all")
	public static String executeAuthHandle(String sql){
		
		//获取request请求对象
		HttpServletRequest request=ContextHolderUtils.getRequest();
		if(request==null){
			return sql;
		}
		
		//获取权限对象标识
		String accessEntry=request.getParameter(Globals.AccessEntry);
		if(StringUtil.isEmpty(accessEntry)){
			return sql;
		}
		
		//获取 session
		Client client = ResourceConfigUtils.getClient();
		
		//通过AccessEntry获取权限对象及权限对象值
		List<Map<String, Map<String, String>>> authObjList=client.getAuthObjList();
		
		//为终端客户特殊处理的权限对象做准备
		Map<String, String> funMap=(Map<String, String>) client.getObj();
		String functionName="";
		if(funMap!=null&&!funMap.isEmpty()){
			functionName=funMap.get(accessEntry);
		}
		
		//读取权限对象及权限对象值 
		Map<String,String> authMap=null;
		if(authObjList!=null&&authObjList.size()>0){
			for(Map<String, Map<String, String>> map:authObjList){
				Map<String, String> m=map.get(accessEntry);
				if(m!=null){
					authMap=map.get(accessEntry);
				}
			}
		}
		
		//解析权限对象，追加查询条件控制 
		if(authMap!=null&&!authMap.isEmpty()){
			Iterator<Map.Entry<String, String>> it = authMap.entrySet().iterator();
			 String sqlCondition="(";
			while (it.hasNext()) {
			   Map.Entry<String, String> entry = it.next();
			   //判断是否包含权限所需要条件字段
			   if(AuthObjHandler.hasAuthObjSearchId(sql, entry.getKey())){
				   //通过权限对象获取查询条件
				  String  sqlCon=AuthObjHandler.getAuthCondition(entry.getKey(),entry.getValue(),functionName);
				  //取得查询条件追加or条件运算
				   if(StringUtil.isNotEmpty(sqlCon)){
					   sqlCondition+=sqlCon+" or ";
				   }
			   }
			}
			//查询条件不为空则，去掉最后的or关键字
			if(sqlCondition.length()>1){
				String[] sqlParam = new String[2];
				sqlParam[0]=sql;
				sqlParam[1]=sqlCondition.substring(0, sqlCondition.length()-3)+")";
				sql=MessageFormat.format(SQL, sqlParam);

				TmAuthExendsService tmAuthExendsService = (TmAuthExendsService) ApplicationContextUtils
						.getContext().getBean("tmAuthExendsService");
				if(tmAuthExendsService!=null){
					sql=tmAuthExendsService.extendsAuthobjSql(sql);
				}

				System.out.println("权限处理结果:"+sql);
			}
		}

		return sql;
	}
	
	
	/**
	 * 检查是否要权限对象需要的返回字段
	 * @param sql 查询sql
	 * @param authObj 权限对象
	 * @return
	 */
	private static boolean hasAuthObjSearchId(String sql,String authObj) {
		String authObjId="";
		//分别判断当前查询是否具有该权限对象所需条件字段
		if(StringUtil.equals(Globals.AuthUser,authObj)){
			authObjId=Globals.AuthUserId;
		}
		if(StringUtil.equals(Globals.AuthCust,authObj)){
			authObjId=Globals.AuthCustId;
		}
		if(StringUtil.equals(Globals.AuthCustOrg,authObj)){
			authObjId=Globals.AuthCustOrgId;
		}
		if(StringUtil.equals(Globals.AuthTerminal,authObj)){
			authObjId=Globals.AuthTerminalId;
		}
		if(StringUtil.equals(Globals.AuthOrg,authObj)){
			authObjId=Globals.AuthOrgId;
		}
		if(StringUtil.equals(Globals.AuthPostion,authObj)){
			authObjId=Globals.AuthPostionId;
		}
		//未找到直接返回sql
		if (!AuthObjHandler.checkQueryClounm(sql,authObjId)){
			//通过查询结果判断是否具有该权限对象所需条件字段
			return false;
		}
		
		return true;
	}
	
	/**
	 * 预演sql判断查询结果字段是是否包含权限对象所需字段
	 * @param sql 查询sql
	 * @param authObjId 权限对象所需条件字段
	 * @return
	 */
	private static boolean checkQueryClounm(String sql,String authObjId){
		ResultSet resultSet=null;
		Connection conn =null;
		Statement st = null;
		try {
			//获取spring JdbcTemplate
			JdbcTemplate jdbcTemplate = (JdbcTemplate) 
					ApplicationContextUtils.getContext().getBean("jdbcTemplate");
			//获取连接
			 conn = jdbcTemplate.getDataSource().getConnection();
			 //创建用于向数据库发送SQL语句语句对象
			st = conn.createStatement();
			//替换待注入的查询条件? 否则hibernate查询会报错
			sql= sql.replace("?", "''");
			//执行查询
			resultSet=st.executeQuery(sql);
			//获取结果集
			ResultSetMetaData rsmd =resultSet.getMetaData();
			//循环遍历全部列名
			for(int i=1;i<= rsmd.getColumnCount();i++){
				String columnName = rsmd.getColumnName(i);
				if(StringUtil.equals(authObjId.toUpperCase(), columnName.toUpperCase())){
					return true;
				}
			}
		} catch (BeansException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		}finally {
    		try {
    			st.close();
				resultSet.close();
				conn.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
        }
    	return false;
	}
	
	/**
	 * 解析权限对象值获取查询条件
	 * @param authObj 权限对象
	 * @param authObjValues 权限对象值 
	 * @param functionName 菜单名称
	 * @return
	 */
	private  static String getAuthCondition(String authObj,String authObjValues,String functionName){
		//通过权限对象值获取查询条件
		String sqlCondition=	AuthObjHandler.
				getSqlConditionByAuthObjValue(authObj, authObjValues,functionName);
		
		if(StringUtil.isNotEmpty(sqlCondition)){
			//获取动态表单查询基本信息
			DynamicConfigUtil tableConfig=DynamicConfigUtil.getInstance();
			//权限对象等于用户
			if(StringUtil.equals(authObj, Globals.AuthUser)){
				String sql =tableConfig.buildQuerySql(Globals.TABLE_USER, null);
				sqlCondition= " (t.userId in (select t.id from ("+sql+") t where "+sqlCondition+" ))";
			//权限对象等于终端
			}else 	if(StringUtil.equals(authObj, Globals.AuthTerminal)){
				String sql =tableConfig.buildQuerySql(Globals.TABLE_TERMINAL, null);
				sqlCondition= " (t.terminalId in (select t.id from ("+sql+") t where "+sqlCondition+" ))";
			//权限对象等于客户
			}else if(StringUtil.equals(authObj, Globals.AuthCust)){
				
				//终端在的客户权限对象直接返回
				if(StringUtil.equals(functionName, Globals.FUNCTION_TERMINAL)){
					return sqlCondition;
				}
				
				String sql =tableConfig.buildQuerySql(Globals.Table_CUSTOMER, null);
				sqlCondition= " (t.customerId in (select t.id from ("+sql+")  t where "+sqlCondition+" ))";
			}
		}
	
		return sqlCondition;
	}
	
	/**
	 *根据权限对象值获取查询条件
	 *@param  authObj 权限对象
	 * @param authObjValues 权限对象值 
	 * @param functionName 菜单名称(用户终端客户特殊处理)
	 * @return
	 */
	@SuppressWarnings("all")
	private  static String getSqlConditionByAuthObjValue(String authObj,
			String authObjValues,String functionName){
		//获取最终权限对象值 (当权限对象值为多个的时候 )
		List<Integer> objValues=AuthObjHandler.getFinalAuthObjValue(authObjValues);
		
		//获取查询条件
		String sqlCondition="";
		for(int i=0;i<objValues.size();i++){
			Integer objValue=objValues.get(i);
			sqlCondition=getConditionByAuthObj(authObj, objValue,functionName);
			if(objValues.size()>1&&i+1!=objValues.size()){
				sqlCondition+=" or ";
			}
		}
		return sqlCondition;
	}
	
	/**
	 * 获取权限对象查询条件
	 *@param  authObj 权限对象
	 * @param functionName 菜单名称(用户终端客户特殊处理)
	 * @return
	 */
	private static String getConditionByAuthObj(String authObj,Integer authObjValue,String functionName){
		
		String newAuthObj=authObj;
		//权限对象为用户时 根据权限对象值重新获取权限对象
		if(StringUtil.equals(Globals.AuthUser, authObj)){
			newAuthObj=getAuthObjByValue(authObjValue);
		}
		//权限对象为终端时 根据权限对象值重新获取权限对象
		if(StringUtil.equals(Globals.AuthTerminal, authObj)){
			newAuthObj=getAuthObjByValue(authObjValue);
		}
		//权限对象为客户时 根据权限对象值重新获取权限对象
		if(StringUtil.equals(Globals.AuthCust, authObj)){
			newAuthObj=getAuthObjByValue(authObjValue);
		}
		
		//客户职位权限对象特殊处理 为了去掉查询出来的重复数据 
		if(StringUtil.equals(newAuthObj, Globals.AuthPostion)
				&&StringUtil.isNotEmpty(functionName)
				&&StringUtil.equals(functionName, Globals.FUNCTION_CUSTOMER)){
			return getSpecialConForCustomerPost(authObjValue);
		}
		
		//终端职位权限对象特殊处理 为了去掉查询出来的重复数据 
		if(StringUtil.isNotEmpty(functionName)&&
				StringUtil.equals(functionName, Globals.FUNCTION_TERMINAL)){
			//如果权限对象是根据 客户的职位
			if(StringUtil.equals(Globals.AuthCust, authObj)){
				return getSpecialConForCustomer(authObjValue);
			}	
			
			//如果权限对象是根据终端的职位
			if(StringUtil.equals(newAuthObj, Globals.AuthPostion)){
				return getSpecialConForTerminalPost(authObjValue);
			}
		
		}
		//获取普通权限对象的条件
		return getConditionByObjValue(newAuthObj, authObjValue);
	}
	
	
	/**
	 * 客户职位权限对象特殊处理
	 * @param authObjValue
	 * @return
	 */
	private static String getSpecialConForCustomer(Integer authObjValue){
		//客户权限对象条件sql语句 这样写目的是为了去重复
		String sql=" exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3 "
				+" on t3.terminal_id=t2.id where t2.id=to_char(t.id)";
		//追加如果是职位权限对象当前及以下
		if(authObjValue==40){
			sql+=" and t3.customer_Id IN "+
				   "( SELECT t.ID  FROM TM_customer t "+
				   " LEFT JOIN TM_org t1 ON t1.id=t.org_id "+
				   " LEFT JOIN TM_customer_org t2 ON t2.id=t.customer_org_id "+
				   " LEFT JOIN TM_R_CUST_POS_BG t3 ON t3.customer_id =t.id "+
				   "  WHERE  t3.position_id in (select id from tm_position start with "
				  + " id='"+ ResourceConfigUtils.getCurrPosition().getId()+ "' connect by  parent_id =prior id ))";
		
		}else if(authObjValue==50){
			//追加如果是职位权限对象当前职位
			sql+=" and t3.customer_Id IN "+
				   "( SELECT t.ID  FROM TM_customer t "+
				   " LEFT JOIN TM_org t1 ON t1.id=t.org_id "+
				   " LEFT JOIN TM_customer_org t2 ON t2.id=t.customer_org_id "+
				   " LEFT JOIN TM_R_CUST_POS_BG t3 ON t3.customer_id =t.id "+
				   "  WHERE  t3.position_id='"+ ResourceConfigUtils.getCurrPosition().getId()+"')";
		}else if(authObjValue==20){
			sql+=" and t3.customer_Id IN "+
				   "( SELECT t.ID  FROM TM_customer t "+
				   "  WHERE t.org_id in (select id from tm_org start with id='"+ ResourceConfigUtils.getCurrOrg().getId()+"'"+
				   " connect by  parent_id =prior id ))";
		}else if(authObjValue==30){
			sql+=" and t3.customer_Id IN "+
					   "( SELECT t.ID  FROM TM_customer t "+
					   "  WHERE t.org_id ='"+ ResourceConfigUtils.getCurrOrg().getId()+"')";
		}else{
			return "";
		}
		sql+=")";
		return sql;
	}
	
	/**
	 * 客户职位权限对象特殊处理
	 * @param authObjValue
	 * @return
	 */
	private static String getSpecialConForCustomerPost(Integer authObjValue){
		//客户权限对象条件sql语句 这样写目的是为了去重复
		String sql=" exists(select 1 from TM_CUSTOMER t2 left join TM_R_CUST_POS_BG t3 "
											 + "on t3.customer_id=t2.id where t2.id=to_char(t.customerId) ";
		//追加如果是职位权限对象当前及以下
		if(authObjValue==40){
			sql+=" and t3.position_id in (select id from tm_position start with "
					+ "id='"+ ResourceConfigUtils.getCurrPosition().getId()+ "' connect by  parent_id =prior id )";
		}else if(authObjValue==50){
			//追加如果是职位权限对象当前职位
			sql+=" and t3.position_id='"+ ResourceConfigUtils.getCurrPosition().getId()+"'";
		}else{
			return "";
		}
		sql+=")";
		return sql;
	}
	
	/**
	 * 终端职位权限对象特殊处理
	 * @param authObjValue
	 * @return
	 */
	private static String getSpecialConForTerminalPost(Integer authObjValue){
		//客户权限对象条件sql语句 这样写目的是为了去重复
		String sql=" exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3"
													+ " on t3.terminal_id=t2.id where t2.id=to_char(t.terminalId) ";
		String positionid= ResourceConfigUtils.getCurrPosition().getId();
		
		if(authObjValue==40){
			//追加如果是职位权限对象当前及以下
			sql+=" and t3.position_id in (select id from tm_position start with id='"
					  +positionid+ "' connect by  parent_id =prior id )";
		}else if(authObjValue==50){
			//追加如果是职位权限对象当前
			sql+=" and t3.position_id='"+positionid+"'";
		}else{
			return "";
		}
		sql+=")";
		return sql;
	}
	
	
	/**
	 * 权限对象值与权限对象必须统一
	 * @param objValue 权限对象值
	 * @return
	 */
	private static String getAuthObjByValue(Integer objValue){
		String authObj="";
		switch (objValue) {
			case 20:
				//权限对象等于当前组织及以下
				authObj=Globals.AuthOrg;
				break;
			case 30:
				//权限对象等于当前组织
				authObj=Globals.AuthOrg;
				break;
			case 40:
				//权限对象等于当前职位及以下
				authObj=Globals.AuthPostion;
				break;
			case 50:
				//权限对象等于当前职位
				authObj=Globals.AuthPostion;
				break;
		}
		return authObj;
	}
	
	/**
	 *获取单个权限对象查询条件
	 * @param authObj
	 * @param objValue
	 * @return
	 */
	private static String getConditionByObjValue(String authObj,Integer objValue){
		String sqlCondition="";
		switch (objValue) {
			case 20:
				if(StringUtil.equals(Globals.AuthCustOrg, authObj)){
					//如果权限对象等于客户组织 判断登录人是否绑定客户组织id
					TmCustomerOrgEntity customerOrg= ResourceConfigUtils.getCurrCustomerOrg();
					if(customerOrg!=null){
						sqlCondition+=custOrgSubSql.replace("?", customerOrg.getId());
					}
				}else if(StringUtil.equals(Globals.AuthOrg, authObj)){
					//权限对象等于组织
					sqlCondition+=orgSubSql.replace("?", ResourceConfigUtils.getCurrOrg().getId());
				}
				break;
			case 30:
				//如果权限对象等于客户组织 判断登录人是否绑定客户组织id
				if(StringUtil.equals(Globals.AuthCustOrg, authObj)){
					TmCustomerOrgEntity customerOrg1= ResourceConfigUtils.getCurrCustomerOrg();
					if(customerOrg1!=null){
						sqlCondition+="t.customerOrgId='"+ customerOrg1.getId()+"'";
					}
				}else if(StringUtil.equals(Globals.AuthOrg, authObj)){
					//权限对象等于当前组织
					sqlCondition+=" t.orgId ='"+ ResourceConfigUtils.getCurrOrg().getId()+"'";
				}
				break;
			case 40:
				//权限对象等于当前职位及以下
				sqlCondition+=postSubSql.replace("?", ResourceConfigUtils.getCurrPosition().getId());
				break;
			case 50:
				//权限对象等于当前职位
				sqlCondition+=" t.positionId ='"+ ResourceConfigUtils.getCurrPosition().getId()+"'";
				break;
		}
		return sqlCondition;
	}
	
	/**
	 * 获取最终权限对象值
	 * @param authObjValue 权限对象值 
	 * @return
	 */
	private static List<Integer> getFinalAuthObjValue(String authObjValue){
		
		//可能存在多个权限对象值
		String[] authObjValues=authObjValue.split(",");
		List<Integer> objValues = new ArrayList<Integer>();
		
		List<String> authList = new ArrayList<String>();
		Collections.addAll(authList, authObjValues);
		//权限对象值包含全部则直接查看全部信息
		if(authList.contains(Globals.All)){
			objValues.add(0, Integer.parseInt(Globals.All));
			return objValues;
		}
		//权限对象值包含当前组织及下级组织
		else if(authList.contains(Globals.orgAndSubNode)&&authList.contains(Globals.currOrg)){
			objValues.add(objValues.size(), Integer.parseInt(Globals.orgAndSubNode));
		}
		//权限对象值包含当前职位及下级职位
		else if(authList.contains(Globals.postAndSubNode)&&authList.contains(Globals.currPost)){
			objValues.add(objValues.size(), Integer.parseInt(Globals.postAndSubNode));
		}
		else{
			int index=objValues.size();
			for(String str:authList){
				objValues.add(index,Integer.parseInt(str));
				index++;
			}
		}
		return objValues;
	}
	
}
