package com.biz.eisp.mdm.businessarea.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaFormExtendService;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaMainExtendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaExcelVo;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;

/**
 * 业务区域Controller.
 * <p>
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/tmBusinessAreaController")
public class TmBusinessAreaController extends BaseController{
	
	@Autowired
	TmBusinessAreaService tmBusinessAreaService;//注入业务区域Service

	@Autowired(required = false)
	private TmBusinessAreaFormExtendService tmBusinessAreaFormExtendService;

	@Autowired(required = false)
	private TmBusinessAreaMainExtendService tmBusinessAreaMainExtendService;

	/**
	 * 跳转业务区域页面.
	 * @author wan
	 * @param request 请求对象
	 * @return 业务区域主界面
	 */
	@RequestMapping(value = "goTmBusinessAreaMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmBusinessAreaMain(HttpServletRequest request) {
		//动态表单参数 表名
		request.setAttribute("extendTableName",Globals.TABLE_BUSINESS_AREA);
		if(tmBusinessAreaMainExtendService!=null){
			request.setAttribute("includeJSP", tmBusinessAreaMainExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/businessArea/tmBusinessAreaMain");
	}
	
	/**
	 * 跳转业务区域选择页面.
	 * @author wan
	 * @param request 请求对象
	 * @return 产品选择界面
	 */
	@RequestMapping(value = "goTmBusinessAreaSelectMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmProductSelectMain(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/mdm/businessArea/tmBusinessAreaSelectMain");
	}
	
	/**
	 * 查询区域数据列表.
	 * <p>
	 * 如果只有id，没有查询条件，即动态加载该id的子节点。
	 * 如果有查询条件，即进行查询操作。返回所有的值，构造children结构
	 * @param tmBusinessAreaVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findTmBusinessAreaList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List <TmBusinessAreaVo> findTmBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo, HttpServletRequest request) {
		List <TmBusinessAreaVo> voList = tmBusinessAreaService.findBusinessAreaList(tmBusinessAreaVo);
		return voList;
	}
	
	/**
	 * 查询区域数据列表ComboTree形式.
	 * @param tmBusinessAreaVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findTmBusinessAreaComboTree",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List <TmBusinessAreaVo> findTmBusinessAreaComboTree(TmBusinessAreaVo tmBusinessAreaVo, HttpServletRequest request) {
		List <TmBusinessAreaVo> voList = tmBusinessAreaService.findTmBusinessAreaComboTree(tmBusinessAreaVo, request.getParameter("selfId"));
		return voList;
	}
	
	/**
	 * 业务区域Form表单页面..
	 * <p>
	 * @param request
	 * @param tmBusinessAreaVo
	 * @return
	 */
	@RequestMapping(value = "goTmBusinessAreaForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmBusinessAreaForm(HttpServletRequest request, TmBusinessAreaVo tmBusinessAreaVo) {
		//动态表单参数 表名
		request.setAttribute("extendTableName", Globals.TABLE_BUSINESS_AREA);
		//表单类型0新增1编辑2查看
		String optype = request.getParameter("optype");
		request.setAttribute("optype", optype);
		
		if(StringUtil.isNotEmpty(tmBusinessAreaVo.getId())){
			TmBusinessAreaVo vo = tmBusinessAreaService.getTmBusinessAreaVo(tmBusinessAreaVo.getId());
			request.setAttribute("tba", vo);
		}
		if(tmBusinessAreaFormExtendService!=null){
			request.setAttribute("includeJSP", tmBusinessAreaFormExtendService.includeJsp());
		}
		
		return new ModelAndView("com/biz/eisp/mdm/businessArea/tmBusinessAreaForm");
	}
	
	/**
	 * 获取业务区域省市区联动.
	 * <p>获取上级业务区域的方法
	 * @author Sean
	 * @param request 请求对象
	 * @param tba 业务区域vo对象
	 * @return 列表 数据 
	 */
	@RequestMapping(value = "getAreaForCombobox", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<ComboBox> getAreaForCombobox(HttpServletRequest request,TmBusinessAreaExcelVo tba) {
		try {
			String name=request.getParameter("name");
			if(StringUtil.isNotEmpty(name)){
				name = URLDecoder.decode(name, "UTF-8"); 
				tba.setBusinessAreaName(name);
			}
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return tmBusinessAreaService.findBusinessAreaCombobox(tba);
	}
	
	/**
	 * 保存编辑.
	 * @param orgVo 业务区域vo对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "saveTmBusinessArea", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveTmBusinessArea(HttpServletRequest request, TmBusinessAreaVo tmBusinessAreaVo) {
		AjaxJson j = new AjaxJson();
		try {
			Page page = new EuPage(request);
			//保存数据
			tmBusinessAreaService.saveTmBusinessArea(tmBusinessAreaVo, page);
			//更新叶子节点状态
			tmBusinessAreaService.updateIsLeafColumn("tm_business_area");
			
			//设置编码和名称，用于保存后进行查询操作
			Map <String, Object>attributes = new HashMap<String, Object>();
			attributes.put("businessAreaCode", tmBusinessAreaVo.getBusinessAreaCode());
			attributes.put("text", tmBusinessAreaVo.getBusinessAreaName());
			j.setAttributes(attributes);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败:" + e.getMessage());
			e.printStackTrace();
		}
		return j;
	}
	
	/**
	 * 删除业务区域.
	 * @author wan
	 * @param ids 业务区域ids
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "deleteTmBusinessArea", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTmBusinessArea(String id) {
		try {
			//删除业务区域
			tmBusinessAreaService.deleteTmBusinessArea(id);
			//更新叶子节点状态
			tmBusinessAreaService.updateIsLeafColumn("tm_business_area");
		} catch(Exception e) {
			return new AjaxJson("删除失败:" + e.getMessage());
		}
		return new AjaxJson();
	}
	
	/**
	 * 验证重复name.
	 * @author wan
	 * @param 验证对象
	 * @param tba 业务区域vo对象
	 */
	@RequestMapping(value = "validateBusinessAreaName",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateBusinessAreaName(HttpServletRequest request,TmBusinessAreaExcelVo tba) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//取消验证
		//验证
//		if(StringUtil.isNotEmpty(tba.getId())){
//			//修改
//			if(tmBusinessAreaService.validate(tba.getId(), param, "businessAreaName")){
//				validForm.setStatus("n");
//				validForm.setInfo("业务区域名称已存在");
//			}
//		}else{
//			//新增
//			if(tmBusinessAreaService.validate(null, param, "businessAreaName")){
//				validForm.setStatus("n");
//				validForm.setInfo("业务区域名称已存在");
//			}
//		}
		return validForm;
	}
	/**
	 * 验证重复Code.
	 * @author wuzhujun
	 * @param request
	 * @param tba
	 * @return
	 */
	@RequestMapping(value = "validateBusinessAreaCode",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateBusinessAreaCode(HttpServletRequest request,TmBusinessAreaExcelVo tba) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(tba.getId())){
			//修改
			if(tmBusinessAreaService.validate(tba.getId(), param, "businessAreaCode")){
				validForm.setStatus("n");
				validForm.setInfo("业务区域编码已存在");
			}
		}else{
			if(tmBusinessAreaService.validate(null, param, "businessAreaCode")){
				validForm.setStatus("n");
				validForm.setInfo("业务区域编码已存在");
			}
		}
		return validForm;
	}
	
	/**
	 * 启用数据.
	 * <p>
	 * @param tmBusinessAreaVo
	 * @return
	 */
	@RequestMapping(value = "startTmBusinessArea", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson startTmBusinessArea(TmBusinessAreaVo tmBusinessAreaVo){
		try {
			tmBusinessAreaVo.setEnableStatus(0);
			tmBusinessAreaService.updateBusinessAreaEnableStatus(tmBusinessAreaVo);
			return new AjaxJson();
		} catch(Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
	}
	
	/**
	 * 停用数据.
	 * <p>
	 * @param tmBusinessAreaVo
	 * @return
	 */
	@RequestMapping(value = "stopTmBusinessArea", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson stopTmBusinessArea(TmBusinessAreaVo tmBusinessAreaVo){
		try {
			tmBusinessAreaVo.setEnableStatus(1);
			tmBusinessAreaService.updateBusinessAreaEnableStatus(tmBusinessAreaVo);
			return new AjaxJson();
		} catch(Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		
	}
	
	/**
	 * 行政区域列表excel导出
	 * @author wuzhujun
	 * @param custOrgVo 客户组织关系vo
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmBusinessAreaVo tmBusinessAreaVo, HttpServletRequest request, HttpServletResponse response) {
		tmBusinessAreaVo.setExportExcel("true"); //设置为导出状态
		List<TmBusinessAreaVo> tmBusinessAreaVoList = tmBusinessAreaService.findBusinessAreaList(tmBusinessAreaVo);
		doExportXls(response, request, tmBusinessAreaVoList, TmBusinessAreaVo.class, "行政区域列表");
	}
}
