package com.biz.eisp.mdm.businessarea.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaExcelVo;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;

@InterfaceDao
public interface TmBusinessAreaDao {
	
	@Arguments({"tbaVo","page"})
	@ResultType(TmBusinessAreaExcelVo.class)
	public List <TmBusinessAreaExcelVo> findTmBusinessAreaList(TmBusinessAreaExcelVo tbaVo, Page page);
	
	@Arguments({"tmBusinessAreaVo","fields","conditions"})
	@ResultType(TmBusinessAreaVo.class)  
	public List<TmBusinessAreaVo> findNodeBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo, String fields, String conditions);
	
	@Arguments({"tmBusinessAreaVo","fields","conditions"})
	@ResultType(TmBusinessAreaVo.class)  
	public List<TmBusinessAreaVo> findQueryBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo, String fields, String conditions);

	public void updateLeafNode(); 
	
	public void updateNotLeafNode();
	
	@ResultType(TmBusinessAreaEntity.class)
	@Arguments({"vo"})
	public List<TmBusinessAreaEntity> findChildrenBusinessAreaList(TmBusinessAreaVo vo);
	
	@ResultType(TmBusinessAreaVo.class)
	@Arguments({"conditions"})
	public List<TmBusinessAreaVo> findTmBusinessAreaListByConditions(String conditions);
}
