package com.biz.eisp.mdm.businessarea.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;


/** 
 * 业务区域.
 * <p>关联数据库表：tm_business_area<br>
 * @author wan
 * @version v1.0
 */
@Entity
@Table(name = "tm_business_area")
public class TmBusinessAreaEntity extends IdEntity implements Serializable,Loggerable{
	private static final long serialVersionUID = 1L;
	/**
	 * 区域名称
	 */
	private String businessAreaName;
	/**
	 * 区域编码
	 */
	private String businessAreaCode;
	/**
	 * 名称简写
	 */
	private String shortName;
	/*
	 * 区域层级
	 */
	private Integer areaLevel;
	/**
	 * 城市编码
	 */
	private String cityCode;
	/**
	 * 邮编
	 */
	private String zipCode;
	
	/**
	 * 备注说明
	 */
	private String remark;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 跟新时间
	 */
	private Date updateDate;
	/**
	 * 更新人
	 */
	private String updateName;
	/**
	 * 启用停用标志 0：启用 1停用
	 */
	private Integer enableStatus;
	/**
	 * 上级区域ID，对应tm_business_area表id字段
	 */
	private TmBusinessAreaEntity tmBusinessArea;
	/**
	 * 下级区域集合
	 */
	private List<TmBusinessAreaEntity> tmBusinessAreas;
	
	private Integer isLeaf;
	
	/**
	 * 字符类型（length=100）-扩展字段1
	 */
	private String extChar1;
	/**
	 * 字符类型（length=100）-扩展字段2
	 */
	private String extChar2;
	/**
	 * 字符类型（length=100）-扩展字段3
	 */
	private String extChar3;
	/**
	 * 字符类型（length=100）-扩展字段4
	 */
	private String extChar4;
	/**
	 * 数字类型-扩展字段1
	 */
	private Integer extNumber1;
	/**
	 * 数字类型-扩展字段2
	 */
	private Integer extNumber2;
	/**
	 * 数字类型-扩展字段3
	 */
	private Integer extNumber3;
	
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 名称
	 */
	@Column(name = "name",nullable = true)
	public String getBusinessAreaName() {
		return businessAreaName;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 编码
	 */
	@Column(name = "code",nullable = true)
	public String getBusinessAreaCode() {
		return businessAreaCode;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return  java.lang.String 名称简写
	 */
	@Column(name = "short_name")
	public String getShortName() {
		return shortName;
	}
	/**
	 * 方法：取得java.lang.Integer
	 * @return java.lang.Integer 名称简写 
	 */
	@Column(name = "area_level")
	public Integer getAreaLevel() {
		return areaLevel;
	}
	/**
	 * 方法：取得java.lang.String
	 * @return java.lang.String 城市编码
	 */
	@Column(name = "city_code")
	public String getCityCode() {
		return cityCode;
	}
	/**
	 * 方法：取得java.lang.String 
	 * @return java.lang.String  邮编
	 */
	@Column(name = "zip_code")
	public String getZipCode() {
		return zipCode;
	}
	
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 备注
	 */
	@Column(name = "remark")
	public String getRemark() {
		return remark;
	}
	/**
	 * 方法：取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "create_date",nullable = true)
	public Date getCreateDate() {
		return createDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 创建名称
	 */
	@Column(name = "create_name",nullable = true)
	public String getCreateName() {
		return createName;
	}
	/**
	 * 方法:取得java.util.Date 
	 * @return java.util.Date 跟新时间
	 */
	@Column(name = "update_date",nullable = true)
	public Date getUpdateDate() {
		return updateDate;
	}
	/**
	 * 方法:取得java.lang.String 
	 * @return java.lang.String 更新人
	 */
	@Column(name = "update_name",nullable = true)
	public String getUpdateName() {
		return updateName;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer  0：启用 1停用
	 */
	@Column(name = "enable_status",nullable = false)
	public Integer getEnableStatus() {
		return enableStatus;
	}
	/**
	 * 方法：取得com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity
	 * @return com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity 
	 * 上级区域ID，对应tm_business_area表id字段
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "parent_id")
	public TmBusinessAreaEntity getTmBusinessArea() {
		return tmBusinessArea;
	}
	/**
	 * 方法：取得java.util.List<com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity>
	 * @return java.util.List<com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity> 下级区域集合
	 */
	@Fetch(FetchMode.SUBSELECT)
	@OneToMany(cascade = CascadeType.ALL,fetch = FetchType.EAGER,mappedBy = "tmBusinessArea")
	public List<TmBusinessAreaEntity> getTmBusinessAreas() {
		return tmBusinessAreas;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 更新人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 * 方法：设置java.util.Date
	 * @param  java.util.Date 更新时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 名称
	 */
	public void setBusinessAreaName(String businessAreaName) {
		this.businessAreaName = businessAreaName;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 名称简写
	 */
	public void setShortName(String shortName) {
		this.shortName = shortName;
	}
	/**
	 * 方法：设置java.lang.Integer
	 * @param  java.lang.Integer 区域层级
	 */
	public void setAreaLevel(Integer areaLevel) {
		this.areaLevel = areaLevel;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 城市编码
	 */
	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 邮编
	 */
	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}
	
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 备注
	 */
	public void setRemark(String remark) {
		this.remark = remark;
	}
	/**
	 * 方法：设置java.util.Date
	 * @param  java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 编码
	 */
	public void setBusinessAreaCode(String businessAreaCode) {
		this.businessAreaCode = businessAreaCode;
	}
	/**
	 * 方法：设置java.lang.Integer
	 * @param  java.lang.Integer 状态0 启用 ，1停用
	 */
	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}
	/**
	 * 方法：设置com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity
	 * @param com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity 
	 * 		   上级区域ID，对应tm_business_area表id字段
	 */
	public void setTmBusinessArea(TmBusinessAreaEntity tmBusinessArea) {
		if(tmBusinessArea != null && tmBusinessArea.getId().equals(id)) {
			throw new BusinessException("上级区域不能选择当前区域");
		}
		this.tmBusinessArea = tmBusinessArea;
	}
	/**
	 * 方法:java.util.List<com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity>
	 * @param java.util.List<com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity>
	 * 			下级区域集合
	 */
	public void setTmBusinessAreas(List<TmBusinessAreaEntity> tmBusinessAreas) {
		this.tmBusinessAreas = tmBusinessAreas;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 是否是叶子节点
	 */
	@Column(name = "is_leaf")
	public Integer getIsLeaf() {
		return isLeaf;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 是否叶子节点
	 */
	public void setIsLeaf(Integer isLeaf) {
		this.isLeaf = isLeaf;
	}
	
	@Column(name = "ext_char_1")
	public String getExtChar1() {
		return extChar1;
	}
	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}
	@Column(name = "ext_char_2")
	public String getExtChar2() {
		return extChar2;
	}
	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}
	@Column(name = "ext_char_3")
	public String getExtChar3() {
		return extChar3;
	}
	public void setExtChar3(String extChar3) {
		this.extChar3 = extChar3;
	}
	@Column(name = "ext_char_4")
	public String getExtChar4() {
		return extChar4;
	}
	public void setExtChar4(String extChar4) {
		this.extChar4 = extChar4;
	}
	@Column(name = "ext_number_1")
	public Integer getExtNumber1() {
		return extNumber1;
	}
	public void setExtNumber1(Integer extNumber1) {
		this.extNumber1 = extNumber1;
	}
	@Column(name = "ext_number_2")
	public Integer getExtNumber2() {
		return extNumber2;
	}
	public void setExtNumber2(Integer extNumber2) {
		this.extNumber2 = extNumber2;
	}
	@Column(name = "ext_number_3")
	public Integer getExtNumber3() {
		return extNumber3;
	}
	public void setExtNumber3(Integer extNumber3) {
		this.extNumber3 = extNumber3;
	}
	@Override
	public String businessDesc() {
		return "区域基本信息";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}

}
