package com.biz.eisp.mdm.businessarea.service.impl;

import java.util.Map;

import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;

/**
 * 行政区域信息excel导入 
 * @author 肖胜
 * @version v1.0
 */
public class TmBusinessAreaEventHandler extends ImpEventHandler <TmBusinessAreaVo>{
	
	// 行政区域service注入
	private TmBusinessAreaService tmBusinessAreaService = (TmBusinessAreaService) 
			ApplicationContextUtils.getContext().getBean("tmBusinessAreaService");
	
	
	@Override
	public void endRow(Map<String, Object> row, TmBusinessAreaVo bean) throws ValidateException {
		try {
			Page page = new EuPage();
			tmBusinessAreaService.saveTmBusinessArea(bean, page);	//执行保存
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		//设置已成功导入条数
		setSuccNum(getSuccNum()+1);
	}

	public void end() {
		//保存完毕后 更新叶子节点状态. 
		tmBusinessAreaService.updateTmBusinessAreaIsLeaf();
	}
	
}
