package com.biz.eisp.mdm.businessarea.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.businessarea.dao.TmBusinessAreaDao;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaExtendService;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.transformer.TmBusinessAreaEntityToTmBusinessAreaVo;
import com.biz.eisp.mdm.businessarea.transformer.TmBusinessAreaVoToTmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaExcelVo;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.google.common.collect.Lists;

/** 业务区域 服务层实现.
 * <p>
 * @author wan
 * @version v1.0
 */
@Service("tmBusinessAreaService")
@Transactional
public class TmBusinessAreaServiceImpl extends BaseServiceImpl implements TmBusinessAreaService{
	/**
	 * 注入Dao接口.
	 */
	@Autowired
	private TmBusinessAreaDao tmBusinessAreaDao; 
	/**
	 * 注入扩展service
	 */
	@Autowired(required=false)
	private TmBusinessAreaExtendService tmBusinessAreaExtendService;
	
	@Override
	public void saveTmBusinessArea(TmBusinessAreaVo tmBusinessAreaVo, Page page) {
		TmBusinessAreaEntity tmBusinessAreaEntity =null;
		//保存前扩展 此时entity还未通过vo转换
		if(StringUtil.isNotEmpty(tmBusinessAreaExtendService)){
			//验证
			try {
				tmBusinessAreaExtendService.validate(tmBusinessAreaVo, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:"+e.getMessage());
			}
			//扩展
			tmBusinessAreaEntity = tmBusinessAreaExtendService.saveBefore(tmBusinessAreaVo, page);
		}
		//如果entity为null 则通过vo转换
		if(StringUtil.isEmpty(tmBusinessAreaEntity)){
			tmBusinessAreaEntity = new TmBusinessAreaVoToTmBusinessAreaEntity(this).apply(tmBusinessAreaVo);
		}
		//保存前扩展 此时entity已经通过vo转换
		if(StringUtil.isNotEmpty(tmBusinessAreaExtendService)){
			tmBusinessAreaEntity = tmBusinessAreaExtendService.saveBefore(tmBusinessAreaEntity, tmBusinessAreaVo, page);
		}
		//保存
		saveOrUpdate(tmBusinessAreaEntity);
		//保存后扩展
		if(StringUtil.isNotEmpty(tmBusinessAreaExtendService)){
			tmBusinessAreaEntity = tmBusinessAreaExtendService.savePost(tmBusinessAreaEntity, tmBusinessAreaVo, page);
		}
	}
	
	@Override
	public void deleteTmBusinessArea(String id) {
		TmBusinessAreaEntity tbaEntity = get(TmBusinessAreaEntity.class, id);
		if(tbaEntity.getIsLeaf() == 0) {
			throw new BusinessException("存在子节点不能删除");
		}
		delete(tbaEntity);
	}
	
	@Override
	public void updateBusinessAreaEnableStatus(TmBusinessAreaVo tmBusinessAreaVo) {
		TmBusinessAreaEntity entity = get(TmBusinessAreaEntity.class, tmBusinessAreaVo.getId());		
		entity.setEnableStatus(tmBusinessAreaVo.getEnableStatus());
		updateEntity(entity);
	}
	
	@Override
	public List<ComboBox> findBusinessAreaCombobox(TmBusinessAreaExcelVo tba) {
		String sql="select distinct  t.name text,t.name value  from tm_business_area t "
				+ "left join  tm_business_area t1 on t1.id=t.PARENT_ID where 1=1";
		List<ComboBox> comList=new ArrayList<>();
		ComboBox comboBox=new ComboBox();
		comboBox.setSelected(false);
		comboBox.setText("请选择");
		comboBox.setValue("");
		comList.add(comboBox);
		if(StringUtil.isNotEmpty(tba.getAreaLevel())){
			sql+=" and t.AREA_LEVEL=?";
			List<ComboBox> comList1= this.findBySql(ComboBox.class,sql, tba.getAreaLevel());
			comList.addAll(comList1);
		}
		if(StringUtil.isNotEmpty(tba.getBusinessAreaName())){
			sql+=" and t1.name=?";
			List<ComboBox> comList2= this.findBySql(ComboBox.class,sql, tba.getBusinessAreaName());
			comList.addAll(comList2);
		}
	
		return comList;
	}
	
	@Override
	public boolean validate(String id,String param,String fieldName) {
		
		Criterion cr1 = Restrictions.eq(fieldName, param);
		List<TmBusinessAreaEntity> tmtbas = new ArrayList<TmBusinessAreaEntity>();
		if(StringUtil.isNotEmpty(id)){
			Criterion cr2 = Restrictions.ne("id", id);
			tmtbas = findByCriteria(TmBusinessAreaEntity.class, cr1, cr2);
		}else{
			tmtbas = findByCriteria(TmBusinessAreaEntity.class, cr1);
		}
		if(!CollectionUtils.isEmpty(tmtbas)){
			return true;
		}
		return false;
	}
	
	@Override
	public List<TmBusinessAreaVo> findBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo) {
		//动态sql
		String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_BUSINESS_AREA, tmBusinessAreaVo);
		List <TmBusinessAreaVo> voList = findBySql(TmBusinessAreaVo.class, sql);
		//如果有查询条件 则组装树形
		if(DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_BUSINESS_AREA, tmBusinessAreaVo)) {
			voList = this.findQueryBusinessAreaList(tmBusinessAreaVo, voList);
		}
		return voList;
	}
	
	@Override
	public List <TmBusinessAreaVo> findTmBusinessAreaComboTree(TmBusinessAreaVo tmBusinessAreaVo, String selfId) {
		List <TmBusinessAreaVo> voList = null;
		if(StringUtils.isNotBlank(selfId)) {
			List <TmBusinessAreaEntity> entityList = this.findByProperty(TmBusinessAreaEntity.class, "id", selfId);
			voList = Lists.transform(entityList, new TmBusinessAreaEntityToTmBusinessAreaVo()); 
		} else {
			voList = this.findBusinessAreaList(tmBusinessAreaVo);
		}
		return voList;
	}
	
	/**
	 * 拥有查询条件的方式，查询出整棵树的数据出来.
	 * <p>
	 * @param tmBusinessAreaVo 区域Vo对象， 主要传递查询条件值
	 * @param fields
	 * @param conditions
	 * @return
	 */
	private List <TmBusinessAreaVo> findQueryBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo, List <TmBusinessAreaVo> voList) {
		//如果是导出，即不用组装成TreeGrid 带有children的树形截至值，直接返回列表值
		if(tmBusinessAreaVo.getExportExcel().equals("true")) {
			return voList;
		}
		//构造成树状值传回
		List <TmBusinessAreaVo> allQueryVoList = TreeGridUtil.buildTreeGrid(voList);
		return allQueryVoList;
	}
	
	@Override
	public void updateTmBusinessAreaIsLeaf() {
		tmBusinessAreaDao.updateLeafNode();
		tmBusinessAreaDao.updateNotLeafNode();
	}
	
	@Override
	public TmBusinessAreaVo getTmBusinessAreaVo(String id) {
		TmBusinessAreaEntity entity = this.get(TmBusinessAreaEntity.class, id);
		TmBusinessAreaVo vo = new TmBusinessAreaEntityToTmBusinessAreaVo().apply(entity);
		return vo;
	}

	@Override
	public List<ComboTree> findChildrenBusinessArea(TmBusinessAreaVo vo) {
		if(StringUtils.isNotBlank(vo.getId())){
			List<TmBusinessAreaEntity> list = tmBusinessAreaDao.findChildrenBusinessAreaList(vo);
			for(TmBusinessAreaEntity entity : list){
				String id = entity.getId();
				String sql = "select * from tm_business_area t where t.parent_id = ?";
				List<TmBusinessAreaEntity> lists = findBySql(TmBusinessAreaEntity.class, sql, id);
				entity.setTmBusinessAreas(lists);
			}
			ComboTreeModel comboTreeModel = new ComboTreeModel("id", "businessAreaName", "tmBusinessAreas");
			List<ComboTree> comboTrees = this.comboTree(list, comboTreeModel, null, false);
			return comboTrees;
		}else{
			return null;
		}
	}

	@Override
	public List<TmBusinessAreaVo> findBusinessAreaLists(String conditions) {
		List<TmBusinessAreaVo> list = null;
		if(StringUtils.isNotBlank(conditions)){
			list = tmBusinessAreaDao.findTmBusinessAreaListByConditions(conditions);
		}
		return list;
	}
}
