package com.biz.eisp.mdm.businessarea.transformer;

import org.springframework.beans.BeanUtils;

import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;
import com.google.common.base.Function;

/**
 * TmBusinessAreaEntity 转换 TmBusinessAreaVo.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class TmBusinessAreaEntityToTmBusinessAreaVo implements Function<TmBusinessAreaEntity, TmBusinessAreaVo> {

	@Override
	public TmBusinessAreaVo apply(TmBusinessAreaEntity entity) {
		if(entity == null) {
			return null;
		}
		TmBusinessAreaVo vo = new TmBusinessAreaVo();
		BeanUtils.copyProperties(entity, vo);
		
		TmBusinessAreaEntity parentEntity = entity.getTmBusinessArea();
		if(parentEntity != null) {
			vo.setParentId(parentEntity.getId());
			vo.setParentName(parentEntity.getBusinessAreaName());
			vo.setParentCode(parentEntity.getBusinessAreaCode());
		}
		vo.setText(entity.getBusinessAreaName());
		
		return vo;
	}

}
