package com.biz.eisp.mdm.businessarea.transformer;


import com.biz.eisp.base.common.constant.Globals;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaExcelVo;
import com.google.common.base.Function;

/** 
 * vo→po
 * @author wan
 * @version v1.0
 */
public class TmBusinessAreaTransFormPo implements Function<TmBusinessAreaExcelVo, TmBusinessAreaEntity>{
	/**
	 * 注入service
	 */
	private TmBusinessAreaService tmBusinessAreaService = (TmBusinessAreaService) ApplicationContextUtils.getContext().getBean("tmBusinessAreaService");
	@Override
	public TmBusinessAreaEntity apply(TmBusinessAreaExcelVo t) {
		TmBusinessAreaEntity tmBusinessAreaEntity = null;
		//判断是新增还是修改
		if(StringUtil.isNotEmpty(t.getId())){
			tmBusinessAreaEntity = tmBusinessAreaService.get(TmBusinessAreaEntity.class, t.getId());
			if(StringUtil.isNotEmpty(t.getBusinessAreaName())){
				if(tmBusinessAreaService.validate(t.getId(),t.getBusinessAreaName() , "name")){
					throw new BusinessException("转换行政区域关系Vo到Po时，行政区域"+ t.getBusinessAreaName()+"已存在" );
				}
			}else{
				throw new BusinessException("行政区域名称不能为空" );
			}
			if(StringUtil.isNotEmpty(t.getBusinessAreaCode())){
				if(tmBusinessAreaService.validate(t.getId(),t.getBusinessAreaCode() , "code")){
					throw new BusinessException("转换行政区域关系Vo到Po时，行政区域编码"+ t.getBusinessAreaCode()+"已存在" );
				}
			}else{
				throw new BusinessException("行政区域编码不能为空" );
			}
			
		}else{
			tmBusinessAreaEntity  = new TmBusinessAreaEntity();

			if(StringUtil.isNotEmpty(t.getBusinessAreaName())){
				if(tmBusinessAreaService.validate(null,t.getBusinessAreaName() , "name")){
					throw new BusinessException("转换行政区域关系Vo到Po时，行政区域"+ t.getBusinessAreaName()+"已存在" );
				}
			}else{
				throw new BusinessException("行政区域名称不能为空" );
			}
			if(StringUtil.isNotEmpty(t.getBusinessAreaCode())){
				if(tmBusinessAreaService.validate(null,t.getBusinessAreaCode() , "code")){
					throw new BusinessException("转换行政区域关系Vo到Po时，行政区域编码"+ t.getBusinessAreaCode()+"已存在" );
				}
			}else{
				throw new BusinessException("行政区域编码不能为空" );
			}
		}
		
		try {
			MyBeanUtils.copyBeanNotNull2Bean(t, tmBusinessAreaEntity);
		} catch (Exception e) {
			e.printStackTrace();
		}
		//装载上级行政区域关系实体
		if(StringUtil.isNotEmpty(t.getParentId())||
				StringUtil.isNotEmpty(t.getParentName())){
			TmBusinessAreaEntity busEntity = null;
			if(StringUtil.isNotEmpty(t.getParentId())){
				//导入时parentId为code
				busEntity = tmBusinessAreaService.get(TmBusinessAreaEntity.class,t.getParentId() );
			}
			if(StringUtil.isNotEmpty(t.getParentName())){
				//导入时parentId为code
				busEntity=tmBusinessAreaService.findUniqueByProperty(TmBusinessAreaEntity.class, "code", t.getParentName());
			}
			if(busEntity == null){
				throw new BusinessException("转换行政区域关系Vo到Po时，上级行政区域找不到:" +t.getParentId());
			}
			tmBusinessAreaEntity.setTmBusinessArea(busEntity);
		}
		tmBusinessAreaEntity.setEnableStatus(Globals.ZERO);
		return tmBusinessAreaEntity;
	}

}
