package com.biz.eisp.mdm.businessarea.transformer;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class TmBusinessAreaVoToTmBusinessAreaEntity implements Function <TmBusinessAreaVo, TmBusinessAreaEntity>{

	private TmBusinessAreaService tmBusinessAreaService;
	
	public TmBusinessAreaVoToTmBusinessAreaEntity(TmBusinessAreaService tmBusinessAreaService) {
		this.tmBusinessAreaService = tmBusinessAreaService;
	}
	
	
	@Override
	public TmBusinessAreaEntity apply(TmBusinessAreaVo vo) {
		if(vo == null) {
			return null;
		}
		
		TmBusinessAreaEntity tmBusinessAreaEntity = null;
		//判断是新增还是修改
		if(StringUtil.isNotEmpty(vo.getId())){
			tmBusinessAreaEntity = tmBusinessAreaService.get(TmBusinessAreaEntity.class, vo.getId());
		}else{
			tmBusinessAreaEntity  = new TmBusinessAreaEntity();
		}
		
		
		//名称非空与重复验证
		if(StringUtil.isNotEmpty(vo.getBusinessAreaName())){
//			if(tmBusinessAreaService.validate(vo.getId(), vo.getBusinessAreaName() , "businessAreaName")){
//				throw new BusinessException("转换行政区域关系Vo到Po时，行政区域"+ vo.getBusinessAreaName()+"已存在" );
//			}
		}else{
			throw new BusinessException("行政区域名称不能为空" );
		}
		
		
		//编码非空与重复验证
		if(StringUtil.isNotEmpty(vo.getBusinessAreaCode())){
			if(tmBusinessAreaService.validate(vo.getId(), vo.getBusinessAreaCode() , "businessAreaCode")){
				throw new BusinessException("转换行政区域关系Vo到Po时，行政区域编码"+ vo.getBusinessAreaCode()+"已存在" );
			}
		}else{
			throw new BusinessException("行政区域编码不能为空" );
		}
		
		try {
			BeanUtils.copyProperties(vo, tmBusinessAreaEntity);
			if(StringUtils.isBlank(vo.getId())) {
				tmBusinessAreaEntity.setEnableStatus(Globals.ZERO);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		//装载上级行政区域关系实体
		if(StringUtil.isNotEmpty(vo.getParentId())||
				StringUtil.isNotEmpty(vo.getParentName())){
			TmBusinessAreaEntity busEntity = null;
			if(StringUtil.isNotEmpty(vo.getParentId())){
				//导入时parentId为code
				busEntity = tmBusinessAreaService.get(TmBusinessAreaEntity.class, vo.getParentId() );
			}
			if(StringUtil.isNotEmpty(vo.getParentCode())){
				//导入时parentId为code
				busEntity=tmBusinessAreaService.findUniqueByProperty(TmBusinessAreaEntity.class, "businessAreaCode", vo.getParentCode());
			}
			if(busEntity == null){
				throw new BusinessException("转换行政区域关系Vo到Po时，上级行政区域找不到:" + vo.getParentId());
			}
			tmBusinessAreaEntity.setTmBusinessArea(busEntity);
		}
		
		return tmBusinessAreaEntity;
	}

}
