package com.biz.eisp.mdm.businessarea.transformer;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaExcelVo;
import com.google.common.base.Function;

/**
 * 行政区域管理po转vo
 * @author wuzhujun
 * @version v1.0
 */
public class TmBusinessEntityToTmBusinessVo implements Function<TmBusinessAreaEntity, TmBusinessAreaExcelVo>{
	public TmBusinessEntityToTmBusinessVo(TmBusinessAreaService businessAreaService){
		super();
		this.businessAreaService = businessAreaService;
	}
	private TmBusinessAreaService businessAreaService;
	@Override
	public TmBusinessAreaExcelVo apply(TmBusinessAreaEntity entity) {
		TmBusinessAreaExcelVo tmBusinessAreaVo = new TmBusinessAreaExcelVo();
		try {
			entity = businessAreaService.get(TmBusinessAreaEntity.class, entity.getId());
			MyBeanUtils.copyBeanNotNull2Bean(entity,tmBusinessAreaVo);
			if(StringUtil.isNotEmpty(entity.getTmBusinessArea())){
				tmBusinessAreaVo.setParentId(entity.getTmBusinessArea().getId());
				tmBusinessAreaVo.setParentName(entity.getTmBusinessArea().getBusinessAreaName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return tmBusinessAreaVo;
	}
}
