package com.biz.eisp.mdm.businessarea.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.biz.eisp.base.exporter.annotation.Excel;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;



/** 
 * 业务区域.
 * @author wan
 * @version v1.0
 */
public class TmBusinessAreaExcelVo implements Serializable{
	private static final long serialVersionUID = 1L;
	private String id;
	//区域名称
	@Excel(exportName = "区域名称", exportFieldWidth = 20,tableName="tm_business_area")
	private String businessAreaName;
	@Excel(exportName = "区域编码", exportFieldWidth = 20,tableName="tm_business_area")
	private String businessAreaCode;
	//上级区域id,对应tm_business_area的id字段
	private TmBusinessAreaEntity tmBusinessArea;
	//名称简写
	@Excel(exportName = "名称简写", exportFieldWidth = 20,tableName="tm_business_area")
	private String shortName;
	//城市编码
	@Excel(exportName = "城市编码", exportFieldWidth = 20,tableName="tm_business_area")
	private String cityCode;
	//区域层级
	@Excel(exportName = "区域层级", exportFieldWidth = 20,dicCode = "area_level",tableName="tm_business_area")
	private Integer areaLevel;
	//上级
	@Excel(exportName = "上级区域", exportFieldWidth = 20,tableName="tm_business_area")
	private String parentName;
	//邮编
	@Excel(exportName = "邮编", exportFieldWidth = 20,tableName="tm_business_area")
	private String zipCode;
	//区域简写合并
	@Excel(exportName = "区域简写合并", exportFieldWidth = 20,tableName="tm_business_area")
	private String mergerShortName;
	//备注说明
	@Excel(exportName = "备注", exportFieldWidth = 20,tableName="tm_business_area")
	private String remark;
	//创建时间
	@Excel(exportName = "创建时间", exportFieldWidth = 20,tableName="tm_business_area")
	private Date createDate;
	//创建用户账号，对应tm_user表中的username字段值
	@Excel(exportName = "创建人", exportFieldWidth = 20,tableName="tm_business_area")
	private String createName;
	//修改时间
	@Excel(exportName = "修改时间", exportFieldWidth = 20,tableName="tm_business_area")
	private Date updateDate;
	//修改用户账号，对应tm_user表中的username字段值
	@Excel(exportName = "修改人", exportFieldWidth = 20,tableName="tm_business_area")
	private String updateName;
	//状态
	@Excel(exportName = "状态", exportFieldWidth = 20,dicCode = "enable_status",tableName="tm_business_area")
	private Integer enableStatus;
	//所属该区域的下面的所有区域
	private List<TmBusinessAreaEntity> tmBusinessAreas;
	private String parentId;
	/**
	 * 得到区域名称.
	 * @author wan
	 * @return String 区域名称
	 */
	public String getBusinessAreaName() {
		return businessAreaName;
	}
	/**
	 * 设置区域名称.
	 * @author wan
	 * @param name 区域名称
	 */
	public void setBusinessAreaName(String businessAreaName) {
		this.businessAreaName = businessAreaName;
	}
	/**
	 * 上级区域ID，对应tm_business_area表id字段.
	 * @author wan
	 * @return String 上级区域id
	 */
	public TmBusinessAreaEntity getTmBusinessArea() {
		return tmBusinessArea;
	}
	/**
	 * 设置上级区域id.
	 * @author wan
	 * @param parentId 上级区域id
	 */
	public void setTmBusinessArea(TmBusinessAreaEntity tmBusinessArea) {
		this.tmBusinessArea = tmBusinessArea;
	}
	/**
	 * 得到名称简写.
	 * @author wan
	 * @return String 名称简写
	 */
	public String getShortName() {
		return shortName;
	}
	/**
	 * 设置名称简写
	 * @author wan
	 * @param shortName 名称简写
	 */
	public void setShortName(String shortName) {
		this.shortName = shortName;
	}
	/**
	 * 得到区域层级
	 * @author wan
	 * @return Integer 区域成级
	 */
	public Integer getAreaLevel() {
		return areaLevel;
	}
	/**
	 * 设置区域成级
	 * @author wan
	 * @param areaLevel 区域成级
	 */
	public void setAreaLevel(Integer areaLevel) {
		this.areaLevel = areaLevel;
	}
	
	/**
	 * 得到城市编码
	 * @author wan
	 * @return String 城市编码
	 */
	public String getCityCode() {
		return cityCode;
	}
	/**
	 * 设置城市编码
	 * @author wan
	 * @param cityCode 城市编码
	 */
	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	}
	/**
	 * 得到邮编
	 * @author wan
	 * @return String 邮编
	 */
	public String getZipCode() {
		return zipCode;
	}
	/**
	 * 设置邮编
	 * @author wan
	 * @param zipCode String 邮编
	 */
	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}
	/**
	 * 得到区域简写合并
	 * @author wan
	 * @return String 区域简写合并
	 */
	public String getMergerShortName() {
		return mergerShortName;
	}
	/**
	 * 设置 MERGER_SHORT_NAME 区域简写合并
	 * @author wan
	 * @param mergerShortName 区域简写合并
	 */
	public void setMergerShortName(String mergerShortName) {
		this.mergerShortName = mergerShortName;
	}
	/**
	 * 得到备注
	 * @author wan
	 * @return String 备注
	 */
	public String getRemark() {
		return remark;
	}
	/**
	 * 设置备注
	 * @author wan
	 * @param remark String 备注
	 */
	public void setRemark(String remark) {
		this.remark = remark;
	}
	/**
	 * 设置创建时间
	 * @author wan
	 * @return java.util.Date 创建时间
	 */
	public Date getCreateDate() {
		return createDate;
	}
	/**
	 * 设置创建时间
	 * @author wan
	 * @param createDate 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 创建用户帐号，对应tm_user表中的username字段值
	 * @author wan
	 * @return String 创建用户帐号
	 */
	public String getCreateName() {
		return createName;
	}
	/**
	 * 设置用户帐号
	 * @author wan
	 * @param createName 用户账号，对应tm_user表中的username字段值
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 * 得到修改时间
	 * @author wan
	 * @return 修改时间
	 */
	public Date getUpdateDate() {
		return updateDate;
	}
	/**
	 * 设置修改时间
	 * @author wan
	 * @param updateDate 修改时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 * 得到 修改用户帐号 对应tm_user表中的username字段值
	 * @author wan
	 * @return 修改用户帐号
	 */
	public String getUpdateName() {
		return updateName;
	}
	/**
	 * 设置修改用户帐号
	 * @author wan
	 * @param updateName 修改用户帐号 对应tm_user表中的username字段值
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 * 得到该区域下面所属的所有区域
	 * @author wan
	 * @return com.biz.eisp.mdm.business.TmBusinessArea
	 */
	public List<TmBusinessAreaEntity> getTmBusinessAreas() {
		return tmBusinessAreas;
	}
	/**
	 * 设置该区域下面所属的所有区域.
	 * @author wan
	 * @param tmBusinessAreas 区域
	 */
	public void setTmBusinessAreas(List<TmBusinessAreaEntity> tmBusinessAreas) {
		this.tmBusinessAreas = tmBusinessAreas;
	}
	/**
	 * getter id
	 * @return 主键
	 */
	public String getId() {
		return id;
	}
	/**
	 * setter id  
	 * @param id 主键 
	 */
	public void setId(String id) {
		this.id = id;
	}
	public String getParentId() {
		return parentId;
	}
	public void setParentId(String parentId) {
		this.parentId = parentId;
	}
	public String getBusinessAreaCode() {
		return businessAreaCode;
	}
	public void setBusinessAreaCode(String businessAreaCode) {
		this.businessAreaCode = businessAreaCode;
	}
	/**
	 * getter parentName
	 * @return parentName
	 */
	public String getParentName() {
		return parentName;
	}
	/**
	 * setter parentName   
	 */
	public void setParentName(String parentName) {
		this.parentName = parentName;
	}
	public Integer getEnableStatus() {
		return enableStatus;
	}
	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}
}
