/**
 * 描述.
 */
package com.biz.eisp.mdm.config.controller;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.config.entity.TmCgDynamicHeadEntity;
import com.biz.eisp.mdm.config.entity.TmCgDynamicItemEntity;
import com.biz.eisp.mdm.config.service.TmCgDynamicService;
import com.biz.eisp.mdm.config.vo.TmCgDynamicHeadVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 
 * 动态报表配置功能
 * @author xuduan
 * @version v1.0
 */
@Controller
@RequestMapping("/cgDynamicController")
public class CgDynamicHeadController extends BaseController {
	
	 @Autowired
     private TmCgDynamicService tmCgDynamicService;
	 /**
     * 动态报表配置抬头列表 页面跳转
     * 
     * @return
     */
    @RequestMapping(value = "goCgDynamicHead",method = {RequestMethod.GET,RequestMethod.POST})
    public ModelAndView cgDynamicHead(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/cgreport/core/cgreportConfigHeadList");
    }

    @RequestMapping(value = "goModifyDynamicHead", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView modifyDynamicHead(TmCgDynamicHeadVo cgDynamicHeadVo, HttpServletRequest request) {
        String action = request.getParameter("action");
        if (StringUtil.isNotEmpty(cgDynamicHeadVo.getId())) {
            TmCgDynamicHeadEntity cgreportConfigHead = tmCgDynamicService.get(TmCgDynamicHeadEntity.class,
                    cgDynamicHeadVo.getId());

            // ===================================================================================
            // 获取参数
            Object id0 = cgDynamicHeadVo.getId();
            // ===================================================================================
            // 查询-动态报表配置明细
            String hql0 = "from TmCgDynamicItemEntity where 1 = 1 AND CGRHEAD_ID = ? ";
            try {
                List<TmCgDynamicItemEntity> cgreportConfigItemEntityList = tmCgDynamicService.findByHql(hql0, id0);
                request.setAttribute("cgreportConfigItemList", cgreportConfigItemEntityList);
                request.setAttribute("cgreportConfigHead", cgreportConfigHead);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        if (action.equals("add")) {
            return new ModelAndView("com/biz/eisp/cgreport/core/cgreportConfigHead-add");
        } else {
            return new ModelAndView("com/biz/eisp/cgreport/core/cgreportConfigHead-update");
        }
    }

    /**·
     * easyui AJAX请求数据
     * 
     * @param request
     * @param response
     */

    @RequestMapping(value = "findCgDynamicHeadList", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findCgDynamicHeadList(TmCgDynamicHeadVo cgDynamicHeadVo, HttpServletRequest request,
                    HttpServletResponse response) {
        Page page = new EuPage(request);
		
		List <TmCgDynamicHeadVo> tmheadVoList = tmCgDynamicService.findCgDynamicHeadList(cgDynamicHeadVo, page);
		
		return new DataGrid(tmheadVoList, page);
    }

    /**
     * 删除动态报表配置抬头
     * 
     * @return
     */
    @RequestMapping(value = "deleteCgDynamicHead", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteCgDynamicHead(TmCgDynamicHeadVo cgDynamicHeadVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
			tmCgDynamicService.deleteCgDynamicHead(cgDynamicHeadVo.getId());
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("删除失败");
			e.printStackTrace();
		}
        return j;
    }

    /**
     * 批量删除动态报表配置抬头
     * 
     * @return
     */
    @RequestMapping(value = "deleteCgDynamicHeadAll",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteCgDynamicHeadAll(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        message = "动态报表配置抬头删除成功";
        try {
            for (String id : ids.split(",")) {
            	tmCgDynamicService.deleteCgDynamicHead(id);
            }
        } catch (Exception e) {
            e.printStackTrace();
            message = "动态报表配置抬头删除失败";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    /**
     * 添加动态报表配置抬头
     * @param cgDynamicHeadVo
     * @param request
     * @return
     */
    @RequestMapping(value = "saveCgDynamicHead", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveCgDynamicHead(TmCgDynamicHeadVo cgDynamicHeadVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        message = "添加成功";
        try {
            TmCgDynamicHeadEntity cghead = new TmCgDynamicHeadEntity();
            MyBeanUtils.copyBeanNotNull2Bean(cgDynamicHeadVo, cghead);
            tmCgDynamicService.saveCgDynamicHead(cghead, cgDynamicHeadVo.getItemlist());
        } catch (Exception e) {
            e.printStackTrace();
            message = "动态报表配置抬头添加失败";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    /**
     * 更新动态报表配置抬头
     * 
     * @param ids
     * @return
     */
    @RequestMapping(value = "updateCgDynamicHead", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson updateCgDynamicHead(TmCgDynamicHeadVo cgDynamicHeadVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        message = "更新成功";
        try {
        	tmCgDynamicService.updateCgDynamicHead(cgDynamicHeadVo,cgDynamicHeadVo.getItemlist());
        } catch (Exception e) {
            e.printStackTrace();
            message = "更新动态报表配置抬头失败";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    /**
     * 动态报表配置抬头新增页面跳转/动态报表配置抬头编辑页面跳转
     * 
     * @return
     */
    @SuppressWarnings("deprecation")
	@RequestMapping(value = "goCgDynamicHeadForm",method = {RequestMethod.GET,RequestMethod.POST})
    public ModelAndView goCgDynamicHeadForm(TmCgDynamicHeadVo cgDynamicHeadVo, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(cgDynamicHeadVo.getId())) {
        	TmCgDynamicHeadEntity  cgDynamicHead = tmCgDynamicService.get(TmCgDynamicHeadEntity.class,
        			cgDynamicHeadVo.getId());
            req.setAttribute("cgDynamicHead", cgDynamicHead);
        }
        return new ModelAndView("eisp/cgreport/core/cgreportConfigHead-add");
    }


    /**
     * 加载明细列表[动态报表配置明细]
     *
     * @return
     */
    @RequestMapping(value = "cgreportConfigItemList",method = {RequestMethod.GET,RequestMethod.POST})
    public ModelAndView cgreportConfigItemList(TmCgDynamicHeadVo cgDynamicHeadVo, HttpServletRequest req) {

        // ===================================================================================
        // 获取参数
        Object id0 = cgDynamicHeadVo.getId();
        // ===================================================================================
        // 查询-动态报表配置明细
        String hql0 = "from TmCgDynamicItemEntity where 1 = 1 AND CGRHEAD_ID = ? ";
        try {
            List<TmCgDynamicItemEntity> cgreportConfigItemEntityList = tmCgDynamicService.findByHql(hql0, id0);
            req.setAttribute("cgreportConfigItemList", cgreportConfigItemEntityList);
        } catch (Exception e) {
           e.printStackTrace();
        }
        return new ModelAndView("com/biz/eisp/cgreport/core/cgreportConfigItemList");
    }

    /**
     * 解析SQL，返回字段集
     *
     * @param sql
     * @return
     */
    @SuppressWarnings("unchecked")
    @RequestMapping(value = "getFields", method = RequestMethod.POST)
    @ResponseBody
    public Object getSqlFields(String sql) {
        List<String> result = null;
        Map reJson = new HashMap<String, Object>();
        try {
            result = tmCgDynamicService.getSqlFields(sql);
        } catch (Exception e) {
            e.printStackTrace();
            String errorInfo = "解析失败!<br><br>失败原因：";
            errorInfo += e.getMessage();
            reJson.put("status", "error");
            reJson.put("datas", errorInfo);
            return reJson;
        }
        reJson.put("status", "success");
        reJson.put("datas", result);
        return reJson;
    }
}
