package com.biz.eisp.mdm.config.controller;

import com.biz.eisp.base.common.constant.CgReportConstant;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.mdm.config.service.TmCgDynamicService;
import com.biz.eisp.mdm.config.util.CgReportQueryParamUtil;
import com.biz.eisp.mdm.config.util.QueryParamUtil;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 动态报表展示功能
 *
 * @author xuduan
 * @version v1.0
 */
@Controller
@RequestMapping("/cgDynamicListController")
public class CgDynamicListController extends BaseController {

    @Autowired
    private TmCgDynamicService tmCgDynamicService;

    /**
     * popup入口
     *
     * @param id       动态配置ID-code
     * @param request
     * @param response
     */
    @SuppressWarnings("unchecked")
    @RequestMapping(value = "popup",method = {RequestMethod.GET,RequestMethod.POST})
    public void popup(String id, HttpServletRequest request,
                      HttpServletResponse response) {
        //step.1 根据id获取该动态报表的配置参数
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = tmCgDynamicService.queryCgReportConfig(id);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("动态报表配置不存在!");
        }
        //step.2 获取列表ftl模板路径
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        //step.3 组合模板+数据参数，进行页面展现
        loadVars(cgReportMap);
        String html = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/cg/cgpublistpopup.ftl", cgReportMap);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    /**
     * 动态报表数据查询
     *
     * @param configId
     *            配置id-code
     * @param page
     *            分页页面
     * @param rows
     *            分页大小
     * @param request
     * @param response
     */
    @SuppressWarnings("unchecked")
    @RequestMapping(value = "datagrid",method = {RequestMethod.GET,RequestMethod.POST})
    public void datagrid(String configId, String page, String field, String rows, HttpServletRequest request,
                         HttpServletResponse response) {
        // step.1 根据id获取该动态报表的配置参数
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = tmCgDynamicService.queryCgReportConfig(configId);
            if (cgReportMap.size() <= 0) {
                throw new RuntimeException("动态报表配置不存在!");
            }
        } catch (Exception e) {
            throw new RuntimeException("查找动态报表配置失败!" + e.getMessage());
        }
        // step.2 获取该配置的查询SQL
        Map configM = (Map) cgReportMap.get(CgReportConstant.MAIN);
        String querySql = (String) configM.get(CgReportConstant.CONFIG_SQL);
        List<Map<String, Object>> items = (List<Map<String, Object>>) cgReportMap.get(CgReportConstant.ITEMS);
        Map queryparams = new LinkedHashMap<String, Object>();
        for (Map<String, Object> item : items) {
            String isQuery = (String) item.get(CgReportConstant.ITEM_ISQUERY);
            if (CgReportConstant.BOOL_TRUE.equalsIgnoreCase(isQuery)) {
                // step.3 装载查询条件
                CgReportQueryParamUtil.loadQueryParams(request, item, queryparams);
            }
        }
        // step.4 进行查询返回结果
        int p = page == null ? 1 : Integer.parseInt(page);
        int r = rows == null ? 99999 : Integer.parseInt(rows);
        List<Map<String, Object>> result = tmCgDynamicService.queryByCgReportSql(querySql, queryparams, p, r);
        long size = tmCgDynamicService.countQueryByCgReportSql(querySql, queryparams);
        dealDic(result, items);
        dealReplace(result, items);
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        PrintWriter writer;
        try {
            writer = response.getWriter();
            writer.println(QueryParamUtil.getJson(result, size));
            writer.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    /**
     * 组装模版参数
     *
     * @param cgReportMap
     */
    @SuppressWarnings("unchecked")
    private void loadVars(Map<String, Object> cgReportMap) {
        Map mainM = (Map) cgReportMap.get(CgReportConstant.MAIN);
        List<Map<String, Object>> fieldList = (List<Map<String, Object>>) cgReportMap.get(CgReportConstant.ITEMS);
        List<Map<String, Object>> queryList = new ArrayList<Map<String, Object>>(0);
        for (Map<String, Object> fl : fieldList) {
            fl.put(CgReportConstant.ITEM_FIELDNAME.toUpperCase(), ((String) fl.get(CgReportConstant.ITEM_FIELDNAME)).toLowerCase());
            String isQuery = (String) fl.get(CgReportConstant.ITEM_ISQUERY.toUpperCase());
            if (com.biz.eisp.base.common.util.StringUtil.isNotEmpty(isQuery)) {
                loadDic(fl, fl);
                queryList.add(fl);
            }
        }
        cgReportMap.put(CgReportConstant.CONFIG_ID, mainM.get("code"));
        cgReportMap.put(CgReportConstant.CONFIG_NAME, mainM.get("name"));
        cgReportMap.put(CgReportConstant.CONFIG_FIELDLIST, fieldList);
        cgReportMap.put(CgReportConstant.CONFIG_QUERYLIST, queryList);
    }


    /**
     * 装载数据字典
     *
     * @param m           要放入freemarker的数据
     * @param cgReportMap 读取出来的动态配置数据
     */
    @SuppressWarnings("unchecked")
    private void loadDic(Map m, Map<String, Object> cgReportMap) {
        String dict_code = (String) cgReportMap.get("dict_code");
        if (StringUtil.isEmpty(dict_code)) {
            m.put(CgReportConstant.FIELD_DICTLIST, new ArrayList(0));
            return;
        }
        List<Map<String, Object>> dicDatas = queryDic(dict_code);
        m.put(CgReportConstant.FIELD_DICTLIST, dicDatas);
    }

    /**
     * 查询数据字典
     *
     * @param diccode 字典编码
     * @return
     */
    private List<Map<String, Object>> queryDic(String diccode) {

        String typeHql = "from TmDictTypeEntity where dictTypeCode = ?";
        List<TmDictTypeEntity> list = tmCgDynamicService.findByHql(typeHql, diccode);

        List<Map<String, Object>> dicDatas = null;
        if (CollectionUtil.listNotEmpty(list)) {
            TmDictTypeEntity typeEntity = list.get(0);
            String dataHql = "from TmDictDataEntity where dictTypeCode = ?";
            dicDatas = tmCgDynamicService.findByHql(dataHql, typeEntity.getDictTypeCode());
        }
        return dicDatas;
    }

    /**
     * 处理数据字典
     *
     * @param result
     *            查询的结果集
     * @param beans
     *            字段配置
     */
    @SuppressWarnings("unchecked")
    private void dealDic(List<Map<String, Object>> result, List<Map<String, Object>> beans) {
        for (Map<String, Object> bean : beans) {
            String dict_code = (String) bean.get(CgReportConstant.ITEM_DICCODE);
            if (StringUtil.isEmpty(dict_code)) {
                // 不需要处理字典
                continue;
            } else {
                List<Map<String, Object>> dicDatas = queryDic(dict_code);
                for (Map r : result) {
                    String value = String.valueOf(r.get(bean.get(CgReportConstant.ITEM_FIELDNAME)));
                    for (Map m : dicDatas) {
                        String typecode = String.valueOf(m.get("typecode"));
                        String typename = String.valueOf(m.get("typename"));
                        if (value.equalsIgnoreCase(typecode)) {
                            r.put(bean.get(CgReportConstant.ITEM_FIELDNAME), typename);
                        }
                    }
                }
            }
        }
    }

    /**
     * 处理取值表达式
     *
     * @param result
     * @param beans
     */
    @SuppressWarnings("unchecked")
    private void dealReplace(List<Map<String, Object>> result, List<Map<String, Object>> beans) {
        for (Map<String, Object> bean : beans) {
            try {
                // 获取取值表达式
                String replace = (String) bean.get(CgReportConstant.ITEM_REPLACE);
                if (StringUtil.isEmpty(replace)) {
                    continue;
                }
                String[] groups = replace.split(",");
                for (String g : groups) {
                    String[] items = g.split("_");
                    String v = items[0];// 逻辑判断值
                    String txt = items[1];// 要转换的文本
                    for (Map r : result) {
                        String value = String.valueOf(r.get(bean.get(CgReportConstant.ITEM_FIELDNAME)));
                        if (value.equalsIgnoreCase(v)) {
                            r.put(bean.get(CgReportConstant.ITEM_FIELDNAME), txt);
                        }
                    }
                }
            } catch (Exception e) {
                // 这里出现异常原因是因为取值表达式不正确
                e.printStackTrace();
                throw new RuntimeException("取值表达式不正确");
            }
        }
    }
}
