package com.biz.eisp.mdm.config.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.TmTableConfigService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;

/** 
 * MDM各种功能数据配置
 * <p>主数据配置controller<br>
 * @author 肖胜
 * @version v1.0
 */
@Controller
@RequestMapping("/tmTableConfigController")
public class TmTableConfigController extends BaseController{

	@Autowired
	private TmTableConfigService tmTableConfigService;
	
	/**
	 * 主数据配置主界面
	 * @return 页面视图
	 */
	@RequestMapping(value = "goTableConfigMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTableConfigMain(	HttpServletRequest request){
//     	tmTableConfigService.importTable(Globals.TABLE_ORG);
     	List<ComboBox> comboxList=tmTableConfigService.comboBoxByDict("table_name");
     	request.setAttribute("tableList", comboxList);
		return new ModelAndView("com/biz/eisp/mdm/tableConfig/tableConfigMain");
	}
	
	/**
	 * TPM数据配置主界面
	 * @return 页面视图
	 */
	@RequestMapping(value="goTpmTableConfigMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTpmTableConfigMain(HttpServletRequest request){
//     	tmTableConfigService.importTable(Globals.TABLE_COST_TYPE);
     	List<ComboBox> comboxList=tmTableConfigService.comboBoxByDict("tpm_table_name");
     	request.setAttribute("tableList", comboxList);
		return new ModelAndView("com/biz/eisp/mdm/tableConfig/tableConfigMain");
	}

	/**
	 * 主数据配置详细页
	 * @return 页面视图
	 */
	@RequestMapping(value="goTableConfigIframe", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTableConfigIframe(String tableName,HttpServletRequest request){
     	request.setAttribute("tableName", tableName);
		return new ModelAndView("com/biz/eisp/mdm/tableConfig/tableConfigIframe");
	}
	
	/**
	 * 通过表名查看列数据Datagrid数据
	 * @param tableName 表名称
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "tableConfigGrid", method = {RequestMethod.GET, RequestMethod.POST})
	public void tableConfigGrid(String tableName,
			HttpServletRequest request,HttpServletResponse response) {
		List<TmMdmTableConfigEntity> result=tmTableConfigService.
				getColumnsByTableName(tableName,DynamicConfigUtil.OrderColumn);
		super.datagridReturn(response, result);
	}
	
	/**
	 * 方法的简述.
	 * <p>方法的详细说明第一行<br>
	 * 方法的详细说明第二行
	 * @param saveJsonData
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "saveTableConfig", method = {RequestMethod.GET, RequestMethod.POST})
	public void saveTableConfig1(String saveJsonData,
			HttpServletRequest request,HttpServletResponse response){
		try {
			tmTableConfigService.saveTableConfig(saveJsonData);
		} catch (Exception e) {
			this.message="操作失败，请联系开发人员！";
			e.printStackTrace();
		}
		sendResponse(response);
	}
	
	/**
	 * 获取数据字典逻辑
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "dictCombox", method = {RequestMethod.GET, RequestMethod.POST})
	public void dictCombox(String dictCode,HttpServletRequest request,HttpServletResponse response){
		List<ComboBox> dictDataList =tmTableConfigService.comboBoxByDict(dictCode);
		sendResponseObj(response, dictDataList);
	}
	
	/**
	 * 获取查询模式下拉列表
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "queryModeCombox",method = {RequestMethod.GET,RequestMethod.POST})
	public void queryModeCombox(HttpServletRequest request,HttpServletResponse response){
		List<ComboBox> dictDataList =tmTableConfigService.comboBoxByDict("searchmode");
		sendResponseObj(response, dictDataList);
	}
	
	/**
	 * 获取查询模式下拉列表
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "joinTypeCombox",method = {RequestMethod.GET,RequestMethod.POST})
	public void joinTypeCombox(HttpServletRequest request,HttpServletResponse response){
		List<ComboBox> dictDataList =tmTableConfigService.comboBoxByDict("join_type");
		sendResponseObj(response, dictDataList);
	}
	
	/**
	 * 获取表单类型下拉列表
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "queryFormTypeCombox",method = {RequestMethod.GET,RequestMethod.POST})
	public void queryFormTypeCombox(HttpServletRequest request,HttpServletResponse response){
		List<ComboBox> dictDataList =tmTableConfigService.comboBoxByDict("form_type");
		sendResponseObj(response, dictDataList);
	}
}
