/**
 * 描述.
 */
package com.biz.eisp.mdm.config.dao;

import java.util.List;
import java.util.Map;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.config.vo.TmCgDynamicHeadVo;
import com.biz.eisp.mdm.config.vo.TmCgDynamicItemVo;

/** 
 * 动态报表
 * @author xuduan
 * @version v1.0
 */
@InterfaceDao
public interface TmCgDynamicDao {
    /**
     * 动态报表头
     * @author xuduan
     * @param tmCgDynamicHeadVo
     * @param page
     * @return
     */
	@Arguments({"tmCgDynamicHeadVo","page"})
	@ResultType(TmCgDynamicHeadVo.class)
	public List<TmCgDynamicHeadVo> findCgDynamicHeadList(TmCgDynamicHeadVo tmCgDynamicHeadVo, Page page);
	
	/**
	 * 动态报表明细
	 * @author xuduan
	 * @param tmCgDynamicItemVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmCgDynamicItemVo","page"})
	@ResultType(TmCgDynamicItemVo.class)
	public List<TmCgDynamicItemVo> findCgDynamicItemList(TmCgDynamicItemVo tmCgDynamicItemVo, Page page);

    @Arguments({"configId"})
    @ResultType(Map.class)
    List<Map<String, Object>> queryCgReportItems(String configId);

    @Arguments({"id"})
    @ResultType(Map.class)
    Map queryCgReportMainConfig(String id);

}
