package com.biz.eisp.mdm.config.entity;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
/**
 * 配置实体类
 * <p>关联数据库表：tm_mdm_table_config<br>
 * @author xuduan
 * @version v1.0
 */
@Entity
@Table(name = "tm_mdm_table_config")
@org.hibernate.annotations.Proxy(lazy = false)
public class TmMdmTableConfigEntity extends IdEntity implements Serializable,Loggerable {

	private static final long serialVersionUID = 1L;
	//数据表名  
	private String tableName;
	//表字段   
	private String columnName;
	//JAVA属性名       
	private String field;
	//字段类型  
	private String columnType;
	//字段描述  
	private String columnDesc;
	//关联表名  
	private String joinTable;
	//关联类型  
	private String joinType;
	//关联条件  
	private String joinOn;
	//查询字段  
	private String joinColumn;
	//别名    
	private String alias;
	//列表排序  
	private String columnOrder;
	//列表属性  
	private String fieldProperty;
	//列表名称  
	private String fieldName;
	//显示排序  
	private String formOrder;
	//显示属性  
	private String showColumn;
	//是否隐藏  
	private String isHidden;
	//显示宽度
	private String fielWidth;
	//是否查询  
	private String queryStatus;
	//查询模式  
	private String queryMode;
	//数据字典  
	private String dictType;
	//新增显示模式  
	private Integer addShowMode;
	//表单名称  
	private String formName;
	//表单类型  
	private String formType;
	//表单数据源 
	private String formUrl;
	//表单验证  
	private String dataType;
	//错误提示  
	private String errorMsg;
	//表单扩展  
	private String formExtend;
	//编辑显示模式  
	private Integer updateShowMode;
	//是否必填  
	private Integer required;
	//表单格式化
	private String formFormat;
	//是否导出  
	private Integer importOut;
	//数据格式化 
	private String format;
	//录入提示  
	private String inputMsg;
	//导入字段  
	private String importField;


	 /* 
	 * @return java.lang.String 表名称
	 */
	@Column(name = "table_name", nullable = true)
	public String getTableName() {
		return tableName;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 字段名称
	 */
	@Column(name = "column_name", nullable = true)
	public String getColumnName() {
		return columnName;
	}

	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 字段描述
	 */
	@Column(name = "column_desc", nullable = true)
	public String getColumnDesc() {
		return columnDesc;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 字段类型
	 */
	@Column(name = "column_type", nullable = false)
	public String getColumnType() {
		return columnType;
	}

	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 字段在页面中的显示名称
	 */
	@Column(name = "field", nullable = true)
	public String getField() {
		return field;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 显示顺序
	 */
	@Column(name = "column_order", nullable = true)
	public String getColumnOrder() {
		return columnOrder;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 是否查询，0-是，1-否
	 */
	@Column(name = "query_status", nullable = true)
	public String getQueryStatus() {
		return queryStatus;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 查询方式，对应数据字典query_mode下的值
	 */
	@Column(name = "query_mode", nullable = true)
	public String getQueryMode() {
		return queryMode;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单类型
	 */
	@Column(name = "form_type", nullable = true)
	public String getFormType() {
		return formType;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 是否必填
	 */
	@Column(name = "required", nullable = true)
	public Integer getRequired() {
		return required;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String  数据字典类型，对应数据字典类型code值
	 */
	@Column(name = "dict_type", nullable = true)
	public String getDictType() {
		return dictType;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 外键关联数据表表名
	 */
	@Column(name = "join_table", nullable = true)
	public String getJoinTable() {
		return joinTable;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String  外键关联数据表列名
	 */
	@Column(name = "join_column", nullable = true)
	public String getJoinColumn() {
		return joinColumn;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 外键关联数据表查询别名
	 */
	@Column(name = "show_column", nullable = true)
	public String getShowColumn() {
		return showColumn;
	}
	
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单验证
	 */
	@Column(name = "data_type", nullable = true)
	public String getDataType() {
		return dataType;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单验证不通过提示信息
	 */
	@Column(name = "error_msg", nullable = true)
	public String getErrorMsg() {
		return errorMsg;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单格式化
	 */
	@Column(name = "form_format", nullable = true)
	public String getFormFormat() {
		return formFormat;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String  datagrid显示格式化
	 */
	@Column(name = "format", nullable = true)
	public String getFormat() {
		return format;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 是否导出
	 */
	@Column(name = "import_out", nullable = true)
	public Integer getImportOut() {
		return importOut;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 关联类型
	 */
	@Column(name = "join_type", nullable = true)
	public String getJoinType() {
		return joinType;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 关联条件
	 */
	@Column(name = "join_on", nullable = true)
	public String getJoinOn() {
		return joinOn;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 别名
	 */
	@Column(name = "alias", nullable = true)
	public String getAlias() {
		return alias;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 显示属性
	 */
	@Column(name = "field_property", nullable = true)
	public String getFieldProperty() {
		return fieldProperty;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 显示名称
	 */
	@Column(name = "field_name", nullable = true)
	public String getFieldName() {
		return fieldName;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单排序 
	 */
	@Column(name = "form_order", nullable = true)
	public String getFormOrder() {
		return formOrder;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 显示属性
	 */
	@Column(name = "is_hidden", nullable = true)
	public String getIsHidden() {
		return isHidden;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单名称属性
	 */
	@Column(name = "form_name", nullable = true)
	public String getFormName() {
		return formName;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单数据源
	 */
	@Column(name = "form_url", nullable = true)
	public String getFormUrl() {
		return formUrl;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单扩展
	 */
	@Column(name = "form_extend", nullable = true)
	public String getFormExtend() {
		return formExtend;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 表单提示
	 */
	@Column(name = "input_msg", nullable = true)
	public String getInputMsg() {
		return inputMsg;
	}
	/**
	 * 方法:取得java.lang.String
	 * 
	 * @return java.lang.String 导入字段
	 */
	@Column(name = "import_field", nullable = true)
	public String getImportField() {
		return importField;
	}
	public void setJoinType(String joinType) {
		this.joinType = joinType;
	}
	public void setJoinOn(String joinOn) {
		this.joinOn = joinOn;
	}
	public void setAlias(String alias) {
		this.alias = alias;
	}
	public void setFieldProperty(String fieldProperty) {
		this.fieldProperty = fieldProperty;
	}
	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}
	public void setFormOrder(String formOrder) {
		this.formOrder = formOrder;
	}
	public void setIsHidden(String isHidden) {
		this.isHidden = isHidden;
	}
	public void setFormName(String formName) {
		this.formName = formName;
	}
	public void setFormUrl(String formUrl) {
		this.formUrl = formUrl;
	}
	public void setFormExtend(String formExtend) {
		this.formExtend = formExtend;
	}
	public void setInputMsg(String inputMsg) {
		this.inputMsg = inputMsg;
	}
	public void setImportField(String importField) {
		this.importField = importField;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 表名称
	 */
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 字段名称
	 */
	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 字段描述
	 */
	public void setColumnDesc(String columnDesc) {
		this.columnDesc = columnDesc;
	}

	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 字段类型
	 */
	public void setColumnType(String columnType) {
		this.columnType = columnType;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String  字段在页面中的显示名称
	 */
	public void setField(String field) {
		this.field = field;
	}

	/**
	 * 方法：设置java.lang.Integer
	 * @param  java.lang.Integer 显示顺序
	 */
	public void setColumnOrder(String columnOrder) {
		this.columnOrder = columnOrder;
	}
	/**
	 * 方法：设置java.lang.Integer
	 * @param  java.lang.Integer 是否查询，0-是，1-否
	 */
	public void setQueryStatus(String queryStatus) {
		this.queryStatus = queryStatus;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 查询方式，对应数据字典query_mode下的值
	 */
	public void setQueryMode(String queryMode) {
		this.queryMode = queryMode;
	}
	/**
	 * 方法：设置java.lang.Integer
	 * @param  java.lang.Integer 是否必填
	 */
	public void setRequired(Integer required) {
		this.required = required;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 数据字典类型，对应数据字典类型code值
	 */
	public void setDictType(String dictType) {
		this.dictType = dictType;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 表单类型
	 */
	public void setFormType(String formType) {
		this.formType = formType;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 关联查询表表名
	 */
	public void setJoinTable(String joinTable) {
		this.joinTable = joinTable;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 关联查询表字段
	 */
	public void setJoinColumn(String joinColumn) {
		this.joinColumn = joinColumn;
	}
	
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 关联查询表字段
	 */
	public void setShowColumn(String showColumn) {
		this.showColumn = showColumn;
	}

	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String datagrid显示格式化
	 */
	public void setFormat(String format) {
		this.format = format;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 表单验证
	 */
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}
	/**
	 * 方法：设置java.lang.Integer
	 * @param  java.lang.Integer importOut 是否导出  
	 */
	public void setImportOut(Integer importOut) {
		this.importOut = importOut;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 表单验证不通过错误提示
	 */
	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param  java.lang.String 表单格式化
	 */
	public void setFormFormat(String formFormat) {
		this.formFormat = formFormat;
	}
	@Column(name = "add_show_mode", nullable = true)
	public Integer getAddShowMode() {
		return addShowMode;
	}
	@Column(name = "update_show_mode", nullable = true)
	public Integer getUpdateShowMode() {
		return updateShowMode;
	}
	public void setAddShowMode(Integer addShowMode) {
		this.addShowMode = addShowMode;
	}
	public void setUpdateShowMode(Integer updateShowMode) {
		this.updateShowMode = updateShowMode;
	}
	@Override
	public String businessDesc() {
		return "主数据["+this.getTableName().toLowerCase()+"]配置";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}
	@Column(name = "fiel_width", nullable = true)
	public String getFielWidth() {
		return fielWidth;
	}

	public void setFielWidth(String fielWidth) {
		this.fielWidth = fielWidth;
	}
}
