package com.biz.eisp.mdm.config.service;

import com.biz.eisp.mdm.config.bean.ExportExcelConfig;

/**
 * 导出动态配置Service.
 * @author grover
 * @version v1.0
 */
public interface DynamicExportFieldService {
	/**
	 * 根据表名和字段名获取导出配置.
	 * @author grover
	 * @param tableName 表名
	 * @param fieldName 字段名
	 * @return 导出配置
	 */
	ExportExcelConfig getExportExcelConfig(String tableName, String fieldName);
	/**
	 * 根据配置判断是否导出.
	 * @author grover
	 * @param exportExcelConfig 导出配置
	 * @return 是否导出 true-是 false-否
	 */
	boolean judgeIsExport(ExportExcelConfig exportExcelConfig);
}
