package com.biz.eisp.mdm.config.service;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.config.entity.TmCgDynamicHeadEntity;
import com.biz.eisp.mdm.config.entity.TmCgDynamicItemEntity;
import com.biz.eisp.mdm.config.vo.TmCgDynamicHeadVo;

import java.util.List;
import java.util.Map;

/** 
 * 动态报表
 * @author xuduan
 * @version v1.0
 */
public interface TmCgDynamicService extends BaseService {

    /**
     * 数据库类型
     */
    public static final String DATABSE_TYPE_MYSQL = "mysql";
    public static final String DATABSE_TYPE_POSTGRE = "postgresql";
    public static final String DATABSE_TYPE_ORACLE = "oracle";
    public static final String DATABSE_TYPE_SQLSERVER = "sqlserver";
    /**
     * 分页SQL
     */
    public static final String MYSQL_SQL = "select * from ( {0}) sel_tab00 limit {1},{2}"; // mysql
    public static final String POSTGRE_SQL = "select * from ( {0}) sel_tab00 limit {2} offset {1}";// postgresql
    public static final String ORACLE_SQL = "select * from (select row_.*,rownum rownum_ from ({0}) row_ where rownum <= {1}) where rownum_>{2}"; // oracle
    public static final String SQLSERVER_SQL = "select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}"; // sqlserver



    /**
     * 动态报表头
     * @author xuduan
     * @param tmCgDynamicHeadVo
     * @param page
     * @return
     */
	public List<TmCgDynamicHeadVo> findCgDynamicHeadList(TmCgDynamicHeadVo tmCgDynamicHeadVo, Page page);
	
	/**
	 * 删除
	 * @author xuduan
	 * @param id
	 */
	void deleteCgDynamicHead(String id);
	/**
	 * 插入
	 * @author xuduan
	 * @param cghead
	 */
	void saveCgDynamicHead(TmCgDynamicHeadEntity cghead, List<TmCgDynamicItemEntity> cgDynamicItemVos);
	
	/**
	 * 修改
	 * @author xuduan
	 * @param cgDynamicHeadVo
	 */
	void updateCgDynamicHead(TmCgDynamicHeadVo cgDynamicHeadVo,List<TmCgDynamicItemEntity> cgDynamicItemEntities);


    /**
     * 通过执行sql获得该sql语句中的字段集合
     *
     * @param sql
     *            报表sql
     * @return
     */
    public List<String> getSqlFields(String sql);

    /**
     * 根据报表的ID获得报表的抬头配置以及明细配置
     * @param id
     */
    public Map<String, Object> queryCgReportConfig(String id);


    /**
     * 执行报表SQL获取结果集
     *
     * @param sql
     *            报表SQL
     * @param params
     *            查询条件
     * @param page
     *            页面数
     * @param rows
     *            要获取的条目总数
     * @return
     */
    public List<Map<String, Object>> queryByCgReportSql(String sql, Map params, int page, int rows);

    /**
     * 获取报表sql结果集大小
     *
     * @param sql
     *            报表SQL
     * @param params
     *            查询条件
     * @return
     */
    public long countQueryByCgReportSql(String sql, Map params);
}
