package com.biz.eisp.mdm.config.service;

import java.util.List;

import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;

/**
 * 主数据 配置功能service接口层
 * <p>MDM模块主数据信息service接口<br>
 *  操作主数据配置表信息
 * @author 肖胜
 * @version v1.0
 */

public interface TmTableConfigService extends BaseService{
	
	/**
	 * 根据表名去查找对应表的 扩展配置
	 * @author xuduan
	 * @param tableName 表名
	 * @return
	 */
	public List<TmMdmTableConfigEntity> getColumnsByTableName(String tableName,String orderColumn);
	
	/**
	 * 保存配置信息
	 * @param saveJsonData 需保存的Json数据 
	 */
	public void saveTableConfig(String saveJsonData);
	
	/**
	 * 导入主数据配置导入数据表信息（备用）
	 * @param tableName 表名
	 */
	public void importTable(String tableName);
	
}
