package com.biz.eisp.mdm.config.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicConditionService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;

/** 动态查询字段解析
 * @author liukai
 * @version v1.0
 */
public class DefaultDynamicConditionServiceImpl implements DynamicConditionService{

	@Override
	public String findConditionList(Object businessVo, List<TmMdmTableConfigEntity> tmMdmTableConfigList) {
		String condition="";
		
		if(CollectionUtil.listEmpty(tmMdmTableConfigList)){
			throw new BusinessException("动态查询字段解析列表数据为空");
		}
		//遍历
		for(TmMdmTableConfigEntity tableConfig:tmMdmTableConfigList){
			String conditionSql="";
			//是否关联查询
			String joinColumn=tableConfig.getJoinColumn();
			if(StringUtil.isNotEmpty(joinColumn)){
				//是否查询
				String [] queryStatues=this.getFields(tableConfig.getQueryStatus());
				//查询模式
				String [] queryModes=this.getFields(tableConfig.getQueryMode());
				//关联表查询字段
				String joinColumns[]=this.getFields(tableConfig.getJoinColumn());
				//关联查询属性字段
				String showColumns[]=this.getFields(tableConfig.getFieldProperty());
				//格式化字段
				String formats[]=this.getFields(tableConfig.getFormat());
				for(int i=0;i<joinColumns.length;i++){
					String column=joinColumns[i];
					String property="";
					if(showColumns.length>i){
						property=showColumns[i];
					}
					
					String queryMode="";
					if(queryModes.length>i){
						queryMode=queryModes[i];
					}
					
					String queryStatus="";
					if(queryStatues.length>i){
						queryStatus=queryStatues[i];
					}
					
					String format="";
					if(formats.length>i){
						format=formats[i];
					}
					String alias=tableConfig.getAlias();
					if(StringUtil.isNotEmpty(tableConfig.getQueryMode())
							&&(tableConfig.getQueryMode().equals("accurate")
								||tableConfig.getQueryMode().equals("grade"))){
						column=tableConfig.getColumnName();
						alias="t";
					}
					//判断追加字段是否查询和追加查询条件
					conditionSql+=getConditionByQueryMode(
							queryStatus,alias,queryMode,property,column,businessVo,format,tableConfig.getJoinTable());
				}
			}else{
				//获取查询条件
				conditionSql+=getConditionByQueryMode(tableConfig.getQueryStatus(), "t",
						tableConfig.getQueryMode(),tableConfig.getFieldProperty(),tableConfig.getColumnName(), businessVo,tableConfig.getFormat(),null);
			}
			condition+=conditionSql;
		}
		
		return condition;
	}
	
	/**
	 * 分段截取字符串
	 * @param fields
	 * @return
	 */
	private String [] getFields(String fields){
		if(StringUtil.isNotEmpty(fields)){
			return fields.split(",");
		}
		return new String[0];
	}
	
	/**
	 * 判断是否查询获取查询条件
	 * @param queryStatus 是否查询
	 * @param tableAlise 查询表别名
	 * @param queryMode 查询模式
	 * @param propertyName 属性名称
	 * @param columnName 列名
	 * @param businessVo 查询条件值对象
	 * @return
	 */
	private String getConditionByQueryMode(String queryStatus,String tableAlise,String queryMode,String propertyName,
			String columnName,Object businessVo,String format,String joinTable){
		String condition="";
		if(StringUtil.isNotEmpty(queryStatus)&&
				queryStatus.equals("1")){
			condition= this.buildCondition(queryMode,tableAlise,propertyName,columnName,businessVo,format,joinTable);
		}
		return condition;
	}
	
	/**
	 * 根据查询模式获取查询条件
	 * @param queryMode 查询模式
	 * @param tableAlise 查询表别名
	 * @param propertyName 属性名称
	 * @param columnName 列名
	 * @param businessVo 查询条件值对象
	 * @return
	 */
	private String buildCondition(String queryMode,String tableAlise,
		String propertyName,String columnName,Object businessVo,String format,String joinTable){
		String condition="";
		
		String column="";
		//如果查询字段包含别名则不追加
		if(columnName.indexOf(".")!=-1){
			column=columnName;
		}else{
			column=tableAlise+"."+columnName;
		}
		//反射获取查询条件属性值
		if(StringUtils.isBlank(propertyName)) {
			return condition;
		}
		Object conditionValue=DynamicConfigUtil.getInstance().getPropertyValue(businessVo, propertyName);
		if(!StringUtil.isNotEmpty(conditionValue)&&!StringUtil.equals(queryMode, Globals.GROUP)){
			return condition;
		}

		//树型结构查询当前及下级
		if(StringUtil.isNotEmpty(queryMode)&&StringUtil.isNotEmpty(joinTable)&&
				StringUtil.equals("grade",queryMode)){
			condition += "  AND "+ column + " in (select id from "+joinTable+" start with id='"+conditionValue+"' CONNECT BY PRIOR id=PARENT_ID)";
		}

		//模糊查询
		if(StringUtil.isNotEmpty(queryMode)&&
				StringUtil.isNotEmpty(conditionValue)&&
				StringUtil.equals(queryMode, Globals.SINGLE)){
			condition += "  AND "+ column +" LIKE '%"+conditionValue+"%'";
		}
		//精确查询
		if(StringUtil.isNotEmpty(queryMode)&&
				StringUtil.equals(queryMode, Globals.ACCURATE)){
			//日期类型需要格式化
			if(conditionValue.getClass().isAssignableFrom(Date.class)){
				String formatStr="yyyy-MM-dd hh:mm";
				if(StringUtil.isNotEmpty(format)){
					formatStr=format;
				}
				SimpleDateFormat sdm=new SimpleDateFormat(formatStr);
				condition+=" AND TO_CHAR("+column+",'"+formatStr+"')" +"='"+sdm.format(conditionValue) +"'";
			}else{
				condition += "  AND "+ column +" = '"+conditionValue+"'";
			}
		}
		//组合查询
		if(StringUtil.isNotEmpty(queryMode)&&
				StringUtil.equals(queryMode, Globals.GROUP)){
			//组合查询属性值不为空才添加 
			Object propertyBegin=DynamicConfigUtil.getInstance().getPropertyValue(businessVo, propertyName+"_begin");
			Object propertyEnd=DynamicConfigUtil.getInstance().getPropertyValue(businessVo, propertyName+"_end");
			if (propertyBegin != null&&propertyEnd!=null) {
				String formatStr="yyyy-MM-dd hh:mm";
				if(StringUtil.isNotEmpty(format)){
					formatStr=format;
				}
				//范围查询
				if(propertyBegin.getClass().isAssignableFrom(Date.class)){
					SimpleDateFormat sdm=new SimpleDateFormat(formatStr);
					condition+=" AND TO_CHAR("+column+",'"+formatStr+"')" +">='"+sdm.format(propertyBegin)+"'";
//					condition+=" AND " + column + " >= TO_DATE('"+sdm.format(propertyBegin)+"','" + formatStr + "')";
				}else{
					condition+=" AND "+column+">='"+propertyBegin+"'";
				}
				//范围查询
				if(propertyEnd.getClass().isAssignableFrom(Date.class)){
					SimpleDateFormat sdm=new SimpleDateFormat(formatStr);
					condition+=" AND TO_CHAR("+column+",'"+formatStr+"')" +"<='"+sdm.format(propertyEnd)+"'";
//					condition+=" AND " + column + " <= TO_DATE('"+sdm.format(propertyEnd)+"','" + formatStr + "')";
				}else{
					condition+=" AND "+column+"<='"+propertyEnd+"'";
				}
			}
		}
		return condition+"";
	}
	
	
}
