package com.biz.eisp.mdm.config.service.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.biz.eisp.base.common.tag.bean.DataGridColumn;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicDataGridColumnService;

import edu.emory.mathcs.backport.java.util.Collections;

/**
 * 获取动态DataGridColumn列表 Service 实现.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class DefaultDynamicDataGridColumnServiceImpl implements DynamicDataGridColumnService {

	@Override
	public List<DataGridColumn> findDataGridColumnList(List<TmMdmTableConfigEntity> tmMdmTableConfigList,boolean treegrid) {
		List<DataGridColumn> dataGridColumnList = new ArrayList<DataGridColumn>();
		if (CollectionUtil.listNotEmptyNotSizeZero(tmMdmTableConfigList)) {
			for (TmMdmTableConfigEntity entity : tmMdmTableConfigList) {
				List<DataGridColumn> dataGridColumn = this.buildDataGridColumn(entity,treegrid);
				if (CollectionUtil.listNotEmptyNotSizeZero(dataGridColumn)) {
					dataGridColumnList.addAll(dataGridColumn);
				}
			}
		}
		//排序 
		doOrderOpt(dataGridColumnList);
		return dataGridColumnList;
	}

	/**
	 * 构造列信息.
	 * @param entity
	 * @return
	 */
	private List<DataGridColumn> buildDataGridColumn(TmMdmTableConfigEntity entity,boolean treegrid) {

		if (StringUtils.isBlank(entity.getFieldProperty())) {
			return null;
		}

		List<DataGridColumn> dataGridColumnList = new ArrayList<DataGridColumn>();
		//属性字段
		String[] filedArr = entity.getFieldProperty().split(",");
		
		//显示名称
		String[] fieldNameArr = StringUtils.isBlank(entity.getFieldName())
				?entity.getColumnDesc().split(","):entity.getFieldName().split(",") ;
	
		//是否隐藏
		String[] isHiddenArr =  StringUtils.isBlank(entity.getIsHidden()) 
				? new String[fieldNameArr.length] : entity.getIsHidden().split(",");

		//格式化
		String[] formatArr = StringUtils.isBlank(entity.getFormat()) 
				? new String[fieldNameArr.length] : entity.getFormat().split(",");
	
		//表单地址
		String[] formatUrlArr = StringUtils.isBlank(entity.getFormUrl()) 
				? new String[fieldNameArr.length] : entity.getFormUrl().split(",");
				
		//排序 
		String[] columnOrderArr =StringUtils.isBlank(entity.getColumnOrder()) 
				? new String[fieldNameArr.length] : entity.getColumnOrder().split(",");
				
		//是否查询
		String[] queryStatusArr = StringUtils.isBlank(entity.getQueryStatus()) 
				? new String[fieldNameArr.length] : entity.getQueryStatus().split(",");
		//查询模式
				
		String[] queryModeArr = StringUtils.isBlank(entity.getQueryMode()) 
				? new String[fieldNameArr.length] : entity.getQueryMode().split(",");
		//查询表单类型
		String[] formTypeArr= StringUtils.isBlank(entity.getFormType()) 
				? new String[fieldNameArr.length] : entity.getFormType().split(",");
				
		//数据字典
		String[] dictType = StringUtils.isBlank(entity.getDictType()) 
				? new String[fieldNameArr.length] : entity.getDictType().split(",");

		DataGridColumn dataGridColumn = null;
		for (int i = 0; i < fieldNameArr.length; i++) {
			dataGridColumn = new DataGridColumn();
			//是否隐藏
			Boolean hidden=false;
			if(isHiddenArr[i]!=null&&isHiddenArr[i].equals("1")){
				hidden=true;
			}
			dataGridColumn.setHidden(hidden);
			if(treegrid){
				dataGridColumn.setTreefield(filedArr[i]);
			}
			dataGridColumn.setField(filedArr[i]);
			//是否查询
			Boolean queryStatus=false;
			if(queryStatusArr[i]!=null&&queryStatusArr[i].equals("1")){
				queryStatus=true;
			}
			dataGridColumn.setQuery(queryStatus);
			dataGridColumn.setQueryMode(queryModeArr[i]);
			dataGridColumn.setFormatter(formatArr[i]);
			dataGridColumn.setTitle(fieldNameArr[i]);
			dataGridColumn.setDictionary(dictType[i]);
			dataGridColumn.setColumnOrder(Integer.parseInt(columnOrderArr[i]));
			if (StringUtils.isNotBlank(entity.getFielWidth()))
			dataGridColumn.setWidth(Integer.parseInt(entity.getFielWidth()));
			dataGridColumn.setFormType(formTypeArr[i]);
			dataGridColumn.setFormUrl(formatUrlArr[i]);
			dataGridColumnList.add(dataGridColumn);
		}

		return dataGridColumnList;
	}

	/**
	 * 做排序操作.
	 * <p>
	 * 
	 * @param dataGridColumnList
	 */
	private void doOrderOpt(List<DataGridColumn> dataGridColumnList) {
		Collections.sort(dataGridColumnList, new Comparator<DataGridColumn>() {
			@Override
			public int compare(DataGridColumn o1, DataGridColumn o2) {
				if (o1.getColumnOrder() > o2.getColumnOrder()) {
					return 1;
				}
				return 0;
			}
		});
	}
}
