package com.biz.eisp.mdm.config.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.config.bean.ExportExcelConfig;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicExportFieldService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;

/** 
 * 默认的动态导出字段实现.
 * @author grover
 * @version v1.0
 */
@Service("dynamicExportFieldService")
@Transactional
public class DefaultDynamicExportFieldServiceImpl implements DynamicExportFieldService {

	@Override
	public ExportExcelConfig getExportExcelConfig(String tableName,
			String fieldName) {
		ExportExcelConfig exportExcelConfig = null;
		//导出key
		String tableConfigKey = tableName+fieldName;
		//获取动态配置
		TmMdmTableConfigEntity configEntity = DynamicConfigUtil.
				allTableConfigByField.get(tableConfigKey.toLowerCase());
		//设置配置值
		if(StringUtil.isNotEmpty(configEntity)){
			exportExcelConfig = new ExportExcelConfig();
			Integer isExport = configEntity.getImportOut();
			Integer columnOrder = StringUtil.isNotEmpty(configEntity.getColumnOrder())
					?Integer.parseInt(configEntity.getColumnOrder()):0;
			String exportName = StringUtil.isNotEmpty(configEntity.getFieldName())?
					configEntity.getFieldName():
					configEntity.getColumnDesc();
			exportExcelConfig.setIsExport(OConvertUtils.getString(isExport));
			exportExcelConfig.setExportName(exportName);
			exportExcelConfig.setExprotOrder(OConvertUtils.getString(columnOrder));
			exportExcelConfig.setDictCode(configEntity.getDictType());
			System.out.println(exportName + ":" + columnOrder);
		}else{
			exportExcelConfig = null;
		}
		return exportExcelConfig;
	}

	@Override
	public boolean judgeIsExport(ExportExcelConfig exportExcelConfig) {
		if(!StringUtil.isNotEmpty(exportExcelConfig)){
			return false;
		}
		if(StringUtil.isEmpty(exportExcelConfig.getIsExport())){
			return false;
		}
		if(Globals.NO_EXPORT.equals(exportExcelConfig.getIsExport())){
			return false;
		}
		return true;
	}

}
