package com.biz.eisp.mdm.config.service.impl;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.tag.params.FormMdmParams;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PatternUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicFormFieldService;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;

import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.dict.vo.TmDictTypeVo;
import edu.emory.mathcs.backport.java.util.Collections;

/**
 * 获取动态DataGridColumn列表 Service 实现.
 * <p>
 * @author liukai
 * @version v1.0
 */
public class DefaultDynamicFormFieldServiceImpl implements DynamicFormFieldService {

	@Override
	public List<FormMdmParams> findFormFieldList(List<TmMdmTableConfigEntity> tmMdmTableConfigList, 
			Object businessVo,Integer optype) {
		List<FormMdmParams> paramsList=new ArrayList<FormMdmParams>();
		if (CollectionUtil.listNotEmptyNotSizeZero(tmMdmTableConfigList)) {
			for (int i = 0; i < tmMdmTableConfigList.size(); i++) {
				TmMdmTableConfigEntity tableConfig=tmMdmTableConfigList.get(i);
				FormMdmParams formMdmparams = new FormMdmParams();
				if(StringUtil.isNotEmpty(tableConfig.getAddShowMode())||
						StringUtil.isNotEmpty(tableConfig.getUpdateShowMode())){
					String formName=StringUtil.isNotEmpty(tableConfig.getFormName())
							?tableConfig.getFormName():tableConfig.getColumnDesc();
					formMdmparams.setLabelName(formName);
					formMdmparams.setContentId(tableConfig.getField());
					formMdmparams.setContentName(tableConfig.getField());
					formMdmparams.setRequired(tableConfig.getRequired());
					formMdmparams.setDataType(tableConfig.getDataType());
					formMdmparams.setErrorMsg(tableConfig.getErrorMsg());
					formMdmparams.setFormExtend(StringUtil.isEmpty(tableConfig.getFormExtend())?"":
						PatternUtils.getPatternValue(tableConfig.getFormExtend(), businessVo));
					formMdmparams.setFormat(tableConfig.getFormFormat());
					formMdmparams.setInputMsg(tableConfig.getInputMsg());
					formMdmparams.setUrl(StringUtil.isEmpty(tableConfig.getFormUrl())?"":tableConfig.getFormUrl());
				
					//包含数据字典 未填写表单类型则默认为下拉列表 
					String formType=tableConfig.getFormType();	
					String dictType=tableConfig.getDictType();
					
					//表单默认为text
					if(StringUtil.isEmpty(dictType)&&StringUtil.isEmpty(formType)){
						formType="text";
					}
					formMdmparams.setFormType(formType);
					String objValue="";
					//更新或查看时 加载数据值 
					if(optype!=0&&StringUtil.isNotEmpty(tableConfig.getUpdateShowMode())){
						objValue=method(businessVo,tableConfig.getField());
						formMdmparams.setShowMode(tableConfig.getUpdateShowMode());
						formMdmparams.setObjvalue(objValue);
						paramsList.add(formMdmparams);
					}else if(optype==0&&StringUtil.isNotEmpty(tableConfig.getAddShowMode())){
						formMdmparams.setShowMode(tableConfig.getAddShowMode());
						formMdmparams.setObjvalue(objValue);
						paramsList.add(formMdmparams);
					}
					
					//判断是否有字典类型的选择框
					if (StringUtil.isNotEmpty(dictType)) {
						//包含数据字典 未填写表单类型则默认为下拉列表 
						formType=StringUtil.isEmpty(formType)?"combobox":formType;

							List<TmDictDataVo> tlist=DictUtil.getDictList(dictType);
							if(CollectionUtil.listNotEmptyNotSizeZero(tlist) && formType.equals("checkbox")){
								String value = formMdmparams.getObjvalue();
								if(StringUtil.isNotEmpty(value)){
									for (TmDictDataVo dictDataEntity : tlist) {
										if(value.contains(dictDataEntity.getDictCode())){
											dictDataEntity.setChecked(true);
										}
									}
								}
							}
							formMdmparams.setTlist(tlist);
					}else{
						if(StringUtil.isNotEmpty(formType)&&StringUtil.equals("checkbox", formType)){
							throw new BusinessException("checkbox仅支持数据字典");
						}
						if(StringUtil.isNotEmpty(formType)&&StringUtil.equals("radio", formType)){
							throw new BusinessException("radio仅支持数据字典");
						}
					}
				}
			}
		}
		return paramsList;
	}
	
	/**
	 *反射获取对象的field属性值 
	 * @param obj 对象
	 * @param field 属性名
	 * @return
	 */
	private String  method(Object obj, String field) {  
		String val="";
		if (obj!=null) {
	    try {  
	        Class clazz = obj.getClass();  
	        PropertyDescriptor pd = new PropertyDescriptor(field, clazz);  
	        Method getMethod = pd.getReadMethod();//获得get方法  
	        if (pd != null) {  
	            Object o = getMethod.invoke(obj);//执行get方法返回一个Object  
	            val=o!=null?o.toString():"";  
	        }  
	    } catch (SecurityException e) {  
	        e.printStackTrace();  
	    } catch (IllegalArgumentException e) {  
	        e.printStackTrace();  
	    } catch (IntrospectionException e) {  
	        e.printStackTrace();  
	    } catch (IllegalAccessException e) {  
	        e.printStackTrace();  
	    } catch (InvocationTargetException e) {  
	        e.printStackTrace();  
	    }  
		}
	    return val;
	}
	
}
