package com.biz.eisp.mdm.config.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import org.apache.commons.lang3.StringUtils;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicImportDataFieldService;
import com.biz.eisp.mdm.dict.util.DictUtil;

/**
 * 动态导入配置Service.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class DefaultDynamicImportDataFieldServiceImpl implements DynamicImportDataFieldService {

	@Override
	public List<DataField> findImportDataField(String tableName,
			List<TmMdmTableConfigEntity> tmMdmTableConfigList) {
		List<DataField> columnList = new ArrayList<DataField>();
		
		for (int i = 0; i < tmMdmTableConfigList.size(); i++) {
			TmMdmTableConfigEntity entity = tmMdmTableConfigList.get(i);
			//新增模式-正常的模式才能进行导入操作
			Integer addShowMode = entity.getAddShowMode(); 
			if (addShowMode != null && addShowMode == 1) {
				//构建导入对象
				Integer index=i+1;
				DataField column = this.buildDataField(index+"",entity);
				columnList.add(column);
			}
		}
		return columnList;
	}

	/**
	 * 构建导入字段信息列表 
	 * @param rowNumber 开始行
	 * @param entity 列对象
	 * @return
	 */
	private DataField buildDataField(String index,TmMdmTableConfigEntity entity) {
		DataField column = new DataField();
		column.setName(index);
		column.setCode(entity.getField());
		column.setAvailable(false);
		column.setFormat(entity.getFormat());
		column.setTitle(StringUtils.isBlank(entity.getFormName()) ? entity.getColumnDesc() : entity.getFormName());
		String dataType = entity.getColumnType().toLowerCase();
		String type = "number";
		if (dataType.indexOf("varchar") != -1) {
			type = "char";
		} else if (dataType.indexOf("date") != -1) {
			type = "date";
		}
		column.setType(type);
		if (StringUtil.isNotEmpty(entity.getDictType())) {
			column.setDictCode(entity.getDictType());
		}
		if (StringUtil.isNotEmpty(entity.getRequired()) && entity.getRequired() == 1) {
			column.setRequired(true);
		}
		if (StringUtil.isNotEmpty(entity.getDataType()) && entity.getDataType().length() > 1) {
			column.setMask(entity.getDataType().substring(1, entity.getDataType().length() - 1));
		}
		if (StringUtil.isNotEmpty(entity.getDictType())) {
			List<TmDictDataVo> list = DictUtil.getDictList(entity.getDictType());
			String[] dictArray = new String[list.size()];
			for (int v = 0; v < list.size(); v++) {
				TmDictDataVo c = list.get(v);
				dictArray[v] = c.getDictValue();
			}
			column.setList(dictArray);
		}
		column.setLength(500);
		//通过importField查询关联表id
		if(StringUtils.isNotBlank(entity.getImportField())) {
			column.setIdBySql("SELECT id FROM " + entity.getJoinTable() + " WHERE " + entity.getImportField() + " = ?");
		}

		return column;
	}
}
