package com.biz.eisp.mdm.config.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.config.bean.JoinTableConfig;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicJoinTableService;

/** 动态查询字段解析
 * @author liukai
 * @version v1.0
 */
public class DefaultDynamicJoinTableServiceImpl implements DynamicJoinTableService{

	@Override
	public List<JoinTableConfig> findJoinTableList(List<TmMdmTableConfigEntity> tmMdmTableConfigList) {
		List<JoinTableConfig> joinTableConfigList=new ArrayList<JoinTableConfig>();
		for(TmMdmTableConfigEntity tableConfig:tmMdmTableConfigList){
			if(StringUtil.isNotEmpty(tableConfig.getJoinTable())){
				JoinTableConfig joinTableConfig=new JoinTableConfig();
				 String joinType=tableConfig.getJoinType();
				 if(StringUtil.isEmpty(joinType)){
					 throw new BusinessException("字段"+tableConfig.getColumnName()+"发现错误，找到关联表但关联类型为空");
				 }
				 if(StringUtil.isEmpty(tableConfig.getAlias())){
					 throw new BusinessException("字段"+tableConfig.getColumnName()+"发现错误，找到关联表但关联别名为空");
				 }
				 if(StringUtil.isEmpty(tableConfig.getJoinOn())){
					 throw new BusinessException("字段"+tableConfig.getColumnName()+"发现错误，找到关联表但关联条件为空");
				 }
				 joinTableConfig.setAlias(tableConfig.getAlias());
				 joinTableConfig.setJoinTable(tableConfig.getJoinTable());
				 joinTableConfig.setJoinOn(tableConfig.getJoinOn());
				 joinTableConfig.setJoinType(getJoinType(joinType));
				 joinTableConfigList.add(joinTableConfig);
			}
		}
		
		return joinTableConfigList;
	}
	
	/**
	 * 获取关联类型
	 * @param joinType
	 * @return
	 */
	private String getJoinType(String joinType){
		String join="";
		if(StringUtil.equals(joinType, "1")){
			 join= " left join ";
		}else if(StringUtil.equals(joinType, "2")){
			join=" right join ";
		}else if(StringUtil.equals(joinType, "3")){
			join =" inner join ";
		}
		return join;
	}
	
}
