package com.biz.eisp.mdm.config.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.config.bean.SelectColumnConfig;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicSelectColumnService;

/** 动态查询字段解析
 * @author liukai
 * @version v1.0
 */
public class DefaultDynamicSelectColumnServiceImpl implements DynamicSelectColumnService{

	@Override
	public List<SelectColumnConfig> findSelectColumnList(List<TmMdmTableConfigEntity> tmMdmTableConfigList) {
		if(CollectionUtil.listEmpty(tmMdmTableConfigList)){
			throw new BusinessException("动态查询字段解析列表数据为空");
		}
		//查询字段列表 
		List<SelectColumnConfig> selectColumnList=new ArrayList<SelectColumnConfig>();
		
		for(TmMdmTableConfigEntity tableConfig:tmMdmTableConfigList ){

			//关联表字段 
			String joinColumn=tableConfig.getJoinColumn();
			SelectColumnConfig selectColumn=new SelectColumnConfig();
			selectColumn.setAlias("t");//默认主表查询别名
			//获取属性名称
			String field=StringUtil.isEmpty(tableConfig.getFieldProperty())
					?tableConfig.getField():tableConfig.getFieldProperty();
					
			if(StringUtil.isNotEmpty(joinColumn)){
				selectColumn.setPropertyName(tableConfig.getField());
			}else{
				selectColumn.setPropertyName(field);
			}
			//查询字段名
			selectColumn.setColumnName(tableConfig.getColumnName());
			selectColumnList.add(selectColumn);

			if(StringUtil.isNotEmpty(joinColumn)){
				//关联表查询字段 可多个
				String[] joinColumns=joinColumn.split(",");
				for(int i=0;i<joinColumns.length;i++){
					SelectColumnConfig newSelectColumn=new SelectColumnConfig();
					String str=joinColumns[i];
					String[] showFields=tableConfig.getShowColumn().split(",");
					if(showFields.length>i){
						newSelectColumn.setPropertyName(showFields[i]);
					}
					//判断是否默认添加别名
					if(str.indexOf(".")!=-1){
						String[] columns=str.split("\\.");
						newSelectColumn.setAlias(columns[0]);
						newSelectColumn.setColumnName(columns[1]);
					}else{
						//关联表别名
						newSelectColumn.setAlias(tableConfig.getAlias());
						newSelectColumn.setColumnName(str);
					}
					selectColumnList.add(newSelectColumn);
				}
			}
		}
		return selectColumnList;
	}

}
