package com.biz.eisp.mdm.config.service.impl;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.biz.eisp.base.common.util.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.constant.CgReportConstant;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.dao.TmCgDynamicDao;
import com.biz.eisp.mdm.config.entity.TmCgDynamicHeadEntity;
import com.biz.eisp.mdm.config.entity.TmCgDynamicItemEntity;
import com.biz.eisp.mdm.config.service.TmCgDynamicService;
import com.biz.eisp.mdm.config.vo.TmCgDynamicHeadVo;

/**
 * 动态报表接口层
 *
 * @author xuduan
 * @version v1.0
 */
@Service("tmCgDynamicService")
@Transactional
public class TmCgDynamicServiceImpl extends BaseServiceImpl implements TmCgDynamicService {

    @Autowired
    TmCgDynamicDao tmCgDynamicDao;

    @Autowired
    private JdbcTemplate jdbcTemplate;


    /**
     * 动态报表头查询
     */
    @Override
    public List<TmCgDynamicHeadVo> findCgDynamicHeadList(
            TmCgDynamicHeadVo tmCgDynamicHeadVo, Page page) {
        return tmCgDynamicDao.findCgDynamicHeadList(tmCgDynamicHeadVo, page);
    }

    /**
     * 删除
     */
    @Override
    public void deleteCgDynamicHead(String id) {
        this.deleteEntityById(TmCgDynamicHeadEntity.class, id);
        // ===================================================================================
        // 删除-动态报表配置明细
        List<TmCgDynamicItemEntity> cgreportConfigItemOldList = this.findByProperty(TmCgDynamicItemEntity.class, "cgrheadId", id);
        this.deleteAllEntity(cgreportConfigItemOldList);
    }

    @Override
    public void saveCgDynamicHead(TmCgDynamicHeadEntity cghead, List<TmCgDynamicItemEntity> cgDynamicItemEntities) {
        // 保存主信息
        this.saveOrUpdate(cghead);

        /** 保存-动态报表配置明细 */
        for (TmCgDynamicItemEntity cgreportConfigItem : cgDynamicItemEntities) {
            // 外键设置
            cgreportConfigItem.setCgrheadId(cghead.getId());
            this.saveOrUpdate(cgreportConfigItem);
        }

    }

    /**
     * 更新
     */
    @Override
    public void updateCgDynamicHead(TmCgDynamicHeadVo cgDynamicHeadVo, List<TmCgDynamicItemEntity> cgDynamicItemEntities) {
        TmCgDynamicHeadEntity cghead = this.get(TmCgDynamicHeadEntity.class, cgDynamicHeadVo.getId());
        try {
            MyBeanUtils.copyBeanNotNull2Bean(cgDynamicHeadVo, cghead);
            this.saveOrUpdate(cghead);


            // ===================================================================================
            // 获取参数
            Object id0 = cghead.getId();
            // ===================================================================================
            // 1.查询出数据库的明细数据-动态报表配置明细
            List<TmCgDynamicItemEntity> cgreportConfigItemOldList = this.findByProperty(TmCgDynamicItemEntity.class, "cgrheadId", id0);
            // 2.筛选更新明细数据-动态报表配置明细
            for (TmCgDynamicItemEntity oldE : cgreportConfigItemOldList) {
                boolean isUpdate = false;
                for (TmCgDynamicItemEntity sendE : cgDynamicItemEntities) {
                    // 需要更新的明细数据-动态报表配置明细
                    if (oldE.getId().equals(sendE.getId())) {
                        try {
                            MyBeanUtils.copyBeanNotNull2Bean(sendE, oldE);
                            this.saveOrUpdate(oldE);
                        } catch (Exception e) {
                            e.printStackTrace();
                            throw new BusinessException(e.getMessage());
                        }
                        isUpdate = true;
                        break;
                    }
                }
                if (!isUpdate) {
                    // 如果数据库存在的明细，前台没有传递过来则是删除-动态报表配置明细
                    super.delete(oldE);
                }

            }
            // 3.持久化新增的数据-动态报表配置明细
            for (TmCgDynamicItemEntity cgreportConfigItem : cgDynamicItemEntities) {
                if (StringUtil.isEmpty(cgreportConfigItem.getId())) {
                    // 外键设置
                    cgreportConfigItem.setCgrheadId(cghead.getId());
                    this.save(cgreportConfigItem);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public List<String> getSqlFields(String sql) {
        if (StringUtil.isEmpty(sql)) {
            return null;
        }
        List<Map<String, Object>> result = findForMapList(sql);
        if (result.size() < 1) {
            throw new BusinessException("该报表sql没有数据");
        }
        Set fieldsSet = result.get(0).keySet();
        List<String> fileds = new ArrayList<String>(fieldsSet);
        return fileds;
    }

    @Override
    public Map<String, Object> queryCgReportConfig(String id) {
        Map<String, Object> cgReportM = new HashMap<String, Object>();
        //查询-动态报表
        Map<String, Object> mainM = tmCgDynamicDao.queryCgReportMainConfig(id);
        // 查询-动态报表配置明细
        List<Map<String, Object>> itemsM = tmCgDynamicDao.queryCgReportItems(id);

        cgReportM.put(CgReportConstant.MAIN, mainM);
        cgReportM.put(CgReportConstant.ITEMS, itemsM);
        return cgReportM;
    }

    /**
     * 按照数据库类型，封装SQL
     */
    public static String eispCreatePageSql(String sql, int page, int rows) {
        int beginNum = (page - 1) * rows;
        String[] sqlParam = new String[3];
        sqlParam[0] = sql;
        sqlParam[1] = beginNum + "";
        sqlParam[2] = rows + "";

        String jdbcUrl = ResourceConfigUtils.getJdbcUrl();

        if(StringUtil.isNotEmpty(jdbcUrl)){
            if (jdbcUrl.indexOf(DATABSE_TYPE_MYSQL) != -1) {
                sql = MessageFormat.format(MYSQL_SQL, sqlParam);
            } else if (jdbcUrl.indexOf(DATABSE_TYPE_POSTGRE) != -1) {
                sql = MessageFormat.format(POSTGRE_SQL, sqlParam);
            } else {
                int beginIndex = (page - 1) * rows;
                int endIndex = beginIndex + rows;
                sqlParam[2] = Integer.toString(beginIndex);
                sqlParam[1] = Integer.toString(endIndex);
                if (jdbcUrl.indexOf(DATABSE_TYPE_ORACLE) != -1) {
                    sql = MessageFormat.format(ORACLE_SQL, sqlParam);
                } else if (jdbcUrl.indexOf(DATABSE_TYPE_SQLSERVER) != -1) {
                    sqlParam[0] = sql.substring(getAfterSelectInsertPoint(sql));
                    sql = MessageFormat.format(SQLSERVER_SQL, sqlParam);
                }
            }
        }else{
            throw new BusinessException("没有获取到数据库类型");
        }
        return sql;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    /**
     * 使用指定的检索标准检索数据并分页返回数据
     */
    public List<Map<String, Object>> findForJdbc(String sql, int page, int rows) {
        // 封装分页SQL
        sql = eispCreatePageSql(sql, page, rows);
        return jdbcTemplate.queryForList(sql);
    }

    public List<Map<String, Object>> findForJdbc(String sql, Object... objs) {
        return jdbcTemplate.queryForList(sql, objs);
    }

    @Override
    @SuppressWarnings("unchecked")
    public List<Map<String, Object>> queryByCgReportSql(String sql, Map params, int page, int rows) {
        String querySql = getFullSql(sql, params);
        List<Map<String, Object>> result = null;
        if (page == -1 && rows == -1) {
            result = findForJdbc(querySql);
        } else {
            result = findForJdbc(querySql, page, rows);
        }
        return result;
    }

    /**
     * 获取拼装查询条件之后的sql
     *
     * @param sql
     * @param params
     * @return
     */
    @SuppressWarnings("unchecked")
    private String getFullSql(String sql, Map params) {
        StringBuilder sqlB = new StringBuilder();
        sqlB.append("SELECT t.* FROM ( ");
        sqlB.append(sql + " ");
        sqlB.append(") t ");
        if (params.size() >= 1) {
            sqlB.append("WHERE 1=1  ");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                String value = String.valueOf(params.get(key));
                if (!StringUtil.isEmpty(value) && !"null".equals(value)) {
                    sqlB.append(" AND ");
                    sqlB.append(" " + key + value);
                }
            }
        }
        return sqlB.toString();
    }

    @Override
    @SuppressWarnings("unchecked")
    public long countQueryByCgReportSql(String sql, Map params) {
        String querySql = getFullSql(sql, params);
        querySql = "SELECT COUNT(*) as countrow FROM (" + querySql + ") t2";
        List<Map<String, Object>> list = jdbcTemplate.queryForList(querySql);
        if (CollectionUtil.listNotEmpty(list)) {
            BigDecimal countrow = (BigDecimal) list.get(0).get("countrow");
            return countrow.longValue();
        }
        return 0;
    }



}
