package com.biz.eisp.mdm.config.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.TmTableConfigService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;

/**
 * 主数据 配置功能service接口实现
 * <p>MDM模块主数据信息service接口实现<br>
 *  操作主数据配置表信息
 * @author 肖胜
 * @version v1.0
 */
@Service("tmTableConfigServiceImpl")
@Transactional
public class TmTableConfigServiceImpl extends BaseServiceImpl implements
		TmTableConfigService {
	
	/**
	 * 根据表名去查找对应表的 扩展配置字段
	 */
	@Override
	public List<TmMdmTableConfigEntity> getColumnsByTableName(String tableName,String orderColumn) {
		return this.findByPropertyisOrder(TmMdmTableConfigEntity.class,
				"tableName", tableName, true, orderColumn);
	}
	
	@Override
	public void saveTableConfig(String saveJsonData) {
		String tableName = "";
		//转为jsonArray
		JSONArray jsonArray=JSON.parseArray(saveJsonData);
		//遍历jsonArray
		for(int i=0;i<jsonArray.size();i++){
			JSONObject obj =  (JSONObject) jsonArray.get(i);
			//json对象转为java对象并执行更新
			TmMdmTableConfigEntity tableConfig=JSON.toJavaObject(obj, TmMdmTableConfigEntity.class);
			//设置表名
			if(StringUtil.isEmpty(tableName)){
				tableName = tableConfig.getTableName();
			}
			//先查询后copy,为了记录日志
			TmMdmTableConfigEntity newTableConfig=null;
			if(StringUtil.isNotEmpty(tableConfig.getId())){
				newTableConfig=this.get(TmMdmTableConfigEntity.class,tableConfig.getId());
				//属性copy 无法设置空值
				try {
					MyBeanUtils.copyBean2Bean(newTableConfig,tableConfig);
					if(newTableConfig.getAddShowMode()!=null
							&&newTableConfig.getAddShowMode()==0){
						newTableConfig.setAddShowMode(null);
					}
					if(newTableConfig.getUpdateShowMode()!=null
							&&newTableConfig.getUpdateShowMode()==0){
						newTableConfig.setUpdateShowMode(null);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			this.updateEntity(newTableConfig);
		}
		//更新缓存
		updateTableCache(tableName);
	}
	
	/**
	 * 更新主数据配置缓存.
	 * @param tableName 表名
	 * @author grover
	 */
	private void updateTableCache(String tableName) {
		if(StringUtil.isNotEmpty(tableName)){
	    	  List<TmMdmTableConfigEntity> tableColumns=
	    			  this.findByPropertyisOrder(TmMdmTableConfigEntity.class, 
	    					  "tableName",tableName,true,"columnOrder");
	    	  //字段值与字段描述放入map
	    	 Map<String,String> fieldMap=new HashMap<String,String>();
	    	 //列名与字段描述
	     	 Map<String,String> clounmMap=new HashMap<String,String>();
	     	 //动态表单数据字典列
	     	 Map<String,String> cloumnDictTypeMap = new HashMap<String,String>();
	     	//缓存所有动态配置表信息key--> 表名，Map-->实体field，字段描述
	  		Map<String,TmMdmTableConfigEntity> allFieldEntity=new HashMap<String,TmMdmTableConfigEntity>();
	     	 
	    	  List<TmMdmTableConfigEntity> tableConfigImp=new ArrayList<TmMdmTableConfigEntity>();
	     	 
	    	  for(TmMdmTableConfigEntity  tableColumn:tableColumns){
	    		  
	    		  allFieldEntity.put(tableColumn.getField(), tableColumn);
	    		  //数据字典
	    		   if(StringUtil.isNotEmpty(tableColumn.getDictType())){
	    			   cloumnDictTypeMap.put(tableColumn.getField(), tableColumn.getDictType());
	    		   }
	    		  //字段描述
	   			 String columnDesc=StringUtil.isNotEmpty(tableColumn.getFieldName())?
    					tableColumn.getFieldName():tableColumn.getColumnDesc();
	    		  clounmMap.put(tableColumn.getField(), columnDesc);
	    		  fieldMap.put(tableColumn.getColumnName(), columnDesc);
	    		  //导出字段
	    		  if(StringUtil.isNotEmpty(tableColumn.getImportOut())){
	    			  String keyName = tableColumn.getTableName()+tableColumn.getField();
	    			  if(StringUtil.isNotEmpty(tableColumn.getFieldProperty())){
	    				  keyName = tableColumn.getTableName()+tableColumn.getFieldProperty();
	    			  }
	    			  DynamicConfigUtil.allTableConfigByField.put(keyName.toLowerCase(), tableColumn);
	    		  }
	    		  //导入信息
	    		  if(StringUtil.isNotEmpty(tableColumn.getAddShowMode())&&tableColumn.getAddShowMode()==1){
	    			  tableConfigImp.add(tableColumn);
	    		  }
	    	  }
	    	 DynamicConfigUtil.allTableConfigEntity.put(tableName, allFieldEntity);
	    	 DynamicConfigUtil.allTableConfigDictColumn.put(tableName, cloumnDictTypeMap);
	    	 DynamicConfigUtil.allTableConfigField.put(tableName, fieldMap);
	    	 DynamicConfigUtil.allTableConfigColumn.put(tableName, clounmMap);
	    	 DynamicConfigUtil.allTableConfig.put(tableName.toLowerCase(), tableColumns);
	    	 DynamicConfigUtil.allTableConfigImpColumn.put(tableName, tableConfigImp);
	      }
	}
	
	@Override
	public void importTable(String tableName){
		List<TmMdmTableConfigEntity> saveList=new ArrayList<TmMdmTableConfigEntity>();
		List<TmMdmTableConfigEntity> delList=new ArrayList<TmMdmTableConfigEntity>();
		//历史数据
		List<TmMdmTableConfigEntity> hisList=this.getColumnsByTableName(tableName,DynamicConfigUtil.OrderColumn);
		//根据表名查询字段信息sql
		String sql=this.getSearchTableColumnSql(tableName);
		//最新数据
		List<TmMdmTableConfigEntity> nowList=this.findBySql(TmMdmTableConfigEntity.class, sql);
		
		if(hisList!=null&&hisList.size()>0){
			//删除当前已存在  修改后不存在的数据
			for(TmMdmTableConfigEntity table:hisList){
				if(hasContain(nowList, table)){
					continue;
				}
				delList.add(table);
			}
			this.deleteAllEntity(delList);
		}
		//新增字段
		for(TmMdmTableConfigEntity t:nowList){
			if(hasContain(hisList, t)){
				continue;
			}
			saveList.add(t);
		}
		this.batchSave(saveList);
	}
	
	/**
	 * 判断配置表List集合中是否包含属性列名实体
	 * @param list
	 * @param table
	 * @return
	 */
	private boolean hasContain(List<TmMdmTableConfigEntity> list,TmMdmTableConfigEntity tableConfig){
		boolean flag=false;
		for(TmMdmTableConfigEntity t:list){
			if(StringUtil.equals(t.getColumnName(), tableConfig.getColumnName())){
				flag= true;
				break;
			}
		}
		return flag;
	}
	
	/**
	 * 查询数据表字段信息(备用)
	 * @param tableName 表名
	 * @return
	 */
	private String getSearchTableColumnSql(String tableName){
		String sql="select t.Table_Name tableName,t.COLUMN_NAME columnName,"+
						"case when instr(t1.COMMENTS,'，')>0 then "+
						"substr(t1.COMMENTS,0,instr(t1.COMMENTS,'，')-1) "+
						"else t1.COMMENTS end columnDesc, "+
						"t.data_type||'('||t.data_length||')'  columnType, "+
						"substr(replace(initcap('a' || t.COLUMN_NAME), '_', ''), 2) field,ROWNUM columnOrder "+
						"from user_tab_columns t "+
						"left join user_col_comments t1 on t1.Table_Name=t.Table_Name and t1.COLUMN_NAME=t.COLUMN_NAME "+
						"where t.Table_Name='"+tableName+"'";
		return sql;
	}
	
}
