package com.biz.eisp.mdm.config.util;

import com.biz.eisp.mdm.system.listener.OnlineListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/**
 * 数据库类型工具类
 * @author keith
 *
 */
public class DBTypeUtil {
    private static Logger log = LoggerFactory.getLogger(DBTypeUtil.class);

    /**
     * 获取数据库类型
     * 
     * @return
     */
    public static String getDBType() {
        String retStr = "";
        ApplicationContext ctx = OnlineListener.getCtx();
        if (ctx == null) {
            return retStr;// 如果ctx为空，则服务器异常了
        } else {
            org.springframework.orm.hibernate5.LocalSessionFactoryBean sf = (org.springframework.orm.hibernate5.LocalSessionFactoryBean) ctx
                            .getBean("&sessionFactory");
            String dbdialect = sf.getHibernateProperties().getProperty("hibernate.dialect");
            log.debug(dbdialect);
            if (dbdialect.equals("org.hibernate.dialect.MySQLDialect")) {
                retStr = "mysql";
            } else if (dbdialect.contains("Oracle")) {// oracle有多个版本的方言
                retStr = "oracle";
            } else if (dbdialect.equals("org.hibernate.dialect.SQLServerDialect")) {
                retStr = "sqlserver";
            } else if (dbdialect.equals("org.hibernate.dialect.PostgreSQLDialect")) {
                retStr = "postgres";
            }
            return retStr;
        }
    }
}
