package com.biz.eisp.mdm.config.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.apache.commons.httpclient.util.DateUtil;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.tag.bean.DataGridColumn;
import com.biz.eisp.base.common.tag.params.FormMdmParams;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.bean.JoinTableConfig;
import com.biz.eisp.mdm.config.bean.SelectColumnConfig;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicConditionService;
import com.biz.eisp.mdm.config.service.DynamicDataGridColumnService;
import com.biz.eisp.mdm.config.service.DynamicFormFieldService;
import com.biz.eisp.mdm.config.service.DynamicImportDataFieldService;
import com.biz.eisp.mdm.config.service.DynamicJoinTableService;
import com.biz.eisp.mdm.config.service.DynamicSelectColumnService;
import com.biz.eisp.mdm.config.service.DynamicTableNameService;
import com.biz.eisp.mdm.config.service.TmTableConfigService;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicConditionServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicDataGridColumnServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicFormFieldServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicImportDataFieldServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicJoinTableServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicSelectColumnServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicTableNameServiceImpl;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;

/**
 * 类简述.
 * <p>
 * 类的详细说明第一行<br>
 * 类的详细说明第二行
 * 
 * @author liukai
 * @version v1.0
 */
public class DynamicConfigUtil {

	public static final String OrderColumn="columnOrder";
	public static final String FormOrder="formOrder";
	
	private static DynamicConfigUtil dynamicConfigUtil = null;
	
	// 私有化无参构造方法
	private DynamicConfigUtil() {
	}

	// 实例化对象
	private static synchronized void syncInit() {
		if (dynamicConfigUtil == null) {
			dynamicConfigUtil = new DynamicConfigUtil();
		}
	}

	// 单例模式入口
	public static DynamicConfigUtil getInstance() {
		if (dynamicConfigUtil == null) {
			syncInit();
		}
		return dynamicConfigUtil;
	}

//	//缓存所有动态配置表信息key--> 表名，Map-->实体entity，字段描述
//	   public static Map<String, Map<String,TmMdmTableConfigEntity>> allTableConfigEntity =
//			   new HashMap<String,Map<String,TmMdmTableConfigEntity>>();
//
//	  //缓存所有动态配置表信息key--> 表名，Map-->实体field，字段描述
//	   public static Map<String, Map<String,String>> allTableConfigField =
//			   new HashMap<String,Map<String,String>>();
//
//	   //缓存所有动态配置表信息key--> 表名，Map-->数据库字段，字段描述
//	   public static Map<String, Map<String,String>> allTableConfigColumn =
//			   new HashMap<String,Map<String,String>>();
//
//	   //缓存所有动态配置表面是数据字典的记录
//	   public static Map<String, Map<String,String>> allTableConfigDictColumn =
//			   new HashMap<String,Map<String,String>>();
//
//	   //缓存所有动态配置表信息key-->value-->是否导出
//	   public static Map<String,TmMdmTableConfigEntity> allTableConfigByField =
//			   new HashMap<String, TmMdmTableConfigEntity>();
//
//	   //缓存所有动态配置表信息key-->value-->信息
//	   public static Map<String,List<TmMdmTableConfigEntity>> allTableConfig =
//			   new HashMap<String, List<TmMdmTableConfigEntity>>();
//
//	   //缓存所有动态配置表信息key-->value-->导入formOrder信息
//	   public static Map<String, List<TmMdmTableConfigEntity>> allTableConfigImpColumn =
//			   new HashMap<String,List<TmMdmTableConfigEntity>>();


	public static ConcurrentMap<String, Map<String,TmMdmTableConfigEntity>> allTableConfigEntity =
			new ConcurrentHashMap<String,Map<String,TmMdmTableConfigEntity>>();

	//缓存所有动态配置表信息key--> 表名，Map-->实体field，字段描述
	public static ConcurrentMap<String, Map<String,String>> allTableConfigField =
			new ConcurrentHashMap<String,Map<String,String>>();

	//缓存所有动态配置表信息key--> 表名，Map-->数据库字段，字段描述
	public static ConcurrentMap<String, Map<String,String>> allTableConfigColumn =
			new ConcurrentHashMap<String,Map<String,String>>();

	//缓存所有动态配置表面是数据字典的记录
	public static ConcurrentMap<String, Map<String,String>> allTableConfigDictColumn =
			new ConcurrentHashMap<String,Map<String,String>>();

	//缓存所有动态配置表信息key-->value-->是否导出
	public static ConcurrentMap<String,TmMdmTableConfigEntity> allTableConfigByField =
			new ConcurrentHashMap<String, TmMdmTableConfigEntity>();

	//缓存所有动态配置表信息key-->value-->信息
	public static ConcurrentMap<String,List<TmMdmTableConfigEntity>> allTableConfig =
			new ConcurrentHashMap<String, List<TmMdmTableConfigEntity>>();

	//缓存所有动态配置表信息key-->value-->导入formOrder信息
	public static ConcurrentMap<String, List<TmMdmTableConfigEntity>> allTableConfigImpColumn =
			new ConcurrentHashMap<String,List<TmMdmTableConfigEntity>>();
	   
	
	/**
	 * 查询字段service
	 */
	private DynamicSelectColumnService dynamicSelectColumnService;
	/**
	 * 查询条件service
	 */
	private DynamicConditionService dynamicConditionService;
	/**
	 * 查询表名service
	 */
	private DynamicTableNameService dynamicTableNameService;
	
	/**
	 * 关联表名service
	 */
	private DynamicJoinTableService dynamicJoinTableService;
	
	/**
	 * 表格显示列表service
	 */
	private DynamicDataGridColumnService dynamicDataGridColumnService;
	
	/**
	 * 动态表单service
	 */
	private DynamicFormFieldService dynamicFormFieldService;
	
	/**
	 * 动态表单导入字段service
	 */
	private DynamicImportDataFieldService dynamicImportDataFieldService;
	

	/**
	 * 根据表名读取主数据配置信息
	 * @param tableName
	 * @return
	 */
	public List <TmMdmTableConfigEntity> getTmMdmTableConfigList(String tableName,String orderColumn) {
		
		List <TmMdmTableConfigEntity> tableConfigList = DynamicConfigUtil.allTableConfig.get(tableName);
    	if(CollectionUtil.listEmpty(tableConfigList)){
			TmTableConfigService tmTableConfigService = (TmTableConfigService) ApplicationContextUtils
					.getContext().getBean("tmTableConfigServiceImpl");
			tableConfigList =tmTableConfigService.getColumnsByTableName(tableName,orderColumn);
		}
    	if(CollectionUtil.listEmpty(tableConfigList)) {
    		throw new BusinessException("未找到表：" + tableName + "的配置信息");
    	}
    	return tableConfigList;
	}
	
	/**
	 * 构造查询sql.
	 * @param tableName 表名
	 * @param businessVo 业务对象
	 * @return
	 */
	public String buildQuerySql(String tableName, Object businessVo) {
		List<TmMdmTableConfigEntity> tableConfigList
						= this.getTmMdmTableConfigList(tableName,DynamicConfigUtil.OrderColumn);
		String sqlMain="SELECT ";
		String sqlWhere=" WHERE 1=1";
		//读取查询列表service
		if(dynamicSelectColumnService == null) {
			dynamicSelectColumnService = new DefaultDynamicSelectColumnServiceImpl();
		}
		
		//读取查询字段
		List <SelectColumnConfig> selectColumnConfigList =
				dynamicSelectColumnService.findSelectColumnList(tableConfigList);
		if(CollectionUtil.listNotEmptyNotSizeZero(selectColumnConfigList)){
			for(SelectColumnConfig selectColumn:selectColumnConfigList){
				sqlMain+=selectColumn.getAlias()+"."+selectColumn.getColumnName()
				+" as "+selectColumn.getPropertyName()+",";
			}
			sqlMain=sqlMain.substring(0,sqlMain.length()-1);
		}
		
		//表名
		if(dynamicTableNameService==null){
			dynamicTableNameService=new DefaultDynamicTableNameServiceImpl();
		}
		tableName=dynamicTableNameService.getTableName(tableName, tableConfigList);
		sqlMain+=" FROM "+tableName+" t ";
		
		//关联表追加
		//读取查询列表service
		if(dynamicJoinTableService == null) {
			dynamicJoinTableService = new DefaultDynamicJoinTableServiceImpl();
		}
		
		String joinTableSql=" ";
		List<JoinTableConfig> joinTables=dynamicJoinTableService.findJoinTableList(tableConfigList);
		if(CollectionUtil.listNotEmptyNotSizeZero(joinTables)){
			for(JoinTableConfig joinTable:joinTables){
				String joinTableObj=joinTable.getJoinTable();
				if(joinTableObj.toUpperCase().indexOf("SELECT")!=-1){
					joinTableObj="("+joinTableObj+")";
				}
				joinTableSql+=joinTable.getJoinType()+joinTableObj+" "+joinTable.getAlias();
				joinTableSql+=" on "+joinTable.getJoinOn()+" ";
			}
		}
		sqlMain+=joinTableSql;
		
		//id查询是其他条件忽略
		String id=(String) getPropertyValue(businessVo, "id");
		if(StringUtil.isNotEmpty(id)){
			sqlWhere=" where t.id='"+id+"'";
		}else{
			//查询条件service
			if(dynamicConditionService==null){
				dynamicConditionService=new DefaultDynamicConditionServiceImpl();
			}
			//查询条件解析
			sqlWhere +=dynamicConditionService.findConditionList(businessVo, tableConfigList);
		}
		return sqlMain+sqlWhere;
	}
	
	/**
	 * 构造treegrid查询sql.
	 * @author grover
	 * @param tableName 表名
	 * @param businessVo 业务vo对象
	 * @return
	 */
	public String buildTreeGridQuerySql(String tableName, Object businessVo) {
		List<TmMdmTableConfigEntity> tableConfigList = this.getTmMdmTableConfigList(
				tableName,DynamicConfigUtil.OrderColumn);
		String sqlMain="SELECT DISTINCT ";
		String sqlWhere=" WHERE 1=1";
		//treegrid逻辑查询逻辑
		if(isHaveQuery(tableName, businessVo)){
			//有查询条件
			sqlWhere+=" CONNECT BY  t.id = PRIOR t.parent_id START WITH 1=1";
		}else{
			//无查询条件
			String exportExcel=(String) getPropertyValue(businessVo, "exportExcel");
			String id=(String) getPropertyValue(businessVo, "id");
			if(StringUtil.isNotEmpty(exportExcel) && "false".equals(exportExcel)){
				if(StringUtil.isNotEmpty(id)){
					sqlWhere+=" and t.parent_id = '"+id+"'";
				}else{
					sqlWhere+=" and t.parent_id is null";
				}
			}
		}
		//读取查询列表service
		if(dynamicSelectColumnService == null) {
			dynamicSelectColumnService = new DefaultDynamicSelectColumnServiceImpl();
		}
		
		//读取查询字段
		List <SelectColumnConfig> selectColumnConfigList =
				dynamicSelectColumnService.findSelectColumnList(tableConfigList);
		//treegrid逻辑条件逻辑
		if(isHaveQuery(tableName, businessVo)){
			//有查询条件
			sqlMain+="'open' as state,";
		}else{
			//无查询条件
			sqlMain+="CASE WHEN t.is_leaf = 1 THEN 'open' ELSE 'closed' END as state,";
		}
		if(CollectionUtil.listNotEmptyNotSizeZero(selectColumnConfigList)){
			for(SelectColumnConfig selectColumn:selectColumnConfigList){
				sqlMain+=selectColumn.getAlias()+"."+selectColumn.getColumnName()
						+" as "+selectColumn.getPropertyName()+",";
			}
			sqlMain=sqlMain.substring(0,sqlMain.length()-1);
		}
		
		//表名
		if(dynamicTableNameService==null){
			dynamicTableNameService=new DefaultDynamicTableNameServiceImpl();
		}
		tableName=dynamicTableNameService.getTableName(tableName, tableConfigList);
		sqlMain+=" FROM "+tableName+" t ";
		
		//关联表追加
		//读取查询列表service
		if(dynamicJoinTableService == null) {
			dynamicJoinTableService = new DefaultDynamicJoinTableServiceImpl();
		}
		
		String joinTableSql=" ";
		List<JoinTableConfig> joinTables=dynamicJoinTableService.findJoinTableList(tableConfigList);
		if(CollectionUtil.listNotEmptyNotSizeZero(joinTables)){
			for(JoinTableConfig joinTable:joinTables){
				joinTableSql+=joinTable.getJoinType()+joinTable.getJoinTable()+" "+joinTable.getAlias();
				joinTableSql+=" on "+joinTable.getJoinOn()+" ";
			}
		}
		sqlMain+=joinTableSql;
		//查询条件service
		if(dynamicConditionService==null){
			dynamicConditionService=new DefaultDynamicConditionServiceImpl();
		}
		//查询条件解析
		Object enableStatus = getPropertyValue(businessVo, "enableStatus");
		if(enableStatus != null){
			sqlWhere +=" and t.enable_status = " + enableStatus;
		}
		sqlWhere +=dynamicConditionService.findConditionList(businessVo, tableConfigList);
		
		return sqlMain+sqlWhere;
	}
	
	/**
	 * 获取treegrid是否有查询条件.
	 * @author grover 
	 * @param tableName 表名
	 * @param businessVo 业务对象vo
	 * @return true 有 false 没有
	 */
	public boolean isHaveQuery(String tableName, Object businessVo) {
		List <TmMdmTableConfigEntity> mdmTableConfigs = DynamicConfigUtil.allTableConfig.get(tableName.toLowerCase());
		if(CollectionUtil.listNotEmptyNotSizeZero(mdmTableConfigs)){
			for (TmMdmTableConfigEntity tmMdmTableConfigEntity : mdmTableConfigs) {
				if(Globals.ONE.toString().equals(tmMdmTableConfigEntity.getQueryStatus())){
					//获取配置需要查询的字段是否有值 有值说明有查询条件
					Object queryField = getPropertyValue(businessVo, tmMdmTableConfigEntity.getFieldProperty());
					if(StringUtil.isNotEmpty(queryField)){
						return true;
					}
				}
			}
		}
		return false;
	}
	
	/**
	 *追加自定义查询条件
	 * 需要关联主查询sql格式为
	 * select t.* from (sql) t left join (joinSql) on sqlOn where 1=1 + sqlWhere
	 * @param sql 主查询sql
	 * @param joinSql left join 关联sql
	 * @param sqlOn on关键字的值
	 * @param sqlWhere where查询条件
	 * @return
	 */
	public String appendCustomCondition(String sql,String joinSql,String sqlOn,String sqlWhere,String orderSql){
		String sqlCondition="select distinct t.* from ("+sql+") t ";
		if(StringUtil.isNotEmpty(joinSql)
				&&StringUtil.isNotEmpty(sqlOn)){
			sqlCondition="select distinct t.*,t1.* from ("+sql+") t ";
			sqlCondition+="left join ("+joinSql+") t1 on "+sqlOn;
		}
		if(StringUtil.isNotEmpty(sqlWhere)){
			sqlCondition+=" where 1=1" +sqlWhere;
		}
		return sqlCondition+orderSql;
	}

	/**
	 *追加自定义查询条件
	 * 需要关联主查询sql格式为
	 * select t.* from (sql) t left join (joinSql) on sqlOn where 1=1 + sqlWhere
	 * @param sql 主查询sql
	 * @param joinType 关联类型
	 * @param joinSql left join 关联sql
	 * @param sqlOn on关键字的值
	 * @param sqlWhere where查询条件
	 * @return
	 */
	public String appendCustomCondition(String sql,String joinSql,String joinType,String sqlOn,String sqlWhere,String orderSql){
		String sqlCondition="select distinct t.* from ("+sql+") t ";
		if(StringUtil.isNotEmpty(joinSql)
				&&StringUtil.isNotEmpty(sqlOn)){
			sqlCondition="select distinct t.*,t1.* from ("+sql+") t ";
			if(StringUtil.isEmpty(joinType)){
				joinType="left join ";
			}
			sqlCondition+=joinType+"("+joinSql+") t1 on "+sqlOn;
		}
		if(StringUtil.isNotEmpty(sqlWhere)){
			sqlCondition+=" where 1=1" +sqlWhere;
		}
		return sqlCondition+orderSql;
	}


	/**
	 * 构造表格列表 
	 * @param tableName 表名
	 * @param businessVo 业务对象
	 * @return
	 */
	public List<DataGridColumn> buildDataGridColumn(String tableName,boolean treegrid){
		List<TmMdmTableConfigEntity> tableConfigList=this.getTmMdmTableConfigList(tableName,DynamicConfigUtil.OrderColumn);
		if(dynamicDataGridColumnService==null){
			dynamicDataGridColumnService=new DefaultDynamicDataGridColumnServiceImpl();
		}
		return dynamicDataGridColumnService.findDataGridColumnList(tableConfigList,treegrid);
	}
	
	/**
	 * 构造form表单
	 * @param tableName 表名
	 * @param businessVo 业务对象
	 * @return
	 */
	public List<FormMdmParams> buildFormColumn(String tableName,Object businessVo,Integer opttype){
		List<TmMdmTableConfigEntity> tableConfigList=
				this.getTmMdmTableConfigList(tableName,DynamicConfigUtil.FormOrder);
		if(dynamicFormFieldService==null){
			dynamicFormFieldService=new DefaultDynamicFormFieldServiceImpl();
		}
		return dynamicFormFieldService.findFormFieldList(tableConfigList, businessVo, opttype);
	}
	
	/**
	 * 构建动态导入字段列表 
	 * @param tableName 表名
	 * @param startRow 开始列
	 * @return
	 */
	public List<DataField> buildImportDataFieldList(String tableName) {
		if(dynamicImportDataFieldService == null) {
			dynamicImportDataFieldService = new DefaultDynamicImportDataFieldServiceImpl();
		}
		List<TmMdmTableConfigEntity> tableConfigList=
				DynamicConfigUtil.allTableConfigImpColumn.get(tableName);
		return dynamicImportDataFieldService.findImportDataField(tableName, tableConfigList);
	}
	
	/**
	 * 通过obj属性的get方法获取属性值
	 * @param obj
	 * @param field
	 * @return
	 */
	public  Object getPropertyValue(Object paramObj,String field){
		if(field==null) return null;
		if(paramObj==null) return null;
		Class clazz = paramObj.getClass();
		Field[] fields = paramObj.getClass().getDeclaredFields();
		Object property =null;
		try {
			PropertyDescriptor pd= new PropertyDescriptor(field, clazz);
			// 获得get方法
			Method getMethod = pd.getReadMethod();
			// 执行get方法返回一个Object
			 property = getMethod.invoke(paramObj);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException(paramObj.getClass().getName()+"未找到属性字段："+field);
		} 
		return property;
	}
	
	/**
	 * 反射给对象设置属性值
	 * @param obj 业务对象
	 * @param field 属性名
	 * @param value 属性值
	 */
	@SuppressWarnings("all")
	public static  void setValueForProperty(Object obj,String field,Object value){
		
		Class clazz = obj.getClass();
		Field[] fields = obj.getClass().getDeclaredFields();
		Object property =null;
		try {
			PropertyDescriptor pd= new PropertyDescriptor(field, clazz);
			Class c=pd.getPropertyType();
			// 获得set方法
			Method setMethod = pd.getWriteMethod();
			// 执行set方法
			if(c.isAssignableFrom(String.class)){
				value=value.toString();
			}
			if(c.isAssignableFrom(Integer.class)){
				value=Integer.parseInt((String)value);
			}
			if(c.isAssignableFrom(Date.class)){
				value=DateUtil.parseDate((String)value);
			}
			 setMethod.invoke(obj,value);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException(obj.getClass().getName()+"未找到属性字段："+field);
		} 
	}

	public void setDynamicSelectColumnService(DynamicSelectColumnService dynamicSelectColumnService) {
		this.dynamicSelectColumnService = dynamicSelectColumnService;
	}

	public void setDynamicConditionService(DynamicConditionService dynamicConditionService) {
		this.dynamicConditionService = dynamicConditionService;
	}

	public void setDynamicTableNameService(DynamicTableNameService dynamicTableNameService) {
		this.dynamicTableNameService = dynamicTableNameService;
	}

	public void setDynamicJoinTableService(DynamicJoinTableService dynamicJoinTableService) {
		this.dynamicJoinTableService = dynamicJoinTableService;
	}

	public void setDynamicDataGridColumnService(DynamicDataGridColumnService dynamicDataGridColumnService) {
		this.dynamicDataGridColumnService = dynamicDataGridColumnService;
	}

	public void setDynamicFormFieldService(DynamicFormFieldService dynamicFormFieldService) {
		this.dynamicFormFieldService = dynamicFormFieldService;
	}

	public void setDynamicImportDataFieldService(DynamicImportDataFieldService dynamicImportDataFieldService) {
		this.dynamicImportDataFieldService = dynamicImportDataFieldService;
	}
	
	
}
