package com.biz.eisp.mdm.customer.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.customer.service.TmCustPostService;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;

/** 
 * 经销商与职位对应关系controller
 * @author 肖胜
 * @version v1.0
 */
@Controller
@RequestMapping("/tmCustPostController")
public class TmCustPostController extends BaseController{

	@Autowired
	private TmCustPostService tmCustPostService;

	/**
	 * 选择职位信息列表 
	 * @return 页面视图
	 */
	@RequestMapping(value="goTmCustPostMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmCustPostMain(TmCustPostVo custPostVo,HttpServletRequest request){
		String customerId=request.getParameter("customerId");
		String businessGroup=request.getParameter("businessGroup");
		String terminalId=request.getParameter("terminalId");
		
		request.setAttribute("terminalId",terminalId);
		request.setAttribute("customerId", customerId);
		request.setAttribute("businessGroup", businessGroup);
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerPosition");
	}
	
	
	/**
	 * 删除经销商与职位对应关系信息
	 * @param custPostVo 经销商与职位对应关系vo对象
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="deleteCustPost", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public JSONObject deleteCustPost(TmCustPostVo custPostVo,
			HttpServletRequest request,HttpServletResponse response){
		tmCustPostService.deleteTmCustPost(custPostVo);
		return returnJson();
	}
	
	/**
	 * 获取业务组下拉列表
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "businessGroupCombox", method = {RequestMethod.GET, RequestMethod.POST})
	public void businessGroupCombox(HttpServletRequest request,HttpServletResponse response){
		List<ComboBox> dictDataList =tmCustPostService.comboBoxByDict(Globals.BUSINESS_GROUP);
		sendResponseObj(response, dictDataList);
	}
	
	/**
	 * 查询职位信息
	 * @param customerVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value="findTmCustPostList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmCustPostList(TmCustPostVo customerVo,
			HttpServletRequest request,HttpServletResponse response){
		Page page=new EuPage(request);
		List<TmCustPostVo> custPostList=
				tmCustPostService.findPostList(customerVo,page);
		return new DataGrid(custPostList, page);
	}
	
	/**
	 * 跳转关联经销商页面.职位界面（批量维护）
	 * @param request 请求对象
	 * @param tmCustPostVo 客户vo
	 */
	@RequestMapping(value = "goCustomerBindPosMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCustomerBindPosMain(HttpServletRequest request, TmCustPostVo tmCustPostVo){
		request.setAttribute("positionId", tmCustPostVo.getPositionId());
		request.setAttribute("businessGroup", tmCustPostVo.getBusinessGroup());
		request.setAttribute("custUser", tmCustPostVo.getCustUser());
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerBindPosMain");
	}

	/**
	 * 跳转关联经销商页面. 职位界面（仅查看）
	 * @param request 请求对象
	 * @param tmCustPostVo 客户vo
	 */
	@RequestMapping(value = "goCustomerByPosMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCustomerByPosMain(HttpServletRequest request, TmCustPostVo tmCustPostVo){
		request.setAttribute("positionId", tmCustPostVo.getPositionId());
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerByPosMain");
	}

	/**
	 * 跳转关联经销商页面. 客户用户界面
	 * @param request 请求对象
	 * @param tmCustPostVo 客户vo
	 */
	@RequestMapping(value = "goCustomerBinUserMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCustomerBinUserMain(HttpServletRequest request, TmCustPostVo tmCustPostVo){
		request.setAttribute("businessGroup", tmCustPostVo.getBusinessGroup());
		request.setAttribute("custUser", tmCustPostVo.getCustUser());
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerUser");
	}


	/**
	 * 查询未关联任何职位的客户信息数据
	 * @param tmCustPostVo 终端vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findNotAnyPostCustomerList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNotAnyPostCustomerList(TmCustPostVo tmCustPostVo, HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmCustomerVo> terminalList=
				tmCustPostService.findNotAnyPostCustomerList(tmCustPostVo, page);
		return new DataGrid(terminalList, page);
	}

	/**
	 * 查询未关联当前职位的客户信息数据
	 * @param tmCustPostVo 客户vo对象
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value="findNotCurrPostCustomerList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNotCurrPostCustomerList(TmCustPostVo tmCustPostVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmCustomerVo> terminalList=
				tmCustPostService.findNotCurrPostCustomerList(tmCustPostVo, page);
		return new DataGrid(terminalList, page);
	}

	/**
	 * 批量添加职位与客户对应关系
	 * @param customerIds 终端vo对象
	 * @param positionId 职位ID
	 * @param response 响应对象
	 */
	@RequestMapping(value="addRelotaionForPositionId", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson addRelotaionForPositionId(String customerIds, String positionId, HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			tmCustPostService.addRelotaionForPositionId(customerIds,positionId);
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}

	/**
	 * 替换 终端与经销商对应关系
	 * @param relationIds 对应关系主键ids
	 * @param positionId  新的职位id
	 */
	@RequestMapping(value="updatePostTerminalRelation", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson updatePostCustomerRelation(String relationIds,String positionId,HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			tmCustPostService.updatePostCustomerRelation(relationIds,positionId);
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}

	/**
	 * 批量解除终端与客户对应关系
	 * @param ids 终端vo对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="deleteRelotaion", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteRelotaion(String ids,HttpServletResponse response){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			tmCustPostService.deleteRelotaionForCustomerId(ids);
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg(e.getMessage());
		}
		return ajaxJson;
	}
}
