package com.biz.eisp.mdm.customer.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.service.*;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.erpcode.commond.QuoteStrategy;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 
 * 经销商管理controller
 * @author 肖胜
 * @version v1.0
 */
@Controller
@RequestMapping("/tmCustomerController")
public class TmCustomerController extends BaseController{
	/**
	 * 注入客户service.
	 */
	@Autowired
	private TmCustomerService tmCustomerService;
	/**
	 * 注入客户职位关系service.
	 */
	@Autowired
	private TmCustPostService tmCustPostService;
	
	/**
	 * SAP 策略配置
	 */
	@Autowired(required = false)
	private QuoteStrategy quoteStrategy;
	
	@Autowired(required = false)
	private TmCustomerBackExtendService tmCustomerBackExtendService;

	/**
	 * 客户表单界面扩展
	 */
	@Autowired(required = false)
	private TmCustomerFormExtendService tmCustomerFormExtendService;

	/**
	 * 客户互敬互爱界面扩展
	 */
	@Autowired(required = false)
	private TmCustomerMainExtendService tmCustomerMainExtendService;
	
	/**
	 * 经销商主界面
	 * @return 页面视图
	 */
	@RequestMapping(value="goTmCustomerMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmCustomerMain(HttpServletRequest request){
     	request.setAttribute("extendTableName",Globals.Table_CUSTOMER);
		if(tmCustomerMainExtendService != null){
			request.setAttribute("includeJSP", tmCustomerMainExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerMain");
	}
	/**
	 * 经销商主界面
	 * @param vo vo对象
	 * @param singleSelect 是否单选
	 * @return 页面视图
	 */
	@RequestMapping(value="goTmCustSearch",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmCustSearch(TmCustomerVo vo,String singleSelect,String searchUrl){
		ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerSearchMain");
		if(StringUtil.isEmpty(searchUrl)){
			searchUrl="tmCustomerController.do?findTmCustomerBySearchList";
		}
		view.addObject("searchUrl",searchUrl);
		view.addObject("vo",vo);
		view.addObject("extendTableName",Globals.Table_CUSTOMER);
		view.addObject("singleSelect", singleSelect);
		return view;
	}
	
	/**
	 * 跳转经销商新增
	 * @param CustomerVo 经销商vo对象
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="goTmCustomer", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmCustomer(TmCustomerVo customerVo,
			HttpServletRequest request,HttpServletResponse response){
		String sql=DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
		
		//表单类型0新增1编辑2查看
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		
		//动态表单参数 表名
		request.setAttribute("extendTableName",Globals.Table_CUSTOMER);
		
		String id=customerVo.getId();
		if(StringUtil.isNotEmpty(id)){
			Page page=new EuPage(request);
			customerVo=tmCustomerService.getTmCustomerVoById(customerVo,page);
			request.setAttribute(Globals.Table_CUSTOMER, customerVo);
			
			//查询对应职位业务组信息
			TmCustPostVo cust=new TmCustPostVo();
			cust.setCustomerId(id);
			List<TmCustPostVo> custPostList=tmCustPostService.findTmCustPostList(cust);
			request.setAttribute("custPostList", custPostList);
		}
		
		if(tmCustomerFormExtendService != null){
			request.setAttribute("includeJSP", tmCustomerFormExtendService.includeJsp());
		}
		
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerForm");
	}
	
	
	/**
	 * 查看经销商关联终端列表 
	 * @return 页面视图
	 */
	@RequestMapping(value="goTermCustPostMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTermCustPostMain(String id,HttpServletRequest request){
		request.setAttribute("customerId", id);
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/customerTerm");
	}
	
	/**
	 * 查询经销商信息数据
	 * @param customerVo
	 * @param request
	 * @return 
	 */
	@RequestMapping(value="findTmCustomerList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmCustomerList(TmCustomerVo customerVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmCustomerVo> customerList=
				tmCustomerService.findTmCustomerList(customerVo, page);
		return new DataGrid(customerList, page);
	}
	/**
	 * 业务标签查询经销商信息
	 * @param customerVo
	 * @param request
	 * @return 
	 */
	@RequestMapping(value="findTmCustomerBySearchList",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmCustomerBySearchList(TmCustomerVo customerVo,HttpServletRequest request){
		Page page=new EuPage(request);
		if(StringUtil.isNotEmpty(customerVo.getSearchParam())){
			customerVo.setCustomerName(customerVo.getSearchParam());
		}
		List<TmCustomerVo> customerList;
		try {
			customerList = tmCustomerService.findTmCustomerList(customerVo,
					page);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取客户信息失败,"+e.getMessage());
		}
		return new DataGrid(customerList, page);
	}
	/**
	 * 业务标签查询经销商信息
	 * @param customerVo
	 * @param request
	 * @return 
	 */
	@RequestMapping(value="getTmCustomerBySearchList",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public AjaxJson getTmCustomerBySearchList(TmCustomerVo customerVo,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		Map<String, Object> aMap = new HashMap<String, Object>();
		Page page=new EuPage(request);
		try {
			if (StringUtil.isNotEmpty(customerVo.getSearchParam())) {
				customerVo.setCustomerName(customerVo.getSearchParam());
			}
			List<TmCustomerVo> customerList = tmCustomerService
					.findTmCustomerList(customerVo, page);
			aMap.put("totle", customerList.size());
			j.setObj(customerList);
		} catch (Exception e) {
			j.setSuccess(false);
			aMap.put("totle", 0);
			e.printStackTrace();
		}
		j.setAttributes(aMap);
		return j;
	}
	
	/**
	 * 查询经销商信息数据.
	 * @param customerVo
	 * @param request
	 * @return 
	 */
	@RequestMapping(value="findTmCustomerByPosList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmCustomerByPosList(TmCustomerVo customerVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmCustomerVo> customerList=
				tmCustomerService.findTmCustomerByPosList(customerVo, page);
		return new DataGrid(customerList, page);
	}
	
	/**
	 * 读取客户erpcode
	 * @param erpCode 经销商vo对象
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="getErpCodeInfo", method = {RequestMethod.GET, RequestMethod.POST})
	public void getCustErpCode(String erpCode,
			HttpServletRequest request,HttpServletResponse response){
		TmCustomerVo vo = new TmCustomerVo();
		if(quoteStrategy != null) {
			vo = quoteStrategy.remoteAccess(erpCode);
		}
		super.sendObjToJSON(response,vo);
	}
	
	/**
	 * 保存经销商信息
	 * @param CustomerVo 经销商vo对象
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value="saveTmCustomer", method = {RequestMethod.GET, RequestMethod.POST})
	public void saveCustomer(TmCustomerVo customerVo,
			HttpServletRequest request,HttpServletResponse response){
		Page page = new EuPage(request);
		String id = tmCustomerService.saveTmCustomer(customerVo, page);
		if (null != tmCustomerBackExtendService){
			tmCustomerBackExtendService.afterSaveCustomer(id);
		}
		super.sendResponse(response);
	}
	
	/**
	 * 删除经销商信息
	 * @param ids 经销商vo对象
	 * @param request 请求对象
	 */
	@RequestMapping(value="deleteTmCustomer", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTmCustomer(String ids,HttpServletRequest request){
		AjaxJson ajaxJson=new AjaxJson();
		try {
			Page page = new EuPage(request);
			ajaxJson = tmCustomerService.deleteTmCustomer(ids,page);
			if (null != tmCustomerBackExtendService){
				Map<String, Object> attributes = ajaxJson.getAttributes();
				Object customerCodeList = attributes.get("customerCodeList");
				if (null != customerCodeList){
					tmCustomerBackExtendService.deleteTmCustomer((List<String>)customerCodeList);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			ajaxJson.setMsg("删除失败:"+e.getMessage());
		}
		return ajaxJson;
	}
	
	/**
	 * <p>跳转到日志管理主页面<br>
	 * @author Sean
	 * @return 日志管理主界面
	 */
	@RequestMapping(value = "goTmLogDetailMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmLogDetailMain( HttpServletRequest request) {
		String businessId=request.getParameter("id");
		request.setAttribute("actionUrl", "tmCustomerController.do?findTmLogList&businessId="+businessId);
		return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
	}
	
	/**
	 * 分页获取日志列表信息
	 * @author Sean
	 * @param tmLogVo 日志实体模型
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findTmLogList",method = {RequestMethod.GET,RequestMethod.POST})
	public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TmLogVo> tmLogList = tmCustomerService.findCustomerLogList(tmLogVo, page);
		this.datagridReturn(response, tmLogList, page);
	}
	
	/**
	 * 导出excel
	 * @param customerVo
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmCustomerVo customerVo, HttpServletRequest request, HttpServletResponse response) {
		List<TmCustomerVo> customerList=
				tmCustomerService.findTmCustomerList(customerVo, null);
		doExportXls(response, request, customerList, TmCustomerVo.class, "客户列表");
	}
	/**
	 * 客户管理验证重复名称
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param tmCustomerVo 客户Vo
	 * @return 返回验证信息
	 */
	@RequestMapping(value = "validateCustomerName",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateCustomerName(HttpServletRequest request ,TmCustomerVo tmCustomerVo){
		String param  = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(tmCustomerVo.getId())){
			//修改
			Criterion cr1 = Restrictions.eq("customerName", param);
			Criterion cr2 = Restrictions.ne("id", tmCustomerVo.getId());
			List<TmCustomerEntity> tmCustomers = tmCustomerService.findByCriteria(TmCustomerEntity.class, cr1, cr2);
			if(!CollectionUtils.isEmpty(tmCustomers)){
				validForm.setStatus("n");
				validForm.setInfo("客户名称已存在");
			}
		}else{
			//新增
			List<TmCustomerEntity> tmcusts = tmCustomerService.findByProperty(TmCustomerEntity.class, "customerName", param);
			if(!CollectionUtils.isEmpty(tmcusts)){
				validForm.setStatus("n");
				validForm.setInfo("客户名称已存在");
			}
		}
		return validForm;
	}
	
	
	/**
	 * TPM查询客户列表 
	 * @return 页面视图
	 */
	@RequestMapping(value="goTpmCustMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTpmCustMain(TmCustomerVo customerVo,HttpServletRequest request){
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/chooseCustomerMain");
	}
	
	/**
	 * TPM查询客户数据库.
	 * @param customerVo
	 * @param request
	 * @return 
	 */
	@RequestMapping(value="findTpmCustomerList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTpmCustomerList(TmCustomerVo customerVo,HttpServletRequest request){
		Page page=new EuPage(request);
		List<TmCustomerVo> customerList = tmCustomerService.findTpmCustomerList(customerVo, page);
		return new DataGrid(customerList, page);
	}

	/**
	 * 跳转职位列表.
	 * @author grover
	 * @param tmCustomerVo 客户vo对象
	 * @param request 请求对象
	 * @return 职位页面
	 */
	@RequestMapping(value = "goTmCustomerByOrgMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmCustomerByOrgMain(TmCustomerVo tmCustomerVo, HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmCustomerVo.getOrgId())){
			request.setAttribute("orgId", tmCustomerVo.getOrgId());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmCustomer/tmCustomerByOrgMain");
	}

	/**
	 * 根据组织查询经销商信息数据
	 * @param customerVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value="findTmCustomerListByOrgMain", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTmCustomerListByOrgMain(TmCustomerVo customerVo,HttpServletRequest request){
		Page page=new EuPage(request);
		//当前登录人的组织
		customerVo.setCurrentOrgId(ResourceConfigUtils.getCurrOrg().getId());
		List<TmCustomerVo> customerList=
				tmCustomerService.findTmCustomerListByOrgMain(customerVo, page);
		return new DataGrid(customerList, page);
	}

	/**
	 * 调整客户与组织的关系.
	 * @param request 请求对象
	 * @param tmOrgVo 组织vo对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "changeCustomerForOrg", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson changeCustomerForOrg(HttpServletRequest request,TmOrgVo tmOrgVo) {
		AjaxJson j = new AjaxJson();
		try {
			j = tmCustomerService.changeCustomerForOrg(tmOrgVo);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("调整关系失败,请稍后再试");
			e.printStackTrace();
		}
		return j;
	}
}
