package com.biz.eisp.mdm.customer.dao;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.customer.vo.QueryTmCustomerVo;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;

import java.util.List;

/** 
 * 经销商管理Dao
 * @author 肖胜
 * @version v1.0
 */
@InterfaceDao
public interface TmCustomerDao {
	
	/**
	 * 条件查询经销商信息
	 * @param customerVo 查询参数
	 * @param page 分页参数
	 * @return 集合
	 */
	@Arguments({"customerVo","page","sql"})
	@ResultType(TmCustomerVo.class)
	public List<TmCustomerVo> findTmCustomerList(TmCustomerVo customerVo
			,Page page, String sql);

	@Arguments({"customerId","sql"})
	@ResultType(TmCustomerVo.class)
	public List<TmCustomerVo> findTmCustomerListChildren(String customerId, String sql);
	/**
	 * 查询经销商业务组及其业务组的明细信息.
	 * <p>
	 * @param custPostVo
	 * @return
	 */
	@Arguments({"custPostVo"})
	@ResultType(TmCustPostVo.class) 
	public List<TmCustPostVo> findTmCustPostDetailList(TmCustPostVo custPostVo);
	
	/**
	 * 条件查询经销商信息
	 * @param customerVo 查询参数
	 * @param page 分页参数
	 * @return 集合
	 */
	@Arguments({"customerVo","page"})
	@ResultType(TmCustomerVo.class)
	List<TmCustomerVo> findTmCustomerByPosList(TmCustomerVo customerVo ,Page page);
	
	/**
	 * TPM查询客户数据库.
	 * @param customerVo 查询参数
	 * @param page 分页参数
	 * @return 集合
	 */
	@Arguments({"customerVo","page"})
	@ResultType(TmCustomerVo.class)
	List<TmCustomerVo> findTpmCustomerList(TmCustomerVo customerVo, Page page);
	
	/**
	 *选择职位弹出框datagrid
	 * @param customerVo 查询参数
	 * @param page 分页参数
	 * @return 集合
	 */
	@Arguments({"customerVo","page"})
	@ResultType(TmCustPostVo.class)
	List<TmCustPostVo> findTmCustPostList(TmCustPostVo customerVo ,Page page);
	
	/**
	 * 更新时 查询已绑定的职位信息
	 * @param customerVo
	 * @return
	 */
	@Arguments({"customerVo","sql"})
	@ResultType(TmCustPostVo.class)
	List<TmCustPostVo> findPostByCustList(TmCustPostVo customerVo,String sql);
	
	/**
	 * 所有查询客户可能的方式.
	 * @author grover
	 * @param queryTmCustomerVo 客户查询vo
	 * @param page 分页对象
	 * @return 客户信息
	 */
	@Arguments({"queryTmCustomerVo","page"})
	@ResultType(TmCustomerVo.class)
	List<TmCustomerVo> findTmCustTomerByAllPossible(QueryTmCustomerVo queryTmCustomerVo, Page page);
	/**
	 * 根据组织及其下级组织和客户类型集合获取客户.
	 * @author grover
	 * 
	 * @param queryTmCustomerVo
	 * 			查询vo
	 * @param page
	 * 			页面对象
	 * @return
	 */
	@Arguments({"queryTmCustomerVo","page"})
	@ResultType(TmCustomerVo.class)
	List<TmCustomerVo> findTmCustTomerByOrgAndCustType(QueryTmCustomerVo queryTmCustomerVo, Page page);
	
	/**
	 * 查看客户日志
	 * @param tmLogVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmLogVo","page"})
	@ResultType(TmLogVo.class)
	public List<TmLogVo> findCustomerLogList(TmLogVo tmLogVo, Page page);
	
	/**
	 * 根据查找 以下条件的经销商
	 * @author xuduan
	 * @param settlementCode 结算类型
	 * @param customerType 经销商类型
	 * @param contractCode 合同类型
	 * @param contractCode 组织
	 * @return
	 */
	@Arguments({"settlementCode","customerType","contractCode","orgId"})
	@ResultType(TmCustomerVo.class)
	public List<TmCustomerVo> findCustomer(String settlementCode,String customerType,String contractCode,String orgId);
	
	
	@ResultType(TmCustomerVo.class)
	@Arguments({"code"})
	public List<TmCustomerVo> findSapCustomer(String code);

	/**
	 * 根据组织查询经销商信息数据
	 * @param customerVo
	 * @param page
	 * @return
	 */
	@ResultType(TmCustomerVo.class)
	@Arguments({"customerVo","page"})
	public List<TmCustomerVo> findTmCustomerListByOrgMain(TmCustomerVo customerVo, Page page);
}
