package com.biz.eisp.mdm.customer.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;

/**
 * 客户业务组Dao.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@InterfaceDao
public interface TmRCustPosBgDetailDao {

	/**
	 * 根据客户id查询业务组信息列表.
	 * <p>
	 * 
	 * @param customerId
	 * @return
	 */
	@Arguments({"customerId"})
	@ResultType(TmBusinessGroupVo.class)
	public List<TmBusinessGroupVo> findTmBusinessGroupVoList(String customerId);

	/**
	 * 条件查询经销商信息 未关联任何职位
	 * @param tmCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmCustPostVo","page"})
	@ResultType(TmCustomerVo.class)
	public List<TmCustomerVo> findNotAnyPostCustomerList(TmCustPostVo tmCustPostVo, Page page);

	/**
	 * 条件查询经销商信息未关联当前职位
	 * @param tmCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	@Arguments({"tmCustPostVo","page"})
	@ResultType(TmCustomerVo.class)
	public List<TmCustomerVo> findNotCurrPostCustomerList(TmCustPostVo tmCustPostVo,Page page);
}
