package com.biz.eisp.mdm.customer.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/**
 * 客户经销商实体.
 * <p>
 * 关联表：tm_customer<br>
 * 
 * @author 肖胜
 * @version v1.0
 */
@Entity
@Table(name = "tm_customer")
public class TmCustomerEntity extends IdEntity implements Serializable, Loggerable {

	private static final long serialVersionUID = 1L;

	/**
	 * 客户编码
	 */
	private String customerCode;
	/**
	 * ERP编码
	 */
	private String erpCode;
	/**
	 * 客户名称
	 */
	private String customerName;
	/**
	 * 客户属性编码
	 */
	private String customerType;
	/**
	 * 渠道类型
	 */
	private String channelType;
	/**
	 * 客户联系人
	 */
	private String linkman;
	/**
	 * 客户电话
	 */
	private String linkmanPhone;
	/**
	 * 客户地址
	 */
	private String address;
	/**
	 * 合作状态
	 */
	private String cooperative;
	/**
	 * 省
	 */
	private String province;
	/**
	 * 市
	 */
	private String city;
	/**
	 * 区
	 */
	private String area;
	/**
	 * 启用状态：0-启用
	 */
	private Integer enableStatus;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建用户账号
	 */
	private String createName;
	/**
	 * 修改时间
	 */
	private Date updateDate;
	/**
	 * 修改用户账号
	 */
	private String updateName;
	/**
	 * 所属部门
	 */
	private TmOrgEntity tmOrg;
	/**
	 * 客户组织id
	 */
	private TmCustomerOrgEntity tmCustomerOrg;

	/**
	 * 字符类型（length=100）-扩展字段1
	 */
	private String extChar1;
	/**
	 * 字符类型（length=100）-扩展字段2
	 */
	private String extChar2;
	/**
	 * 字符类型（length=100）-扩展字段3
	 */
	private String extChar3;
	/**
	 * 字符类型（length=100）-扩展字段4
	 */
	private String extChar4;
	/**
	 * 字符类型（length=100）-扩展字段5
	 */
	private String extChar5;
	/**
	 * 字符类型（length=200）-扩展字段6
	 */
	private String extChar6;
	/**
	 * 字符类型（length=200）-扩展字段7
	 */
	private String extChar7;
	/**
	 * 字符类型（length=200）-扩展字段8
	 */
	private String extChar8;
	/**
	 * 字符类型（length=200）-扩展字段9
	 */
	private String extChar9;
	/**
	 * 字符类型（length=200）-扩展字段10
	 */
	private String extChar10;
	/**
	 * 字符类型（length=1000）-扩展字段12
	 */
	private String extChar12;
	/**
	 * 字符类型（length=1000）-扩展字段13
	 */
	private String extChar13;
	/**
	 * 字符类型（length=1000）-扩展字段14
	 */
	private String extChar14;
	/**
	 * 字符类型（length=1000）-扩展字段11
	 */
	private String extChar11;
	/**
	 * 字符类型（length=1000）-扩展字段15
	 */
	private String extChar15;
	/**
	 * 字符类型（length=500）-扩展字段16
	 */
	private String extChar16;
	/**
	 * 字符类型（length=500）-扩展字段17
	 */
	private String extChar17;
	/**
	 * 字符类型（length=500）-扩展字段18
	 */
	private String extChar18;
	/**
	 * 字符类型（length=500）-扩展字段19
	 */
	private String extChar19;
	/**
	 * 字符类型（length=500）-扩展字段20
	 */
	private String extChar20;
	/**
	 * 字符类型（length=500）-扩展字段21
	 */
	private String extChar21;
	/**
	 * 字符类型（length=500）-扩展字段22
	 */
	private String extChar22;
	/**
	 * 字符类型（length=500）-扩展字段23
	 */
	private String extChar23;
	/**
	 * 字符类型（length=500）-扩展字段24
	 */
	private String extChar24;
	/**
	 * 字符类型（length=500）-扩展字段25
	 */
	private String extChar25;
	/**
	 * 字符类型（length=500）-扩展字段26
	 */
	private String extChar26;
	/**
	 * 字符类型（length=500）-扩展字段27
	 */
	private String extChar27;
	/**
	 * 字符类型（length=500）-扩展字段28
	 */
	private String extChar28;
	/**
	 * 字符类型（length=500）-扩展字段29
	 */
	private String extChar29;
	/**
	 * 字符类型（length=500）-扩展字段30
	 */
	private String extChar30;
	/**
	 * 字符类型（length=500）-扩展字段31
	 */
	private String extChar31;
	/**
	 * 字符类型（length=500）-扩展字段32
	 */
	private String extChar32;
	/**
	 * 字符类型（length=500）-扩展字段33
	 */
	private String extChar33;
	/**
	 * 字符类型（length=500）-扩展字段34
	 */
	private String extChar34;
	/**
	 * 字符类型（length=500）-扩展字段35
	 */
	private String extChar35;
	/**
	 * 字符类型（length=500）-扩展字段36
	 */
	private String extChar36;
	/**
	 * 字符类型（length=500）-扩展字段37
	 */
	private String extChar37;
	/**
	 * 字符类型（length=500）-扩展字段38
	 */
	private String extChar38;
	/**
	 * 字符类型（length=500）-扩展字段39
	 */
	private String extChar39;
	/**
	 * 字符类型（length=500）-扩展字段40
	 */
	private String extChar40;
	/**
	 * 字符类型（length=500）-扩展字段41
	 */
	private String extChar41;
	/**
	 * 字符类型（length=500）-扩展字段42
	 */
	private String extChar42;
	/**
	 * 字符类型（length=500）-扩展字段43
	 */
	private String extChar43;
	/**
	 * 字符类型（length=500）-扩展字段44
	 */
	private String extChar44;
	/**
	 * 字符类型（length=500）-扩展字段45
	 */
	private String extChar45;
	/**
	 * 数字类型-扩展字段1
	 */
	private Integer extNumber1;
	/**
	 * 数字类型-扩展字段2
	 */
	private Integer extNumber2;
	/**
	 * 数字类型-扩展字段3
	 */
	private Integer extNumber3;
	/**
	 * 数字类型-扩展字段4
	 */
	private Integer extNumber4;
	/**
	 * 数字类型-扩展字段5
	 */
	private Integer extNumber5;

	// 经销商与业务组职位关联实体列表
	private List<TmRCustPosBGEntity> tmRCustPosBGList = new ArrayList<TmRCustPosBGEntity>();

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 客户编码
	 */
	@Column(name = "customer_code")
	public String getCustomerCode() {
		return customerCode;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 客户名称
	 */
	@Column(name = "customer_name")
	public String getCustomerName() {
		return customerName;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 客户类型
	 */
	@Column(name = "customer_type")
	public String getCustomerType() {
		return customerType;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 客户渠道
	 */
	@Column(name = "channel_type")
	public String getChannelType() {
		return channelType;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 联系人
	 */
	@Column(name = "linkman")
	public String getLinkman() {
		return linkman;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 联系人电话号码
	 */
	@Column(name = "linkman_phone")
	public String getLinkmanPhone() {
		return linkmanPhone;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 联系人地址
	 */
	@Column(name = "address")
	public String getAddress() {
		return address;
	}

	/**
	 * 方法：取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 状态
	 */
	@Column(name = "enable_status")
	public Integer getEnableStatus() {
		return enableStatus;
	}

	/**
	 * 方法：取得java.util.Date
	 * 
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "create_date")
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 创建人
	 */
	@Column(name = "create_name")
	public String getCreateName() {
		return createName;
	}

	/**
	 * 方法：取得java.util.Date
	 * 
	 * @return java.util.Date 更新时间
	 */
	@Column(name = "update_date")
	public Date getUpdateDate() {
		return updateDate;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 更新人
	 */
	@Column(name = "update_name")
	public String getUpdateName() {
		return updateName;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String erp编码
	 */
	@Column(name = "erp_code")
	public String getErpCode() {
		return erpCode;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 合作状态
	 */
	@Column(name = "cooperative")
	public String getCooperative() {
		return cooperative;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 省
	 */
	@Column(name = "province")
	public String getProvince() {
		return province;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 市
	 */
	@Column(name = "city")
	public String getCity() {
		return city;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 区/县
	 */
	@Column(name = "area")
	public String getArea() {
		return area;
	}

	/**
	 * 方法:取得com.biz.eisp.mdm.org.entity.TmOrgEntity
	 * 
	 * @return com.biz.eisp.mdm.org.entity.TmOrgEntity 所属组织
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "org_id")
	@JsonIgnore
	public TmOrgEntity getTmOrg() {
		return tmOrg;
	}

	/**
	 * 方法:取得com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity
	 * 
	 * @return com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity所属客户组织
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "customer_org_id")
	@JsonIgnore
	public TmCustomerOrgEntity getTmCustomerOrg() {
		return tmCustomerOrg;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段1
	 */
	@Column(name = "ext_char_1")
	public String getExtChar1() {
		return extChar1;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段2
	 */
	@Column(name = "ext_char_2")
	public String getExtChar2() {
		return extChar2;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段3
	 */
	@Column(name = "ext_char_3")
	public String getExtChar3() {
		return extChar3;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段4
	 */
	@Column(name = "ext_char_4")
	public String getExtChar4() {
		return extChar4;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段5
	 */
	@Column(name = "ext_char_5")
	public String getExtChar5() {
		return extChar5;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段6
	 */
	@Column(name = "ext_char_6")
	public String getExtChar6() {
		return extChar6;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段7
	 */
	@Column(name = "ext_char_7")
	public String getExtChar7() {
		return extChar7;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段8
	 */
	@Column(name = "ext_char_8")
	public String getExtChar8() {
		return extChar8;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段9
	 */
	@Column(name = "ext_char_9")
	public String getExtChar9() {
		return extChar9;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段10
	 */
	@Column(name = "ext_char_10")
	public String getExtChar10() {
		return extChar10;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段11
	 */
	@Column(name = "ext_char_11")
	public String getExtChar11() {
		return extChar11;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段12
	 */
	@Column(name = "ext_char_12")
	public String getExtChar12() {
		return extChar12;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段13
	 */
	@Column(name = "ext_char_13")
	public String getExtChar13() {
		return extChar13;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段14
	 */
	@Column(name = "ext_char_14")
	public String getExtChar14() {
		return extChar14;
	}

	/**
	 * 方法：取得java.lang.String
	 * 
	 * @return java.lang.String 字符扩展字段15
	 */
	@Column(name = "ext_char_15")
	public String getExtChar15() {
		return extChar15;
	}

	/**
	 * 方法：取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 数字扩展字段1
	 */
	@Column(name = "ext_number_1")
	public Integer getExtNumber1() {
		return extNumber1;
	}

	/**
	 * 方法：取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 数字扩展字段2
	 */
	@Column(name = "ext_number_2")
	public Integer getExtNumber2() {
		return extNumber2;
	}

	/**
	 * 方法：取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 数字扩展字段3
	 */
	@Column(name = "ext_number_3")
	public Integer getExtNumber3() {
		return extNumber3;
	}

	/**
	 * 方法：取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 数字扩展字段4
	 */
	@Column(name = "ext_number_4")
	public Integer getExtNumber4() {
		return extNumber4;
	}

	/**
	 * 方法：取得java.lang.Integer
	 * 
	 * @return java.lang.Integer 数字扩展字段5
	 */
	@Column(name = "ext_number_5")
	public Integer getExtNumber5() {
		return extNumber5;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            客户编码
	 */
	public void setCustomerCode(String customerCode) {
		this.customerCode = customerCode;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            客户名称
	 */
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            客户类型
	 */
	public void setCustomerType(String customerType) {
		this.customerType = customerType;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            客户渠道
	 */
	public void setChannelType(String channelType) {
		this.channelType = channelType;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            联系人
	 */
	public void setLinkman(String linkman) {
		this.linkman = linkman;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            联系人电话号码
	 */
	public void setLinkmanPhone(String linkmanPhone) {
		this.linkmanPhone = linkmanPhone;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            联系人地址
	 */
	public void setAddress(String address) {
		this.address = address;
	}

	/**
	 * 方法:设置java.lang.Integer
	 * 
	 * @param java.lang.Integer
	 *            状态
	 */
	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}

	/**
	 * 方法:设置java.util.Date
	 * 
	 * @param java.util.Date
	 *            创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}

	/**
	 * 方法:设置java.util.Date
	 * 
	 * @param java.util.Date
	 *            跟新时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            跟新人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段1
	 */
	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段2
	 */
	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段3
	 */
	public void setExtChar3(String extChar3) {
		this.extChar3 = extChar3;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段4
	 */
	public void setExtChar4(String extChar4) {
		this.extChar4 = extChar4;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段5
	 */
	public void setExtChar5(String extChar5) {
		this.extChar5 = extChar5;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段6
	 */
	public void setExtChar6(String extChar6) {
		this.extChar6 = extChar6;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段7
	 */
	public void setExtChar7(String extChar7) {
		this.extChar7 = extChar7;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段8
	 */
	public void setExtChar8(String extChar8) {
		this.extChar8 = extChar8;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段9
	 */
	public void setExtChar9(String extChar9) {
		this.extChar9 = extChar9;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段10
	 */
	public void setExtChar10(String extChar10) {
		this.extChar10 = extChar10;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段12
	 */
	public void setExtChar12(String extChar12) {
		this.extChar12 = extChar12;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段13
	 */
	public void setExtChar13(String extChar13) {
		this.extChar13 = extChar13;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段14
	 */
	public void setExtChar14(String extChar14) {
		this.extChar14 = extChar14;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段11
	 */
	public void setExtChar11(String extChar11) {
		this.extChar11 = extChar11;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            字符扩展字段15
	 */
	public void setExtChar15(String extChar15) {
		this.extChar15 = extChar15;
	}

	@Column(name = "ext_char_16")
	public String getExtChar16() {
		return extChar16;
	}

	public void setExtChar16(String extChar16) {
		this.extChar16 = extChar16;
	}

	@Column(name = "ext_char_17")
	public String getExtChar17() {
		return extChar17;
	}

	public void setExtChar17(String extChar17) {
		this.extChar17 = extChar17;
	}

	@Column(name = "ext_char_18")
	public String getExtChar18() {
		return extChar18;
	}

	public void setExtChar18(String extChar18) {
		this.extChar18 = extChar18;
	}

	@Column(name = "ext_char_19")
	public String getExtChar19() {
		return extChar19;
	}

	public void setExtChar19(String extChar19) {
		this.extChar19 = extChar19;
	}

	@Column(name = "ext_char_20")
	public String getExtChar20() {
		return extChar20;
	}

	public void setExtChar20(String extChar20) {
		this.extChar20 = extChar20;
	}

	@Column(name = "ext_char_21")
	public String getExtChar21() {
		return extChar21;
	}

	public void setExtChar21(String extChar21) {
		this.extChar21 = extChar21;
	}

	@Column(name = "ext_char_22")
	public String getExtChar22() {
		return extChar22;
	}

	public void setExtChar22(String extChar22) {
		this.extChar22 = extChar22;
	}

	@Column(name = "ext_char_23")
	public String getExtChar23() {
		return extChar23;
	}

	public void setExtChar23(String extChar23) {
		this.extChar23 = extChar23;
	}

	@Column(name = "ext_char_24")
	public String getExtChar24() {
		return extChar24;
	}

	public void setExtChar24(String extChar24) {
		this.extChar24 = extChar24;
	}

	@Column(name = "ext_char_25")
	public String getExtChar25() {
		return extChar25;
	}

	public void setExtChar25(String extChar25) {
		this.extChar25 = extChar25;
	}
	
	@Column(name = "ext_char_26")
	public String getExtChar26() {
		return extChar26;
	}
	
	@Column(name = "ext_char_27")
	public String getExtChar27() {
		return extChar27;
	}

	@Column(name = "ext_char_28")
	public String getExtChar28() {
		return extChar28;
	}

	@Column(name = "ext_char_29")
	public String getExtChar29() {
		return extChar29;
	}

	@Column(name = "ext_char_30")
	public String getExtChar30() {
		return extChar30;
	}
	
	@Column(name = "ext_char_31")
	public String getExtChar31() {
		return extChar31;
	}

	public void setExtChar31(String extChar31) {
		this.extChar31 = extChar31;
	}
	
	@Column(name = "ext_char_32")
	public String getExtChar32() {
		return extChar32;
	}

	public void setExtChar32(String extChar32) {
		this.extChar32 = extChar32;
	}
	
	@Column(name = "ext_char_33")
	public String getExtChar33() {
		return extChar33;
	}

	public void setExtChar33(String extChar33) {
		this.extChar33 = extChar33;
	}
	
	@Column(name = "ext_char_34")
	public String getExtChar34() {
		return extChar34;
	}

	public void setExtChar34(String extChar34) {
		this.extChar34 = extChar34;
	}

	@Column(name = "ext_char_35")
	public String getExtChar35() {
		return extChar35;
	}

	public void setExtChar35(String extChar35) {
		this.extChar35 = extChar35;
	}

	@Column(name = "ext_char_36")
	public String getExtChar36() {
		return extChar36;
	}

	public void setExtChar36(String extChar36) {
		this.extChar36 = extChar36;
	}

	@Column(name = "ext_char_37")
	public String getExtChar37() {
		return extChar37;
	}

	public void setExtChar37(String extChar37) {
		this.extChar37 = extChar37;
	}

	@Column(name = "ext_char_38")
	public String getExtChar38() {
		return extChar38;
	}

	public void setExtChar38(String extChar38) {
		this.extChar38 = extChar38;
	}

	@Column(name = "ext_char_39")
	public String getExtChar39() {
		return extChar39;
	}

	public void setExtChar39(String extChar39) {
		this.extChar39 = extChar39;
	}

	@Column(name = "ext_char_40")
	public String getExtChar40() {
		return extChar40;
	}

	public void setExtChar40(String extChar40) {
		this.extChar40 = extChar40;
	}

	@Column(name = "ext_char_41")
	public String getExtChar41() {
		return extChar41;
	}

	public void setExtChar41(String extChar41) {
		this.extChar41 = extChar41;
	}

	@Column(name = "ext_char_42")
	public String getExtChar42() {
		return extChar42;
	}

	public void setExtChar42(String extChar42) {
		this.extChar42 = extChar42;
	}

	@Column(name = "ext_char_43")
	public String getExtChar43() {
		return extChar43;
	}

	public void setExtChar43(String extChar43) {
		this.extChar43 = extChar43;
	}

	@Column(name = "ext_char_44")
	public String getExtChar44() {
		return extChar44;
	}

	public void setExtChar44(String extChar44) {
		this.extChar44 = extChar44;
	}

	@Column(name = "ext_char_45")
	public String getExtChar45() {
		return extChar45;
	}

	public void setExtChar45(String extChar45) {
		this.extChar45 = extChar45;
	}

	public void setExtChar26(String extChar26) {
		this.extChar26 = extChar26;
	}

	public void setExtChar27(String extChar27) {
		this.extChar27 = extChar27;
	}

	public void setExtChar28(String extChar28) {
		this.extChar28 = extChar28;
	}

	public void setExtChar29(String extChar29) {
		this.extChar29 = extChar29;
	}

	public void setExtChar30(String extChar30) {
		this.extChar30 = extChar30;
	}
	
	/**
	 * 方法:设置java.lang.Integer
	 * 
	 * @param java.lang.Integer
	 *            数字扩展字段1
	 */
	public void setExtNumber1(Integer extNumber1) {
		this.extNumber1 = extNumber1;
	}

	/**
	 * 方法:设置java.lang.Integer
	 * 
	 * @param java.lang.Integer
	 *            数字扩展字段2
	 */
	public void setExtNumber2(Integer extNumber2) {
		this.extNumber2 = extNumber2;
	}

	/**
	 * 方法:设置java.lang.Integer
	 * 
	 * @param java.lang.Integer
	 *            数字扩展字段3
	 */
	public void setExtNumber3(Integer extNumber3) {
		this.extNumber3 = extNumber3;
	}

	/**
	 * 方法:设置java.lang.Integer
	 * 
	 * @param java.lang.Integer
	 *            数字扩展字段4
	 */
	public void setExtNumber4(Integer extNumber4) {
		this.extNumber4 = extNumber4;
	}

	/**
	 * 方法:设置java.lang.Integer
	 * 
	 * @param java.lang.Integer
	 *            数字扩展字段5
	 */
	public void setExtNumber5(Integer extNumber5) {
		this.extNumber5 = extNumber5;
	}

	/**
	 * 方法：设置com.biz.eisp.mdm.org.entity.TmOrgEntity
	 * 
	 * @param com.biz.eisp.mdm.org.entity.TmOrgEntity
	 *            所属组织
	 */
	public void setTmOrg(TmOrgEntity tmOrg) {
		this.tmOrg = tmOrg;
	}

	/**
	 * 方法：设置 com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity
	 * 
	 * @param com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity
	 *            所属客户组织
	 */
	public void setTmCustomerOrg(TmCustomerOrgEntity tmCustomerOrg) {
		this.tmCustomerOrg = tmCustomerOrg;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            erp编码
	 */
	public void setErpCode(String erpCode) {
		this.erpCode = erpCode;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            合作状态
	 */
	public void setCooperative(String cooperative) {
		this.cooperative = cooperative;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            省
	 */
	public void setProvince(String province) {
		this.province = province;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            市
	 */
	public void setCity(String city) {
		this.city = city;
	}

	/**
	 * 方法:设置java.lang.String
	 * 
	 * @param java.lang.String
	 *            区县
	 */
	public void setArea(String area) {
		this.area = area;
	}

	/**
	 * 方法：取得java.util.List<com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity>
	 * 
	 * @return java.util.List
	 *         <com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity>
	 *         经销商与业务组职位关联实体列表
	 */
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	@JoinColumn(name = "customer_id")
	@JsonIgnore
	@Fetch(FetchMode.SUBSELECT)
	public List<TmRCustPosBGEntity> getTmRCustPosBGList() {
		return tmRCustPosBGList;
	}

	/**
	 * 方法：设置java.util.List<com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity>
	 * 
	 * @param java.util.List
	 *            <com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity>
	 *            经销商与业务组职位关联实体列表
	 */
	public void setTmRCustPosBGList(List<TmRCustPosBGEntity> tmRCustPosBGList) {
		this.tmRCustPosBGList = tmRCustPosBGList;
	}

	@Override
	public String businessDesc() {
		return "客户基本信息";
	}

	@Override
	public String addLogContent() {
		return null;
	}

	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}



}
