package com.biz.eisp.mdm.customer.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;

/** 
 * 经销商与业务组职位关联实体
 * @author 肖胜
 * @version v1.0
 */
@Entity
@Table(name = "TM_R_CUST_POS_BG")
public class TmRCustPosBGEntity extends IdEntity implements Serializable{
	
	private static final long serialVersionUID = 1L;
	/**
	 * 业务组
	 */
	private String businessGroup;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/*
	 * 创建用户账号
	 */
	private String createName;
	/**
	 * 经销商实体
	 */
	private TmCustomerEntity tmCustomer;
	/**
	 * 职位实体
	 */
	private TmPositionEntity tmPosition;
	private String orgId;

	/**
	 * 备注1
	 */
	private String extChar1;
	/**
	 * 备注2
	 */
	private String extChar2;

	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 业务组
	 */
	@Column(name = "business_group")
	public String getBusinessGroup() {
		return businessGroup;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param java.lang.String 业务组
	 */
	public void setBusinessGroup(String businessGroup) {
		this.businessGroup = businessGroup;
	}
	/**
	 * 方法：取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "create_date")
	public Date getCreateDate(){
		return createDate;
	}
	/**
	 * 方法：设置java.util.Date
	 * @param java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 方法：取得java.lang.String
	 * @return java.lang.String 创建人 
	 */
	@Column(name = "create_name")
	public String getCreateName(){
		return createName;
	}
	/**
	 * 方法：设置java.lang.Stirng 
	 * @param java.lang.String 创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 * 方法:取得com.biz.eisp.mdm.customer.entity.TmCustomerEntity
	 * @return com.biz.eisp.mdm.customer.entity.TmCustomerEntity 经销商
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "customer_id",referencedColumnName="id",updatable=true,insertable=true)
	public TmCustomerEntity getTmCustomer() {
		return tmCustomer;
	}
	/**
	 * 方法:设置com.biz.eisp.mdm.customer.entity.TmCustomerEntity
	 * @param com.biz.eisp.mdm.customer.entity.TmCustomerEntity 经销商
	 */
	public void setTmCustomer(TmCustomerEntity tmCustomer) {
		this.tmCustomer = tmCustomer;
	}
	/**
	 * 方法:取得com.biz.eisp.mdm.position.entity.TmPositionEntity
	 * @return com.biz.eisp.mdm.position.entity.TmPositionEntity 职位
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "position_id")
	public TmPositionEntity getTmPosition() {
		return tmPosition;
	}
	/**
	 * 方法:设置com.biz.eisp.mdm.position.entity.TmPositionEntity
	 * @param com.biz.eisp.mdm.position.entity.TmPositionEntity 职位
	 */
	public void setTmPosition(TmPositionEntity tmPosition) {
		this.tmPosition = tmPosition;
	}
	@Column(name = "org_id")
	public String getOrgId() {
		return orgId;
	}
	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}
//	@Override
//	public String businessDesc() {
//		
//		return "客户与职位对应关系";
//	}
//	@Override
//	public String addLogContent() {
//		String content="";
//		if(tmCustomer!=null){
//			content+="客户["+
//					tmCustomer.getCustomerCode()+"-"+tmCustomer.getCustomerName()+"]";
//		}
//		if(tmPosition!=null){
//			content+=",关联职位["+
//					tmPosition.getPositionCode()+"-"+tmPosition.getPositionName()+"]"+"</br>";
//		}
//		return content;
//	}
//	
//	@Override
//	public String updateLogContent(List<ModifyObject> modifyFieldList) {
//		return "";
//	}

	@Column(name = "EXT_CHAR_1")
	public String getExtChar1() {
		return extChar1;
	}

	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}

	@Column(name = "EXT_CHAR_2")
	public String getExtChar2() {
		return extChar2;
	}

	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}
	
}
