package com.biz.eisp.mdm.customer.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/**
 * @Title: Entity
 * @Description: 客户业务组信息实体
 * @author Sean
 * @date 2017-03-28 16:19:30
 * @version V1.0
 *
 */
@Entity
@Table(name = "tm_r_cust_pos_bg_detail", schema = "")
@SuppressWarnings("serial")
public class TmRCustPosBgDetailEntity extends IdEntity implements java.io.Serializable {
	/** 业务类型名称，冗余字段，对应数据字典tm_cust_pos_bg_detail_type名称值 */
	private java.lang.String typeName;
	/** 业务类型编码，对应数据字典tm_cust_pos_bg_detail_type编码值 */
	private java.lang.String typeCode;
	/** 业务组编码，对应tm_r_cust_pos_bg的business_group字段 */
	private java.lang.String businessGroup;
	/** 明细业务数据名称，如：产品名称 */
	private java.lang.String detailName;
	/** 明细业务数据编码，如产品编码 */
	private java.lang.String detailCode;

	/**
	 * 方法: 取得java.lang.String
	 * 
	 * @return: java.lang.String 业务类型名称，冗余字段，对应数据字典tm_cust_pos_bg_detail_type名称值
	 */
	@Column(name = "TYPE_NAME", nullable = true, length = 100)
	public java.lang.String getTypeName() {
		return this.typeName;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             业务类型名称，冗余字段，对应数据字典tm_cust_pos_bg_detail_type名称值
	 */
	public void setTypeName(java.lang.String typeName) {
		this.typeName = typeName;
	}

	/**
	 * 方法: 取得java.lang.String
	 * 
	 * @return: java.lang.String 业务类型编码，对应数据字典tm_cust_pos_bg_detail_type编码值
	 */
	@Column(name = "TYPE_CODE", nullable = true, length = 50)
	public java.lang.String getTypeCode() {
		return this.typeCode;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             业务类型编码，对应数据字典tm_cust_pos_bg_detail_type编码值
	 */
	public void setTypeCode(java.lang.String typeCode) {
		this.typeCode = typeCode;
	}

	/**
	 * 方法: 取得java.lang.String
	 * 
	 * @return: java.lang.String 业务组编码，对应tm_r_cust_pos_bg的business_group字段
	 */
	@Column(name = "BUSINESS_GROUP", nullable = true, length = 50)
	public java.lang.String getBusinessGroup() {
		return this.businessGroup;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             业务组编码，对应tm_r_cust_pos_bg的business_group字段
	 */
	public void setBusinessGroup(java.lang.String businessGroup) {
		this.businessGroup = businessGroup;
	}

	/**
	 * 方法: 取得java.lang.String
	 * 
	 * @return: java.lang.String 明细业务数据名称，如：产品名称
	 */
	@Column(name = "DETAIL_NAME", nullable = true, length = 200)
	public java.lang.String getDetailName() {
		return this.detailName;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             明细业务数据名称，如：产品名称
	 */
	public void setDetailName(java.lang.String detailName) {
		this.detailName = detailName;
	}

	/**
	 * 方法: 取得java.lang.String
	 * 
	 * @return: java.lang.String 明细业务数据编码，如产品编码
	 */
	@Column(name = "DETAIL_CODE", nullable = true, length = 50)
	public java.lang.String getDetailCode() {
		return this.detailCode;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             明细业务数据编码，如产品编码
	 */
	public void setDetailCode(java.lang.String detailCode) {
		this.detailCode = detailCode;
	}
}
