package com.biz.eisp.mdm.customer.service;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;

import java.util.List;

/** 
 * 经销商岗位关系service接口
 * @author 肖胜
 * @version v1.0
 */
public interface TmCustPostService extends BaseService{

	/**
	 * 删除经销商岗位关系信息
	 * @param customerVo 经销商Vo实体
	 */
	public void deleteTmCustPost(TmCustPostVo customerVo);
	
	/**
	 * 查询经销商岗位关系信息
	 * @param customerVo 经销商Vo实体
	 * @return TmCustPostVo集合
	 */
	public List<TmCustPostVo> findTmCustPostList(TmCustPostVo customerVo);
	
	/**
	 * 查询经销商岗位关系信息
	 * @param customerVo 经销商Vo实体
	 * @return TmCustPostVo集合
	 */
	public List<TmCustPostVo> findPostList(TmCustPostVo customerVo,Page page);

	/**
	 * 条件查询经销商信息 未关联任何职位
	 * @param tmCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	public List<TmCustomerVo> findNotAnyPostCustomerList(TmCustPostVo tmCustPostVo, Page page);

	/**
	 * 条件查询经销商信息未关联当前职位
	 * @param tmCustPostVo 查询条件
	 * @param page
	 * @return
	 */
	public List<TmCustomerVo> findNotCurrPostCustomerList(TmCustPostVo tmCustPostVo, Page page);

	/**
	 * 批量添加职位与客户对应关系
	 * @param customerIds
	 * @param positionId
	 */
	public void addRelotaionForPositionId(String customerIds, String positionId);

	/**
	 *批量替换职位与客户对应关系
	 * @param relationIds
	 * @param positionId
	 */
	public void updatePostCustomerRelation(String relationIds, String positionId);

	/**
	 * 批量解除 职位与经销商对应关系
	 * @param ids
	 */
	public void deleteRelotaionForCustomerId(String ids);
}
