package com.biz.eisp.mdm.customer.service;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
	
/** 
 * 客户扩展接口定义.
 * <p>
 * 客户保存或者编辑的扩展,如需扩展则需要实现该接口.
 * @author grover
 * @version v1.0
 */
public interface TmCustomerExtendService extends BaseService{
	/**
	 * 验证保存数据.
	 * @author 
	 * 			 grover
	 * @param vo
	 *			 vo对象值
	 * @param page 
	 * 			 页面对象
	 * @return 验证失败throw new BusinessException("失败内容")
	 */
	 void validate(TmCustomerVo vo, Page page);

	/**
	 * 保存客户信息前操作(并且没有做vo到Entity的转换操作).
	 * <p>
	 * 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做vo转换到Entity的操作。
	 * @author 
	 * 			grover
	 * @param vo
	 *			vo对象值
	 * @param page
	 *          页面对象
	 * @return 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做vo转换到Entity的操作。
	 */
	 TmCustomerEntity saveBefore(TmCustomerVo vo, Page page);

	/**
	 * 保存客户信息前操作（已经做了vo到Entity的转换操作）.
	 * @author 
	 * 			grover
	 * @param entity
	 *          vo转换成Entity的值，该Entity，如果是新增操作即为游离态，修改操作即为持久态
	 * @param vo
	 *          vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，系统即保存返回的Entity。
	 */
	 TmCustomerEntity saveBefore(TmCustomerEntity entity, TmCustomerVo vo, Page page);

	/**
	 * 保存客户后操作.
	 * <p>
	 * @author grover
	 * @param entity
	 *            保存后的Entity对象，该Entity状态为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，后面的其他操作，都会使用该Entity
	 */
	 TmCustomerEntity savePost(TmCustomerEntity entity, TmCustomerVo vo, Page page);
}
