package com.biz.eisp.mdm.customer.service;


import com.biz.eisp.mdm.customer.vo.TmCustomerVo;

import java.util.List;

/**
 * 客户主界面查询扩展
 * @author Sean
 * @version v1.0
 */
public interface TmCustomerSearchExtendService {

	/**
	 * 构建查询sql 完全自定义
	 * @param tmcustomerVo
	 * @return
	 */
	public String buildSearchSql(TmCustomerVo tmcustomerVo);

	/**
	 * 扩展查询sql，基于客户表动态字段查询的扩展
	 * 推荐返回以下方法
	 * return
	 * DynamicConfigUtil.getInstance().appendCustomCondition(String sql,String joinSql,String sqlOn,String sqlWhere,String orderSql)
	 * @param tmcustomerVo 包含查询条件的vo
	 * @param mainSql 基础查询
	 * @return
	 */
	public String extendSearchSql(TmCustomerVo tmcustomerVo,String mainSql);

	/**
	 * 查询结束后处理数据
	 */
    List<TmCustomerVo> afterSearch(List<TmCustomerVo> result);
}
