package com.biz.eisp.mdm.customer.service;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.customer.vo.QueryTmCustomerVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;

import java.util.List;
	
/** 
 * 经销商管理service接口
 * @author 肖胜
 * @version v1.0
 */
public interface TmCustomerService extends BaseService{

	/**
	 * 保存经销商信息
	 * @param customerVo 经销商Vo实体
	 * @param page 页面对象
	 */
	public String saveTmCustomer(TmCustomerVo customerVo, Page page);
	
	/**
	 * 删除经销商信息
	 * @param ids 经销商Vo实体
	 *  @param page
	 */
	public AjaxJson deleteTmCustomer(String ids,Page page);
	
	/**
	 * 查询经销商信息
	 * @param customerVo 经销商Vo实体
	 * @return TmCustomerVo集合
	 */
	public List<TmCustomerVo> findTmCustomerList(TmCustomerVo customerVo, Page page);

	/**
	 * 通过职位查询经销商信息.
	 * @param customerVo 经销商Vo实体
	 * @return TmCustomerVo集合
	 */
	public List<TmCustomerVo> findTmCustomerByPosList(TmCustomerVo customerVo, Page page);
	
	/**
	 * 根据id查询经销商信息
	 * @param customerVo
	 * @return
	 */
	public TmCustomerVo getTmCustomerVoById(TmCustomerVo customerVo, Page page);
	
	/**
	 * 客户相关接口 - 主要对外.
	 * <p>该接口提供了所有可能查询客户的方式.<br>
	 * 0、无参数 customerName客户名称，customerCode客户编码 模糊查询
	 * 1、当前客户信息 所需参数：id客户id
	 * 2、某一类型的客户信息 所需参数：customerType客户类型
	 * 3、组织直管的客户信息 所需参数：orgId组织id 或者 orgName组织名称
	 * 4、组织及组织下的客户信息 所需参数：levelAllOrgId组织id
	 * 5、职位直管的客户信息 所需参数：positionId职位id 或者 positionName职位名称
	 * 6、职位及其下级职位的客户信息 所需参数：levelAllPositionId职位id
	 * 7、某种客户状态的客户信息 所需参数：cooperative客户状态
	 * 8、经销商用户的客户信息 所需参数：userId用户id 或者 fullName用户名称
	 * 9、终端所属客户信息 所需参数：terminalId终端id
	 * @author grover
	 * @param queryTmCustomerVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 客户vo集合
	 */
	List<TmCustomerVo> findTmCustTomerByAllPossible(QueryTmCustomerVo queryTmCustomerVo, Page page);
	/**
	 * 根据组织及其下级组织和客户类型集合获取客户.
	 * @author grover
	 * 
	 * @param queryTmCustomerVo
	 * 			查询vo
	 * @param page
	 * 			页面对象
	 * @return
	 */
	List<TmCustomerVo> findTmCustTomerByOrgAndCustType(QueryTmCustomerVo queryTmCustomerVo, Page page);
	
	/**
	 * TPM查询客户数据库.
	 * @param customerVo 经销商Vo实体
	 * @return TmCustomerVo集合
	 */
	public List<TmCustomerVo> findTpmCustomerList(TmCustomerVo customerVo, Page page);
	
	/**
	 * 客户信息日志查询
	 * @param tmLogVo
	 * @param page
	 * @return
	 */
	public List<TmLogVo> findCustomerLogList(TmLogVo tmLogVo, Page page);
	/**
	 * 根据职位获取获取客户combobox.
	 * @author grover
	 * 
	 * @param positionId
	 * 		职位id.
	 * 
	 * @return
	 */
	public List<ComboBox> findCustomerComboBoxByPosId(String positionId);
	/**
	 * 根据查找 以下条件的经销商
	 * @author xuduan
	 * @param settlementCode 结算类型
	 * @param customerType 经销商类型
	 * @param contractCode 合同类型
	 * @return
	 */
	public List<TmCustomerVo> findCustomer(String settlementCode,String customerType,String contractCode,String orgId);
	
	public TmCustomerVo findSapCustomer(String code);

	/**
	 * 根据组织查询经销商信息数据
	 * @param customerVo
	 * @param page
	 * @return
	 */
	public List<TmCustomerVo> findTmCustomerListByOrgMain(TmCustomerVo customerVo, Page page);

	/**
	 * 调整组织和客户的关系接口.
	 * @author grover
	 * @param tmOrgVo 组织vo对象
	 * @return 成功或者失败
	 */
	AjaxJson changeCustomerForOrg(TmOrgVo tmOrgVo);
}
