package com.biz.eisp.mdm.customer.service.impl;

import java.util.List;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.mdm.customer.dao.TmRCustPosBgDetailDao;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.customer.dao.TmCustomerDao;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity;
import com.biz.eisp.mdm.customer.service.TmCustPostService;
import com.biz.eisp.mdm.customer.vo.TmCustPostVo;

/** 
 * 经销商岗位对应关系service实现
 * @author 肖胜
 * @version v1.0
 */
@Service("tmCustPostService")
@Transactional
public class TmCustPostServiceImpl extends BaseServiceImpl implements TmCustPostService {

	@Autowired
	private TmCustomerDao tmCustomerDao;

	@Autowired
	private TmRCustPosBgDetailDao tmRCustPosBgDetailDao;

	@Override
	public void deleteTmCustPost(TmCustPostVo custPostVo) {
		if(StringUtil.isEmpty(custPostVo.getId())){
			throw new BusinessException("删除经销商岗位对应关系信息时，主键ID为空");
		}
		TmRCustPosBGEntity tmCustPost=this.get(TmRCustPosBGEntity.class, custPostVo.getId());
		this.delete(tmCustPost);
	}

	@Override
	public List<TmCustPostVo> findTmCustPostList(TmCustPostVo custPostVo) {
		return tmCustomerDao.findTmCustPostDetailList(custPostVo);
	}
	

	@Override
	public List<TmCustPostVo> findPostList(TmCustPostVo customerVo, Page page) {
		return tmCustomerDao.findTmCustPostList(customerVo, page);
	}

	@Override
	public List<TmCustomerVo> findNotAnyPostCustomerList(TmCustPostVo tmCustPostVo, Page page) {
		return tmRCustPosBgDetailDao.findNotAnyPostCustomerList(tmCustPostVo, page);
	}

	@Override
	public List<TmCustomerVo> findNotCurrPostCustomerList(TmCustPostVo tmCustPostVo, Page page) {
		return tmRCustPosBgDetailDao.findNotCurrPostCustomerList(tmCustPostVo, page);
	}

	@Override
	public void addRelotaionForPositionId(String customerIds, String positionId) {
		if(StringUtil.isEmpty(customerIds)&&StringUtil.isEmpty(positionId)){
			throw new BusinessException("参数错误");
		}

		String[] ids=customerIds.split(",");
		TmPositionEntity tmPositionEntity=this.get(TmPositionEntity.class,positionId);
		TmCustomerEntity tmCustomerEntity=null;
		String hql="from TmRCustPosBGEntity where tmCustomer.id=? and tmPosition.id=?";
		for(String customerId:ids){
			tmCustomerEntity=this.get(TmCustomerEntity.class,customerId);
			//校验是否重复
			List<TmRCustPosBGEntity> tmRTermCustPosBGEntities=this.findByHql(hql,positionId,customerId);
			if(CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)){
				continue;
			}
			//保存
			TmRCustPosBGEntity tmRCustPosBGEntity=new TmRCustPosBGEntity();
			tmRCustPosBGEntity.setTmCustomer(tmCustomerEntity);
			tmRCustPosBGEntity.setTmPosition(tmPositionEntity);
			tmRCustPosBGEntity.setBusinessGroup(tmPositionEntity.getBusinessGroup());
			this.save(tmRCustPosBGEntity);

			//保存日志
			String content="客户对接人职位批量调整,关联对接人职位:<b>"+tmPositionEntity.getPositionName()+"</b>";
			this.addLog(OperationType.INSERT,"终端与客户对应关系",customerId,content);
		}
	}

	@Override
	public void updatePostCustomerRelation(String relationIds, String positionId) {
		if(StringUtil.isEmpty(relationIds)&&StringUtil.isEmpty(positionId)){
			throw new BusinessException("参数错误");
		}
		String[] ids=relationIds.split(",");
		TmPositionEntity tmPositionEntity=this.get(TmPositionEntity.class,positionId);
		TmRCustPosBGEntity tmRCustPosBGEntity=null;
		String hql="from TmRCustPosBGEntity where tmCustomer.id=? and tmPosition.id=?";
		for(String id:ids){
			tmRCustPosBGEntity=this.get(TmRCustPosBGEntity.class,id);
			//校验是否重复
			List<TmRCustPosBGEntity> tmRTermCustPosBGEntities=this.findByHql(hql,tmRCustPosBGEntity.getTmCustomer().getId(),positionId);
			if(CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)){
				continue;
			}
			//保存日志
			String content="客户对接人职位替换,原对接人职位:<b>"+tmRCustPosBGEntity.getTmPosition().getPositionName()
					+"</b>替换为<b>"+tmPositionEntity.getPositionName()+"<b>";
			this.addLog(OperationType.UPDATE,"终端与职位对应关系",tmRCustPosBGEntity.getTmCustomer().getId(),content);

			//更新
			tmRCustPosBGEntity.setTmPosition(tmPositionEntity);
			this.updateEntity(tmRCustPosBGEntity);
		}
	}

	@Override
	public void deleteRelotaionForCustomerId(String ids) {
		if(StringUtil.isEmpty(ids)){
			throw new BusinessException("参数错误");
		}

		String[] idArray=ids.split(",");
		for(String id:idArray){
			TmRCustPosBGEntity tmRCustPosBGEntity=this.get(TmRCustPosBGEntity.class,id);

			String content="客户对接人职位批量调整,取消关联对接人职位:<b>"+tmRCustPosBGEntity.getTmPosition().getPositionName()+"</b>";//保存日志
			//执行删除
			this.delete(tmRCustPosBGEntity);

			this.addLog(OperationType.DELETE,"终端与客户对应关系",tmRCustPosBGEntity.getTmCustomer().getId(),content);
		}
	}

}
