package com.biz.eisp.mdm.customer.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.customer.service.TmCustomerBackExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;

/**
 * 客户信息excel导入 
 * @author 肖胜
 * @version v1.0
 */
public class TmCustomerEventHandler extends ImpEventHandler <TmCustomerVo>{
	
	private TmCustomerService customerService = null;

	private TmCustomerBackExtendService tmCustomerBackExtendService;

	private List<String> saveIdList;
	
	public TmCustomerEventHandler() {
		customerService =(TmCustomerService) ApplicationContextUtils
				.getContext().getBean("tmCustomerService");

		String[] beanNamesForBackExtendService = ApplicationContextUtils.getContext().getBeanNamesForType(TmCustomerBackExtendService.class);
		if (beanNamesForBackExtendService.length > 0){
			tmCustomerBackExtendService = ApplicationContextUtils.getContext().getBean(beanNamesForBackExtendService[0],TmCustomerBackExtendService.class);
		}

		saveIdList = Collections.synchronizedList(new ArrayList<>());
	}
	
	@Override
	public void endRow(Map<String, Object> row, TmCustomerVo bean) throws ValidateException {
		try {
			//执行保存
			Page page = new EuPage();
			String id = customerService.saveTmCustomer(bean, page);
			saveIdList.add(id);
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行:"+e.getMessage());
			e.printStackTrace();	
		}
		//设置已成功导入条数
		setSuccNum(getSuccNum()+1);
	}

	@Override
	public void impEnd() {
		if (null != tmCustomerBackExtendService){
			tmCustomerBackExtendService.afterImportTmCustomer(saveIdList);
		}
	}
}
