package com.biz.eisp.mdm.customer.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.dao.TmCustomerDao;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBgDetailEntity;
import com.biz.eisp.mdm.customer.service.*;
import com.biz.eisp.mdm.customer.transformer.TmCustomerVoToTmCustomerEntity;
import com.biz.eisp.mdm.customer.util.CustomerLogMsgUtil;
import com.biz.eisp.mdm.customer.vo.QueryTmCustomerVo;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/** 
 * 客户管理service实现
 * 
 * @author 肖胜
 * @version v1.0
 */
@Service("tmCustomerService")
@Transactional
public class TmCustomerServiceImpl extends BaseServiceImpl implements TmCustomerService {
	/**
	 * 注入dao.
	 */
	@Autowired
	private TmCustomerDao tmCustomerDao;
	@Autowired
	private TmRCustPosBgDetailService tmRCustPosBgDetailService;

	@Autowired(required = false)
	private TmCustomerSearchExtendService tmCustomerSearchExtendService;
	/**
	 * 注入客户保存扩展.
	 */
	@Autowired(required = false)
	private TmCustomerExtendService tmCustomerExtendService;

	/**
	 * 注入客户删除扩展.
	 */
	@Autowired(required = false)
	private TmCustomerDelExtendService tmCustomerDelExtendService;

	@Override
	public List<TmCustomerVo> findTmCustomerList(TmCustomerVo customerVo, Page page) {
		String sql ="";
		if(tmCustomerSearchExtendService!=null){
			sql=tmCustomerSearchExtendService.buildSearchSql(customerVo);
			if(StringUtil.isEmpty(sql)){
				sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
				sql=tmCustomerSearchExtendService.extendSearchSql(customerVo,sql);
			}
			List<TmCustomerVo> result = tmCustomerDao.findTmCustomerList(customerVo, page, sql);
			return tmCustomerSearchExtendService.afterSearch(result);
		}else{
			sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, customerVo);
			return tmCustomerDao.findTmCustomerList(customerVo, page, sql);
		}
	}

	@Override
	public String saveTmCustomer(TmCustomerVo customerVo, Page page) {
		List <TmBusinessGroupVo> addBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>(); //初始化新增业务组信息
		List <TmBusinessGroupVo> deleteBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>(); //初始化要删除的业务组信息
		
		// 保存客户信息
		TmCustomerEntity tmCustomerEntity = null;
		String customerId = "";
		// 保存前扩展 此时entity还未通过vo转换
		if (StringUtil.isNotEmpty(tmCustomerExtendService)) {
			// 验证
			try {
				tmCustomerExtendService.validate(customerVo, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:" + e.getMessage());
			}
			// 扩展
			tmCustomerEntity = tmCustomerExtendService.saveBefore(customerVo, page);
		}
		// 如果entity为null 则通过vo转换
		if (StringUtil.isEmpty(tmCustomerEntity)) {
			tmCustomerEntity = new TmCustomerVoToTmCustomerEntity(this, tmRCustPosBgDetailService, 
					addBusinessGroupVoList, deleteBusinessGroupVoList).apply(customerVo);
			customerId = tmCustomerEntity.getId();
		}
		// 保存前扩展 此时entity已经通过vo转换
		if (StringUtil.isNotEmpty(tmCustomerExtendService)) {
			tmCustomerEntity = tmCustomerExtendService.saveBefore(tmCustomerEntity, customerVo, page);
		}
		// 保存
		this.saveOrUpdate(tmCustomerEntity);

		// 停止合作
		if (StringUtil.isNotEmpty(tmCustomerEntity.getCooperative()) &&
				tmCustomerEntity.getCooperative().equals("end")) {
			this.disableCustomerUser(tmCustomerEntity.getId());
		}

		// 删除无用职位与角色关系
		executeSql("DELETE FROM TM_R_CUST_POS_BG WHERE CUSTOMER_ID IS NULL");
		
		this.getSession().flush();
		
		//保存业务组信息
		this.saveBusinessGroupInfo(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
		
		// 保存后扩展
		if (StringUtil.isNotEmpty(tmCustomerExtendService)) {
			tmCustomerEntity = tmCustomerExtendService.savePost(tmCustomerEntity, customerVo, page);
		}

		if (null != tmCustomerEntity){
			return tmCustomerEntity.getId();
		}
		return null;
	}

	/**
	 * 保存业务组信息.
	 * <p>
	 * @param addBusinessGroupVoList //要新增的业务信息
	 * @param deleteBusinessGroupVoList //要删除的业务信息
	 */
	private void saveBusinessGroupInfo(TmCustomerEntity tmCustomerEntity, List <TmBusinessGroupVo> addBusinessGroupVoList,
				List <TmBusinessGroupVo> deleteBusinessGroupVoList) {
		//删除原来的关系数据
		if(CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
			Map <String, String> map = new HashMap<String, String>();
			for(TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
				map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
			}
			
			String deleteSql = "delete from tm_r_cust_pos_bg_detail where business_group = ?";
			
			Set <String> keyset = map.keySet();
			for(Iterator <String>iter = keyset.iterator(); iter.hasNext();) {
				String key = iter.next();
				this.executeSql(deleteSql, key);
			}
		}
		
		this.getSession().flush();
		
		//保存新的关系数据
		if(CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
			for(TmBusinessGroupVo vo : addBusinessGroupVoList) {
				if(vo.getTypeCode() != "orgCode" && vo.getTypeCode() != "positionCode") {
					TmRCustPosBgDetailEntity entity = new TmRCustPosBgDetailEntity();
					entity.setBusinessGroup(vo.getBusinessGroup());
					entity.setDetailCode(vo.getDetailCode());
					entity.setDetailName(vo.getDetailName());
					entity.setTypeCode(vo.getTypeCode());
					entity.setTypeName(vo.getTypeName());
					this.save(entity);
				}
			}
		}
		
		this.getSession().flush();
		
		this.saveBusinessGroupLog(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
	}
	
	/**
	 * 保存业务组日志信息.
	 * <p>
	 * @param newBusinessGroupVoList
	 * @param oldBusinessGroupVoList
	 */
	private void saveBusinessGroupLog(TmCustomerEntity tmCustomerEntity, List <TmBusinessGroupVo> newBusinessGroupVoList,
			List <TmBusinessGroupVo> oldBusinessGroupVoList) {
		Map <String, List <TmBusinessGroupVo>> oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
		Map <String, List <TmBusinessGroupVo>> newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);
		
		Set <String>oldKeySet= oldMap.keySet();
		
		String updateMsg = "";
		String deleteMsg = "";
		String addMsg = "";
		
		for(Iterator <String>iter = oldKeySet.iterator(); iter.hasNext();) {
			String oldKey = iter.next();
			if(newMap.containsKey(oldKey)) { //修改的情况
				updateMsg += CustomerLogMsgUtil.buildUpdateMsg(newMap.get(oldKey), oldMap.get(oldKey)) + "<hr>";
				newMap.remove(oldKey);
			} else { //删除的情况
				deleteMsg += CustomerLogMsgUtil.buildDeleteMsg(oldMap.get(oldKey)) + "<hr>";
			}
		}
		addMsg += this.buildAddMsg(tmCustomerEntity, newMap);
		
		if(StringUtils.isNotBlank(addMsg)) {
			this.addLog(OperationType.INSERT, "业务组关系", tmCustomerEntity.getId(), addMsg);
		} 
		if(StringUtils.isNotBlank(deleteMsg)) {
			this.addLog(OperationType.DELETE, "业务组关系", tmCustomerEntity.getId(), deleteMsg);
		}
		if(StringUtils.isNotBlank(updateMsg)) {
			this.addLog(OperationType.UPDATE, "业务组关系", tmCustomerEntity.getId(), updateMsg);
		}
	}
	
	/**
	 * 按照businessgroup汇总数据到Map上.
	 * <p>
	 * @param voList
	 * @return
	 */
	private Map<String , List<TmBusinessGroupVo>> buildMapByBusinessGroup(List <TmBusinessGroupVo> voList) {
		Map <String , List<TmBusinessGroupVo>> map = new HashMap<String , List<TmBusinessGroupVo>>();
		if(CollectionUtil.listNotEmptyNotSizeZero(voList)) {
			for(TmBusinessGroupVo oldBusinessGroupVo : voList) {
				if(map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
					map.get(oldBusinessGroupVo.getBusinessGroup()).add(oldBusinessGroupVo);
				} else {
					List <TmBusinessGroupVo> list = new ArrayList <TmBusinessGroupVo>();
					list.add(oldBusinessGroupVo);
					map.put(oldBusinessGroupVo.getBusinessGroup(), list);
				}
			}
		}
		return map;
	}
	
	/**
	 * 构造新增日志信息.
	 * <p>
	 * @param tmCustomerEntity
	 * @param newMap
	 * @return
	 */
	private String buildAddMsg(TmCustomerEntity tmCustomerEntity, Map <String, List <TmBusinessGroupVo>> newMap) {
		Set <String> keySet = newMap.keySet();
		String msg = "";
		for(Iterator <String>iter = keySet.iterator(); iter.hasNext();) {
			String key = iter.next();
		    msg += CustomerLogMsgUtil.buildAddMsg(newMap.get(key));
		    msg += "<hr>";
		}
		return msg;
	}
	
	/**
	 * 注销经销商用户.
	 * <p>
	 * 
	 * @param customerId
	 */
	private void disableCustomerUser(String customerId) {
		String sql = "UPDATE tm_user SET enable_status = 1 WHERE ID in (SELECT user_id FROM tm_r_user_customer WHERE customer_id = ?)";
		this.executeSql(sql, customerId);
	}

	@Override
	public AjaxJson deleteTmCustomer(String ids,Page page) {
		AjaxJson json = new AjaxJson();
		Map<String,Object> attributes = new HashMap<>();
		if (StringUtil.isNotEmpty(ids)) {
			List<String> customerCodeList = new ArrayList<>();
			String[] customerIds = ids.split(",");
			for (String customerId : customerIds) {
				TmCustomerEntity tmCustomerEntity = this.get(TmCustomerEntity.class, customerId);
				//删除前
				if(tmCustomerDelExtendService!=null){
					//删除前验证
					tmCustomerDelExtendService.validate(tmCustomerEntity,page);
					tmCustomerDelExtendService.delBefore(tmCustomerEntity,page);
				}

				if (tmCustomerEntity != null && StringUtil.isNotEmpty(tmCustomerEntity.getId())) {
					customerCodeList.add(tmCustomerEntity.getCustomerCode());
					delete(tmCustomerEntity);
					//删除后
					if(tmCustomerDelExtendService!=null){
						tmCustomerDelExtendService.delPost(tmCustomerEntity,page);
					}
				}
			}
			attributes.put("customerCodeList",customerCodeList);
		}
		json.setAttributes(attributes);
		return json;
	}

	@Override
	public TmCustomerVo getTmCustomerVoById(TmCustomerVo customerVo, Page page) {
		List<TmCustomerVo> list = this.findTmCustomerList(customerVo, null);
		return list.size() > 0 ? list.get(0) : new TmCustomerVo();
	}

	@Override
	public List<TmCustomerVo> findTmCustomerByPosList(TmCustomerVo customerVo, Page page) {
		return tmCustomerDao.findTmCustomerByPosList(customerVo, page);
	}

	@Override
	public List<TmCustomerVo> findTmCustTomerByAllPossible(QueryTmCustomerVo queryTmCustomerVo, Page page) {
		return tmCustomerDao.findTmCustTomerByAllPossible(queryTmCustomerVo, page);
	}

	public List<TmCustomerVo> findTpmCustomerList(TmCustomerVo customerVo, Page page) {
		return tmCustomerDao.findTpmCustomerList(customerVo, page);
	}

	@Override
	public List<TmLogVo> findCustomerLogList(TmLogVo tmLogVo, Page page) {
		return tmCustomerDao.findCustomerLogList(tmLogVo, page);
	}

	@Override
	public List<TmCustomerVo> findTmCustTomerByOrgAndCustType(QueryTmCustomerVo queryTmCustomerVo, Page page) {
		return tmCustomerDao.findTmCustTomerByOrgAndCustType(queryTmCustomerVo, page);
	}

	@Override
	public List<ComboBox> findCustomerComboBoxByPosId(String positionId) {
		String sql = "SELECT DISTINCT TC.ID AS ID,TC.CUSTOMER_NAME AS TEXT,TC.CUSTOMER_CODE AS VALUE"
				+ " FROM TM_CUSTOMER TC JOIN TM_R_CUST_POS_BG TRCP"
				+ " ON TC.ID = TRCP.CUSTOMER_ID WHERE TRCP.POSITION_ID=?";
		return findBySql(ComboBox.class, sql, positionId);
	}
	/**
	 * 根据查找 以下条件的经销商
	 * @author xuduan
	 * @param settlementCode 结算类型
	 * @param customerType 经销商类型
	 * @param contractCode 合同类型
	 * @return
	 */
	public List<TmCustomerVo> findCustomer(String settlementCode,String customerType,String contractCode,String orgId){
		return tmCustomerDao.findCustomer(settlementCode, customerType, contractCode,orgId);
	}
	
	public TmCustomerVo findSapCustomer(String code){
		List<TmCustomerVo> customerVoList = tmCustomerDao.findSapCustomer(code);
		return customerVoList!=null&&customerVoList.size()>0?customerVoList.get(0):new TmCustomerVo();
	}

	@Override
	public List<TmCustomerVo> findTmCustomerListByOrgMain(TmCustomerVo customerVo, Page page) {
		List<TmCustomerVo> voList = tmCustomerDao.findTmCustomerListByOrgMain(customerVo, page);
		return voList;
	}

	@Override
	public AjaxJson changeCustomerForOrg(TmOrgVo tmOrgVo) {
		AjaxJson j = new AjaxJson();
		if(StringUtil.isNotEmpty(tmOrgVo.getCustomerIds())){
			TmCustomerEntity tmCustomerEntity = null;
			TmOrgEntity tmOrgEntity = null;
			String[] customerIds = tmOrgVo.getCustomerIds().split(",");
			for (String posId : customerIds) {
				tmCustomerEntity = get(TmCustomerEntity.class, posId);
				if(StringUtil.isNotEmpty(tmCustomerEntity)){
					tmOrgEntity = this.get(TmOrgEntity.class, tmOrgVo.getOrgId());
					tmCustomerEntity.setTmOrg(tmOrgEntity);
					saveOrUpdate(tmCustomerEntity);
				}
			}
			j.setMsg("调整关系成功");
		}else{
			j.setSuccess(false);
			j.setMsg("缺少必要的参数");
		}
		return j;
	}
}
