package com.biz.eisp.mdm.customer.transformer;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBgDetailEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.service.TmRCustPosBgDetailService;
import com.biz.eisp.mdm.customer.util.ValidateUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.google.common.base.Function;

/** 
 * 客户Vo转Vo
 * @author 肖胜
 * @version v1.0
 */
public class TmCustomerVoToTmCustomerEntity implements Function<TmCustomerVo,TmCustomerEntity>{

	private TmCustomerService tmCustomerService;
	private TmRCustPosBgDetailService tmRCustPosBgDetailService;
	private List <TmBusinessGroupVo> addBusinessGroupVoList;
	private List <TmBusinessGroupVo> deleteBusinessGroupVoList;
	
	//编码生成
	private TbNumRuleProvider tbNumRuleProvider = null;
	private String [] channelCodes; //渠道编码
	private String [] orgIds; //组织id
	private String [] productCodes; //产品编码
	private String [] businessAreaCodes; //业务区域编码
	private String [] bgExtChar1s;
	private String [] bgExtChar2s;

	//构造方法加载TmCustomerService
	public TmCustomerVoToTmCustomerEntity(TmCustomerService tmCustomerService, TmRCustPosBgDetailService tmRCustPosBgDetailService,
			List <TmBusinessGroupVo> addBusinessGroupVoList, List <TmBusinessGroupVo> deleteBusinessGroupVoList) {
		super();
		this.tmCustomerService = tmCustomerService;
		this.tmRCustPosBgDetailService = tmRCustPosBgDetailService;
		tbNumRuleProvider = (TbNumRuleProvider) ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
		this.addBusinessGroupVoList = addBusinessGroupVoList;
		this.deleteBusinessGroupVoList = deleteBusinessGroupVoList;
	}

	@Override
	@SuppressWarnings("deprecation")
	public TmCustomerEntity apply(TmCustomerVo input) {
		TmCustomerEntity tmCustomerEntity=null;
		if(StringUtil.isNotEmpty(input.getId())){
			tmCustomerEntity=tmCustomerService.get(TmCustomerEntity.class, input.getId());
		}else{
			//验证非空
			if(StringUtil.isEmpty(input.getCustomerName())){
				throw new BusinessException("客户名称为空" );
			}
			//防止重复数据 当名称与地址相同时覆盖
			List<TmCustomerEntity> list=tmCustomerService.
					findByHql("from TmCustomerEntity where customerName=? ", 
							input.getCustomerName());
			if(list!=null&&list.size()>0){
				throw new BusinessException("客户名称" + input.getCustomerName()+"已存在");
			}
			
			tmCustomerEntity=new TmCustomerEntity();
			
			String customerCode=tbNumRuleProvider.getMaxNum(Globals.AuthCust);
			tmCustomerEntity.setCustomerCode(customerCode);
			input.setCustomerCode(customerCode);
			tmCustomerEntity.setEnableStatus(Globals.ENABLED);
		}
		
		//验证客户名称的有效性
		if(ValidateUtil.validateName(input.getCustomerName(),ValidateUtil.NAME)){
			throw new BusinessException("检测到客户名称["+ input.getCustomerName()+"]包含非法字符");
		}
		
		//验证客户名称的有效性
		if(StringUtil.isNotEmpty(input.getErpCode())){
			if(!ValidateUtil.validateName(input.getErpCode(),ValidateUtil.ERPCODE)){
				throw new BusinessException("检测到客户ERP编码包含非法字符:" + input.getErpCode()+"，只能为数字和字母");
			}
		}
		
		//属性copy 无法设置空值
		try {
//			MyBeanUtils.copyBeanNotNull2Bean(input,tmCustomerEntity);
			copyProperties(input, tmCustomerEntity);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		//设置所属部门
		if(StringUtil.isNotEmpty(input.getOrgId())){
			
			TmOrgEntity tmOrg=null;
			if(StringUtil.isNotEmpty(input.getOrgId())){
				 tmOrg=tmCustomerService.get(TmOrgEntity.class, input.getOrgId());
			}
			
			if(tmOrg == null) {
				String org=StringUtil.isNotEmpty(input.getOrgId())?input.getOrgId():input.getOrgName();
				throw new BusinessException("所属组织信息["+org+"]不存在" );
			}
			tmCustomerEntity.setTmOrg(tmOrg);
		}
		
		//设置客户组织
		if(StringUtil.isNotEmpty(input.getCustomerOrgId())){
			
			TmCustomerOrgEntity customerOrg=null;
			if(StringUtil.isNotEmpty(input.getCustomerOrgId())){
				 customerOrg=tmCustomerService.get(TmCustomerOrgEntity.class, input.getCustomerOrgId());
			}
			
			if(customerOrg == null) {
				String custOrg=StringUtil.isNotEmpty(input.getCustomerOrgId())
						?input.getCustomerOrgId():input.getCustomerOrgName();
				throw new BusinessException("客户组织信息["+custOrg+"]不存在" );
			}
			tmCustomerEntity.setTmCustomerOrg(customerOrg);
		}
		
		//装载对接人职位列表信息
		tmCustomerEntity.setTmRCustPosBGList(this.getTmRCustPosBGList(tmCustomerEntity, input));
		return tmCustomerEntity;
	}

	/**
	 * 初始化业务组列表对象.
	 * 查询原来所有的业务对象，添加到要删除的列表中
	 * <p>
	 * @param custPostList
	 */
	private void initBusinessGroupInfo(List<TmRCustPosBGEntity> custPostList) {
		if(CollectionUtil.listNotEmptyNotSizeZero(custPostList)) {
			for(TmRCustPosBGEntity entity : custPostList) {
				List <TmRCustPosBgDetailEntity> detailEntityList = tmCustomerService
						.findByProperty(TmRCustPosBgDetailEntity.class, "businessGroup", entity.getBusinessGroup());
				for(TmRCustPosBgDetailEntity detailEntity : detailEntityList) {
					TmBusinessGroupVo businessGroupVo = new TmBusinessGroupVo();
					businessGroupVo.setBusinessGroup(detailEntity.getBusinessGroup());
					businessGroupVo.setDetailCode(detailEntity.getDetailCode());
					businessGroupVo.setDetailName(detailEntity.getDetailName());
					businessGroupVo.setTypeCode(detailEntity.getTypeCode());
					businessGroupVo.setTypeName(detailEntity.getTypeName());
					businessGroupVo.setPositionId(entity.getTmPosition() == null ? "" : entity.getTmPosition().getId());
					businessGroupVo.setOrgId(entity.getOrgId());
					deleteBusinessGroupVoList.add(businessGroupVo);
				}
			}
		}
	}
	
	/**
	 * 初始化业务Vo对象信息.
	 * <p>
	 * @param input
	 */
	private void initBusinessGroupVoInfo(TmCustomerVo input) {
		channelCodes = StringUtils.isNotBlank(input.getChannelCode()) ? input.getChannelCode().split(",", -1) : null;
		orgIds = StringUtils.isNotBlank(input.getBusinessGroupOrgId()) ? input.getBusinessGroupOrgId().split(",", -1) : null;
		productCodes = StringUtils.isNotBlank(input.getProductCode()) ? input.getProductCode().split(",", -1) : null;
		businessAreaCodes = StringUtils.isNotBlank(input.getBusinessAreaCode()) ? input.getBusinessAreaCode().split(",", -1) : null;
		bgExtChar1s = StringUtils.isNotBlank(input.getBgExtChar1s()) ? input.getBgExtChar1s().split(",") : null;
		bgExtChar2s = StringUtils.isNotBlank(input.getBgExtChar2s()) ? input.getBgExtChar2s().split(",") : null;
	}
	
	/**
	 * 拼接对接人职位信息列表 
	 * @param customerEntity
	 * @param input
	 * @return
	 */
	public List<TmRCustPosBGEntity> getTmRCustPosBGList(TmCustomerEntity customerEntity,TmCustomerVo input) {
		List<TmRCustPosBGEntity> custPostList=new ArrayList<TmRCustPosBGEntity>();
		
		initBusinessGroupInfo(customerEntity.getTmRCustPosBGList());
		
		String relationIndex=input.getRelationIndex();
		//职位编码
		String positionIds=input.getPositionIds();
		String[] indexs={};
		if(StringUtil.isNotEmpty(relationIndex)){
			 indexs=relationIndex.split(",");
		}else{
			 if(StringUtil.isNotEmpty(positionIds)){
				 indexs=positionIds.split(",");
			 }
		}
		
		//初始化业务Vo对象信息
		initBusinessGroupVoInfo(input);
		
		String[] ids=new String[indexs.length];
		if(StringUtil.isNotEmpty(positionIds)){
			ids=positionIds.split(",");
		}
		
		//主键id
		String custPost= input.getCustPostId();
		String[] custPostIds=new String[indexs.length];
		if(StringUtil.isNotEmpty(custPost)){
			custPostIds=custPost.split(",");
		}
		
		//遍历positionIds
		for(int i=0;i<indexs.length;i++){
			TmRCustPosBGEntity tmCustPostEntity=new TmRCustPosBGEntity();
			
			String positionId="";
			
			if(ids.length>i){
				positionId=ids[i];
			}
			
			String custPostId="";
			if(custPostIds.length>i){
				custPostId=custPostIds[i];
			}
		
			//判断是否有主键id
			if(StringUtil.isNotEmpty(custPostId)){
				tmCustPostEntity=tmCustomerService.get(TmRCustPosBGEntity.class, custPostId);
				if(StringUtil.isNotEmpty(positionId)){
					TmPositionEntity positionEntity=null;
					//设置职位
					if(StringUtil.isNotEmpty(positionId)){
						positionEntity=tmCustomerService.get(TmPositionEntity.class,positionId);
						//导入时的职位为 code 
						if(positionEntity==null){
							positionEntity=tmCustomerService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionId);
						}
						if(positionEntity==null){
							throw new BusinessException("职位信息["+positionId+"]不存在" );
						}
						tmCustPostEntity.setTmPosition(positionEntity);
					}
					
					if(positionEntity != null) {
						setPositionValue(positionEntity.getId(), tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
					}
				}
				if(orgIds != null&&orgIds.length>i) {
					tmCustPostEntity.setOrgId(orgIds[i]);
					setOrgValue(orgIds[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				}
				if(bgExtChar1s != null&&bgExtChar1s.length>i) {
					tmCustPostEntity.setExtChar1(bgExtChar1s[i]);
				}
				if(bgExtChar2s != null&&bgExtChar2s.length>i) {
					tmCustPostEntity.setExtChar2(bgExtChar2s[i]);
				}
				if (StringUtil.isEmpty(tmCustPostEntity.getBusinessGroup())){
					tmCustPostEntity.setBusinessGroup(tbNumRuleProvider.getMaxNum("business_group"));
				}

				setChannelValue(channelCodes == null ? null : channelCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				setProductValue(productCodes == null ? null : productCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				setBusinessAreaValue(businessAreaCodes == null ? null : businessAreaCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				custPostList.add(tmCustPostEntity);
			}else{
				TmPositionEntity positionEntity=null;
				//设置职位
				if(StringUtil.isNotEmpty(positionId)){
					positionEntity=tmCustomerService.get(TmPositionEntity.class,positionId);
					//导入时的职位为 code 
					if(positionEntity==null){
						for(TmRCustPosBGEntity custPostEntity:custPostList){
							if(custPostEntity.getTmPosition().getPositionCode().equals(positionId)){
								throw new BusinessException("对应职位信息["+positionId+"]存在相同的多个编码" );
							}
						}
						positionEntity=tmCustomerService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionId);
					}
					if(positionEntity==null){
						throw new BusinessException("职位信息["+positionId+"]不存在" );
					}else if(positionEntity.getEnableStatus()==1){
						throw new BusinessException("职位信息["+positionId+"]已停用" );
					}
					tmCustPostEntity.setTmPosition(positionEntity);
				}
				tmCustPostEntity.setBusinessGroup(tbNumRuleProvider.getMaxNum("business_group"));
				if(positionEntity != null) {
					setPositionValue(positionEntity.getId(), tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				}
				if(orgIds != null&&orgIds.length>i) {
					tmCustPostEntity.setOrgId(orgIds[i]);
					setOrgValue(orgIds[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				}
				if(bgExtChar1s != null&&bgExtChar1s.length>i) {
					tmCustPostEntity.setExtChar1(bgExtChar1s[i]);
				}
				if(bgExtChar2s != null&&bgExtChar2s.length>i) {
					tmCustPostEntity.setExtChar2(bgExtChar2s[i]);
				}
				setChannelValue(channelCodes == null ? null : channelCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				setProductValue(productCodes == null ? null : productCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				setBusinessAreaValue(businessAreaCodes == null ? null : businessAreaCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
				tmCustPostEntity.setTmCustomer(customerEntity);
				custPostList.add(tmCustPostEntity);
			}
		}
		return custPostList;
	}

	/**
	 * 设置业务区域信息.
	 * <p>
	 * @param businessAreaCode
	 * @param businessGroup
	 */
	private void setBusinessAreaValue(String businessAreaCode, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
		if(StringUtils.isNotBlank(businessAreaCode)) {
			String detailCodeArr [] = businessAreaCode.split(";");
			
			for(String detail : detailCodeArr) {
				TmBusinessGroupVo vo = new TmBusinessGroupVo();
				vo.setBusinessGroup(businessGroup);
				vo.setDetailCode(detail);
				TmBusinessAreaEntity businessAreaEntity = tmCustomerService.findUniqueByProperty(TmBusinessAreaEntity.class, "businessAreaCode", detail);
				vo.setDetailName(businessAreaEntity.getBusinessAreaName());
				vo.setTypeCode("businessAreaCode");
				vo.setTypeName("业务区域");
				vo.setFlag("add");
				vo.setOrgId(tmCustPostEntity.getOrgId());
				vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
				addBusinessGroupVoList.add(vo);
			}
		}
	}
	
	/**
	 * 设置组织信息.
	 * <p>
	 * @param orgId
	 * @param businessGroup
	 */
	private void setOrgValue(String orgId, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
		if(StringUtils.isNotBlank(orgId)) {
			TmBusinessGroupVo vo = new TmBusinessGroupVo();
			TmOrgEntity orgEntity = tmCustomerService.get(TmOrgEntity.class, tmCustPostEntity.getOrgId());
			vo.setBusinessGroup(businessGroup);
			vo.setDetailCode("");
			vo.setDetailName(orgEntity.getOrgName());
			vo.setTypeCode("orgCode");
			vo.setTypeName("所属分部");
			vo.setFlag("add");
			vo.setOrgId(tmCustPostEntity.getOrgId());
			vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
			addBusinessGroupVoList.add(vo);
		}
	}
	
	/**
	 * 设置职位信息.
	 * <p>
	 * @param positionId
	 * @param businessGroup
	 */
	private void setPositionValue(String positionId, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
		if(StringUtils.isNotBlank(positionId)) {
			TmBusinessGroupVo vo = new TmBusinessGroupVo();
			vo.setBusinessGroup(businessGroup);
			vo.setDetailCode("");
			vo.setDetailName(tmCustPostEntity.getTmPosition().getPositionName());
			vo.setTypeCode("positionCode");
			vo.setTypeName("对接人职位");
			vo.setFlag("add");
			vo.setOrgId(tmCustPostEntity.getOrgId());
			vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
			addBusinessGroupVoList.add(vo);
		}
	}
	
	/**
	 * 设置渠道信息.
	 * <p>
	 * @param channelCode
	 * @param businessGroup
	 */
	private void setChannelValue(String channelCode, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
		if(StringUtils.isNotBlank(channelCode)) {
			String detailCodeArr [] = channelCode.split(";");
			
			for(String detail : detailCodeArr) {
				TmBusinessGroupVo vo = new TmBusinessGroupVo();
				vo.setBusinessGroup(businessGroup);
				vo.setDetailCode(detail);
				vo.setDetailName(DictUtil.getDictDataValueByCode("channel", detail));
				vo.setTypeCode("channelCode");
				vo.setTypeName("渠道");
				vo.setFlag("add");
				vo.setOrgId(tmCustPostEntity.getOrgId());
				vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
				addBusinessGroupVoList.add(vo);
			}
		}
	}
	
	/**
	 * 设置产品信息.
	 * <p>
	 * @param productCode
	 * @param businessGroup
	 */
	private void setProductValue(String productCode, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
		if(StringUtils.isNotBlank(productCode)) {
			String detailCodeArr [] = productCode.split(";");
			
			for(String detail : detailCodeArr) {
				TmBusinessGroupVo vo = new TmBusinessGroupVo();
				vo.setBusinessGroup(businessGroup);
				vo.setDetailCode(detail);
				TmProductEntity productEntity = tmCustomerService.findUniqueByProperty(TmProductEntity.class, "productCode", detail);
				vo.setDetailName(productEntity.getProductName());
				vo.setTypeCode("productCode");
				vo.setTypeName("产品");
				vo.setFlag("add");
				vo.setOrgId(tmCustPostEntity.getOrgId());
				vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
				addBusinessGroupVoList.add(vo);
			}
		}
	}
	
	private void copyProperties(TmCustomerVo vo, TmCustomerEntity entity) {
		entity.setAddress(vo.getAddress());
		entity.setArea(vo.getArea());
		entity.setChannelType(vo.getChannelType());
		entity.setCity(vo.getCity());
		entity.setCooperative(vo.getCooperative());
		entity.setCustomerCode(vo.getCustomerCode());
		entity.setCustomerName(vo.getCustomerName());
		entity.setCustomerType(vo.getCustomerType());
		if(StringUtils.isNotBlank(vo.getEnableStatus())) {
			entity.setEnableStatus(Integer.parseInt(vo.getEnableStatus()));
		}
		entity.setErpCode(vo.getErpCode());
		entity.setExtChar1(vo.getExtChar1());
		entity.setExtChar2(vo.getExtChar2());
		entity.setExtChar3(vo.getExtChar3());
		entity.setExtChar4(vo.getExtChar4());
		entity.setExtChar5(vo.getExtChar5());
		entity.setExtChar6(vo.getExtChar6());
		entity.setExtChar7(vo.getExtChar7());
		entity.setExtChar8(vo.getExtChar8());
		entity.setExtChar9(vo.getExtChar9());
		entity.setExtChar10(vo.getExtChar10());
		entity.setExtChar11(vo.getExtChar11());
		entity.setExtChar12(vo.getExtChar12());
		entity.setExtChar13(vo.getExtChar13());
		entity.setExtChar14(vo.getExtChar14());
		entity.setExtChar15(vo.getExtChar15());
		entity.setExtChar16(vo.getExtChar16());
		entity.setExtChar17(vo.getExtChar17());
		entity.setExtChar18(vo.getExtChar18());
		entity.setExtChar19(vo.getExtChar19());
		entity.setExtChar20(vo.getExtChar20());
		entity.setExtChar21(vo.getExtChar21());
		entity.setExtChar22(vo.getExtChar22());
		entity.setExtChar23(vo.getExtChar23());
		entity.setExtChar24(vo.getExtChar24());
		entity.setExtChar25(vo.getExtChar25());
		entity.setExtChar26(vo.getExtChar26());
		entity.setExtChar27(vo.getExtChar27());
		entity.setExtChar28(vo.getExtChar28());
		entity.setExtChar29(vo.getExtChar29());
		entity.setExtChar30(vo.getExtChar30());
		entity.setExtChar31(vo.getExtChar31());
		entity.setExtChar32(vo.getExtChar32());
		entity.setExtChar33(vo.getExtChar33());
		entity.setExtChar34(vo.getExtChar34());
		entity.setExtChar35(vo.getExtChar35());
		entity.setExtChar36(vo.getExtChar36());
		entity.setExtChar37(vo.getExtChar37());
		entity.setExtChar38(vo.getExtChar38());
		entity.setExtChar39(vo.getExtChar39());
		entity.setExtChar40(vo.getExtChar40());
		entity.setExtChar41(vo.getExtChar41());
		entity.setExtChar42(vo.getExtChar42());
		entity.setExtChar43(vo.getExtChar43());
		entity.setExtChar44(vo.getExtChar44());
		entity.setExtChar45(vo.getExtChar45());
		
		entity.setExtNumber1(vo.getExtNumber1());
		entity.setExtNumber2(vo.getExtNumber2());
		entity.setExtNumber3(vo.getExtNumber3());
		entity.setExtNumber4(vo.getExtNumber4());
		entity.setExtNumber5(vo.getExtNumber5());
		entity.setLinkman(vo.getLinkman());
		entity.setLinkmanPhone(vo.getLinkmanPhone());
		entity.setProvince(vo.getProvince());
	}
}
