package com.biz.eisp.mdm.customer.util;

import java.util.List;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;

/**
 * 客户日志信息工具类.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class CustomerLogMsgUtil {

	public static String buildDeleteMsg(List <TmBusinessGroupVo> voList) {
		String msg = "";
		String orgField = "字段[<b>所属部门</b>]:";
		String positionField = "字段[<b>对接人职位</b>]:";
		String channelField = "字段[<b>渠道</b>]:";
		String productField = "字段[<b>产品</b>]:";
		String businessAreaField = "字段[<b>区域</b>]:";
		if(CollectionUtil.listNotEmptyNotSizeZero(voList)) {
			for(TmBusinessGroupVo v : voList) {
				if(v.getTypeCode().equals("orgCode")) {
					orgField += v.getDetailName() + ";";
				} else if(v.getTypeCode().equals("positionCode")) {
					positionField += v.getDetailName() + ";";
				} else if(v.getTypeCode().equals("channelCode")) {
					channelField += v.getDetailName() + ";";
				} else if(v.getTypeCode().equals("productCode")) {
					productField += v.getDetailName() + ";";
				} else if(v.getTypeCode().equals("businessAreaCode")) {
					businessAreaField += v.getDetailName() + ";";
				} 
			}
		}
		msg = orgField + "<br>"
		    + positionField + "<br>"
			+ channelField + "<br>"
		    + productField + "<br>"
			+ businessAreaField;
		return msg;
	}
	
	public static String buildAddMsg(List <TmBusinessGroupVo> voList) {
		String msg = "";
		String orgField = "字段[<b>所属部门</b>]:";
		String positionField = "字段[<b>对接人职位</b>]:";
		String channelField = "字段[<b>渠道</b>]:";
		String productField = "字段[<b>产品</b>]:";
		String businessAreaField = "字段[<b>区域</b>]:";
		if(CollectionUtil.listNotEmptyNotSizeZero(voList)) {
			for(TmBusinessGroupVo v : voList) {
				if(v.getTypeCode().equals("orgCode")) {
					orgField += v.getDetailName() + ";";
				} else if(v.getTypeCode().equals("positionCode")) {
					positionField += v.getDetailName() + ";";
				} else if(v.getTypeCode().equals("channelCode")) {
					channelField += v.getDetailName() + ";";
				} else if(v.getTypeCode().equals("productCode")) {
					productField += v.getDetailName() + ";";
				} else if(v.getTypeCode().equals("businessAreaCode")) {
					businessAreaField += v.getDetailName() + ";";
				} 
			}
		}
		msg = orgField + "<br>"
		    + positionField + "<br>"
			+ channelField + "<br>"
		    + productField + "<br>"
			+ businessAreaField;
		return msg;
	}
	
	public static String buildUpdateMsg(List <TmBusinessGroupVo> newList , List <TmBusinessGroupVo> oldList) {
		String msg = "";
		String orgField = "字段[<b>所属部门</b>]:";
		String positionField = "字段[<b>对接人职位</b>]:";
		String channelField = "字段[<b>渠道</b>]:";
		String productField = "字段[<b>产品</b>]:";
		String businessAreaField = "字段[<b>区域</b>]:";
		
		String newOrg = "";
		String newPosition = "";
		String newChannel = "";
		String newProduct = "";
		String newBusinessArea = "";
		
		String oldOrg = "";
		String oldPosition = "";
		String oldChannel = "";
		String oldProduct = "";
		String oldBusinessArea = "";
		
		if(CollectionUtil.listNotEmptyNotSizeZero(newList)) {
			for(TmBusinessGroupVo newVo : newList) {
				if(newVo.getTypeCode().equals("orgCode")) {
					newOrg += newVo.getDetailName() + ";";
				} else if(newVo.getTypeCode().equals("positionCode")) {
					newPosition += newVo.getDetailName() + ";";
				} else if(newVo.getTypeCode().equals("channelCode")) {
					newChannel += newVo.getDetailName() + ";";
				} else if(newVo.getTypeCode().equals("productCode")) {
					newProduct += newVo.getDetailName() + ";";
				} else if(newVo.getTypeCode().equals("businessAreaCode")) {
					newBusinessArea += newVo.getDetailName() + ";";
				} 
			}
		}
		
		if(CollectionUtil.listNotEmptyNotSizeZero(oldList)) {
			for(TmBusinessGroupVo oldVo : oldList) {
				if(oldVo.getTypeCode().equals("orgCode")) {
					oldOrg += oldVo.getDetailName() + ";";
				} else if(oldVo.getTypeCode().equals("positionCode")) {
					oldPosition += oldVo.getDetailName() + ";";
				} else if(oldVo.getTypeCode().equals("channelCode")) {
					oldChannel += oldVo.getDetailName() + ";";
				} else if(oldVo.getTypeCode().equals("productCode")) {
					oldProduct += oldVo.getDetailName() + ";";
				} else if(oldVo.getTypeCode().equals("businessAreaCode")) {
					oldBusinessArea += oldVo.getDetailName() + ";";
				} 
			}
		}
		
		if(!newOrg.equals(oldOrg)) {
			msg += orgField + "<b>原</b>" + oldOrg + "，<b>修改为：</b>" + newOrg + "<br>";
		}  if(!newPosition.equals(oldPosition)) {
			msg += positionField + "<b>原</b>" + oldPosition + "，<b>修改为：</b>" + newPosition + "<br>";
		}  if(!newChannel.equals(oldChannel)) {
			msg += channelField + "<b>原</b>" + oldChannel + "，<b>修改为：</b>" + newChannel + "<br>";
		}  if(!newProduct.equals(oldProduct)) {
			msg += productField + "<b>原</b>" + oldProduct + "，<b>修改为：</b>" + newProduct + "<br>";
		}  if(!newBusinessArea.equals(oldBusinessArea)) {
			msg += businessAreaField + "<b>原</b>" + oldBusinessArea + "，<b>修改为：</b>" + newBusinessArea + "<br>";
		}
		
		return msg;
	}
	
}
