package com.biz.eisp.mdm.custorg.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.mdm.custorg.service.TmCustOrgBackExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgFormExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgMainExtendService;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgBusinessVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgCustomerVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgTerminalVo;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;

/** 
 * <p>客户组织关系CURD操作的Controller层<br>
 * 处理客户组织关系Controller
 * @author wuzhujun
 * @version v1.0
 */
@Controller
@RequestMapping("/tmCustOrgController")
public class TmCustOrgController  extends BaseController{
	/**
	 * 注入客户组织关系服务层
	 */
	@Autowired
	private TmCustOrgService tmCustOrgService;

	/**
	 * 客户组织表单界面扩展
	 */
	@Autowired(required = false)
	private TmCustOrgFormExtendService tmCustOrgFormExtendService;

	/**
	 * 客户组织主界面扩展
	 */
	@Autowired(required = false)
	private TmCustOrgMainExtendService tmCustOrgMainExtendService;

	@Autowired(required = false)
	private TmCustOrgBackExtendService tmCustOrgBackExtendService;

	/**
	 * 跳转客户组织关系页面.
	 * @author wuzhujun
	 * @param request 请求对象
	 * @return 客户组织关系主界面
	 */
	@RequestMapping(value = "goOrgMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goOrgMain(HttpServletRequest request) {
		request.setAttribute("extendTableName",Globals.TABLE_CUSTOMER_ORG);
		if(tmCustOrgMainExtendService!=null){
			request.setAttribute("includeJSP", tmCustOrgMainExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgMain");
	}
	/**
	 * 跳转到业务归属页面
	 * @author wuzhujun
	 * @param request 请求对象
	 * @return 返回业务归属主页面
	 */
	@RequestMapping(value = "goBusiness", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goBusiness(HttpServletRequest request) {
		String custOrgId = OConvertUtils.getString(request.getParameter("custOrgId"));
		if(StringUtil.isNotEmpty(custOrgId)){
			request.setAttribute("custOrgId", custOrgId);
		}
		return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgBusinessMain");
	}
	/**
	 * 跳转已选择的业务归属页面
	 * @author wuzhujun
	 * @param tmCustOrgBusinessVo 业务归属
	 * @param request 请求对象
	 * @return 选择的业务归属页面
	 */
	@RequestMapping(value = "goTmBusinessCheckedMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmBusinessCheckedMain(TmCustOrgBusinessVo tmCustOrgBusinessVo, HttpServletRequest request) {
		request.setAttribute("custOrgId", StringUtil.isNotEmpty(tmCustOrgBusinessVo.getCustOrgId())?tmCustOrgBusinessVo.getCustOrgId():"-1");
		return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmBusinessCheckedMain");
	}
	/**
	 * 客户组织关系新增编辑页面.
	 * <p>跳转组织新增编辑页面
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param tmCustomerOrgVo 客户组织关系实体对象
	 * @return 客户组织关系新增编辑页面
	 */
	@RequestMapping(value = "goCustOrgForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCustOrgForm(HttpServletRequest request, TmCustomerOrgVo tmCustomerOrgVo) {
		//表单类型0新增1编辑2查看
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		
		//动态表单参数 表名
		request.setAttribute("extendTableName",Globals.TABLE_CUSTOMER_ORG);
		
		
		if(StringUtil.isNotEmpty(tmCustomerOrgVo.getId())){
			TmCustomerOrgVo vo = tmCustOrgService.getTmCustOrg(tmCustomerOrgVo.getId());
			request.setAttribute("custOrg", vo);
		}

		if(tmCustOrgFormExtendService!=null){
			request.setAttribute("includeJSP", tmCustOrgFormExtendService.includeJsp());
		}

		return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgForm");
	}
	/**
	 * 跳转关联终端页面
	 * @author wuzhujun
	 * @param request 请求对象
	 * @return 返回关联终端页面
	 */
	@RequestMapping(value = "goCustOrgTerminal", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCustOrgTerminal(HttpServletRequest request){
		String id = request.getParameter("id");
		request.setAttribute("custOrgId", id);
		return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgTerminalMain");
	}
	/**
	 * 跳转关联客户页面
	 * @author wuzhujun
	 * @param request 请求对象
	 * @return 返回管理客户页面
	 */
	@RequestMapping(value = "goCustOrgCustomer", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCustOrgCustomer(HttpServletRequest request){
		String id = request.getParameter("id");
		request.setAttribute("custOrgId", id);
		return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgCustomerMain");
	}
	/**
	 * 获取未关联的业务列表
	 * @author wuzhujun
	 * @param businessVo  业务归属模型
	 * @param request 请求对象
	 * @param response 响应对象
	 * @return 返回获取未关联的业务列表数据
	 */
	@RequestMapping(value = "findNotRefBusinessGrid", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNotRefBusinessList(TmCustOrgBusinessVo businessVo, HttpServletRequest request) {
		Page page = new EuPage(request);
		if(StringUtil.isNotEmpty(businessVo.getOrgName())){
			TmOrgEntity tmOrgEntity = tmCustOrgService.get(TmOrgEntity.class, businessVo.getOrgName());
			if(StringUtil.isNotEmpty(tmOrgEntity)){
				businessVo.setOrgName(tmOrgEntity.getOrgName());
			}
		}
		List <TmCustOrgBusinessVo> businessList  = tmCustOrgService.findNotRefBusinessGrid(businessVo, page);
		return new DataGrid(businessList,page);
	}
	/**
	 * 获取关联的业务数据
	 * @author wuzhujun
	 * @param businessVo  业务归属模型
	 * @param request 请求对象
	 * @param response 响应对象
	 * @return 返回获取未关联的业务列表数据
	 */
	@RequestMapping(value = "findRefBusinessGrid", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List <TmCustOrgBusinessVo> findRefBusinessList(TmCustOrgBusinessVo businessVo, HttpServletRequest request) {
		List <TmCustOrgBusinessVo> businessList  = tmCustOrgService.findRefBusinessGrid(businessVo);
		return businessList;
	}
	
	/**
	 * 客户组织关系列表.
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param treeGrid 树形结构模型
	 * @param custOrgVo 客户组织关系vo对象
	 * @return 客户组织关系json数据
	 */
	@RequestMapping(value = "findTmCustomerOrgList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<TmCustomerOrgVo> findTmCustomerOrgList(HttpServletRequest request,TmCustomerOrgVo custOrgVo) {
		List <TmCustomerOrgVo> voList = tmCustOrgService.findTmCustomerOrgList(custOrgVo);
		return voList;
	}
	/**
	 * 根据custOrgId查询关联客户
	 * @author wuzhujun
	 * @param tmCustOrgCustomerVo 客户组织关系_关联客户vo
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findCustmerGrid", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findCustmerList(TmCustOrgCustomerVo tmCustOrgCustomerVo,HttpServletRequest request,HttpServletResponse response){
		Page page = new EuPage(request);
		List<TmCustOrgCustomerVo> customerList = 
		tmCustOrgService.findTmCustomerByCustOrg(tmCustOrgCustomerVo,page);
		return new DataGrid(customerList,page);
	}
	
	/**
	 * 获取关联终端数据
	 * @author wuzhujun
	 * @param tmCustOrgTerminalVo 客户组织关系_关联终端vo
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findTerminalGrid", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTerminalList(TmCustOrgTerminalVo tmCustOrgTerminalVo,HttpServletRequest request,HttpServletResponse response){
		Page page = new EuPage(request);
		List<TmCustOrgTerminalVo> terminalList = 
		tmCustOrgService.findTmTerminalByCustOrg(tmCustOrgTerminalVo,page);
		return new DataGrid(terminalList,page);
	}
	/**
	 * 获取上级组织.
	 * <p>获取上级组织的方法
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 * @return 下拉树
	 */
	@RequestMapping(value = "getParentCustOrg",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List<ComboTree> getParentOrg(HttpServletRequest request, ComboTree comboTree,TmCustomerOrgVo custOrgVo) {
		return tmCustOrgService.getParentCustOrgs(request, comboTree);
	}
	/**
	 * 保存编辑.
	 * @param custOrgVo 客户组织关系vo对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "saveOrUpdateCustOrg", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateOrg(HttpServletRequest request, TmCustomerOrgVo custOrgVo) {
		AjaxJson j = new AjaxJson();
		try {
			Page page = new EuPage(request);
			//保存数据
			String id = tmCustOrgService.saveOrUpdateCustOrg(custOrgVo, page);
			//更新叶子节点状态
			tmCustOrgService.updateIsLeafColumn(Globals.TABLE_CUSTOMER_ORG);
			if (null != tmCustOrgBackExtendService){
				tmCustOrgBackExtendService.afterSaveOrUpdateCustOrg(id);
			}

			//设置编码和名称，用于保存后进行查询操作
			Map <String, Object>attributes = new HashMap<String, Object>();
			attributes.put("custOrgCode", custOrgVo.getCustOrgCode());
			attributes.put("customerOrgName", custOrgVo.getCustomerOrgName());
			j.setAttributes(attributes);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败：" + e.getMessage());
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 删除客户组织关系.
	 * @author wuzhujun
	 * @param ids 客户组织关系ids
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "delCustOrg", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delCustOrg(String ids) {
		AjaxJson j = tmCustOrgService.delCustOrg(ids);
		if (null != tmCustOrgBackExtendService){
			tmCustOrgBackExtendService.afterDelCustOrg(ids);
		}
		return j;
	}
	
	
	/**
	 * 移除客户组织关联业务.
	 * @author wuzhujun
	 * @param request 请求对象
	 * @return 返回AjaxJson出力对象
	 */
	@RequestMapping(value="removeCustOrgBusiness", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson removeCustOrgBusiness(HttpServletRequest request){
		String id = request.getParameter("id");
		String custOrgId = request.getParameter("custOrgId");
		AjaxJson ajaxJson = tmCustOrgService.removeCustOrgBusiness(id, custOrgId);
		if (null != tmCustOrgBackExtendService){
			tmCustOrgBackExtendService.afterRemoveCustOrgBusiness(id,custOrgId);
		}
		return ajaxJson;
	}
	/**
	 * 移除客户组织关联业务
	 * @author wuzhujun
	 * @param request 请求对象
	 * @return 返回AjaxJson出力对象
	 */
	@RequestMapping(value="addCustOrgBusiness", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson addCustOrgBusiness(HttpServletRequest request){
		String id = request.getParameter("id");
		String custOrgId = request.getParameter("custOrgId");
		AjaxJson json = tmCustOrgService.addCustOrgBusiness(id, custOrgId);
		if (null != tmCustOrgBackExtendService){
			tmCustOrgBackExtendService.afterAddCustOrgBusiness(id,custOrgId);
		}
		return json;
	}
	/**
	 * 验证重复Code.
	 * @author wuzhujun
	 * @param  custOrgVo 客户组织关系vo对象
	 * @param 验证对象
	 */
	@RequestMapping(value = "validateCustOrgCode",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateOrgCode(TmCustomerOrgVo custOrgVo,HttpServletRequest request) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		Criterion cr = Restrictions.eq("enableStatus",Globals.ZERO);
		//验证
		if(StringUtil.isNotEmpty(custOrgVo.getId())){
			//修改
			Criterion cr2 = Restrictions.ne("id", custOrgVo.getId());
			Criterion cr3 = Restrictions.eq("custOrgCode", param);
			List<TmCustomerOrgEntity> tmOrgByCodes = tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class,cr, cr3, cr2);
			if(!CollectionUtils.isEmpty(tmOrgByCodes)){
				validForm.setStatus("n");
				validForm.setInfo("客户组织编码已存在");
			}
		}else{
			List<TmCustomerOrgEntity> tmOrgByCodes = tmCustOrgService.findByProperty(TmCustomerOrgEntity.class, "custOrgCode", param);
			if(!CollectionUtils.isEmpty(tmOrgByCodes)){
				validForm.setStatus("n");
				validForm.setInfo("客户组织编码已存在");
			}
		}
		return validForm;
	}
	/**
	 * 验证重复Name.
	 * @author wuzhujun
	 * @param  custOrgVo 客户组织关系vo对象
	 * @param 验证对象
	 */
	@RequestMapping(value = "validateCustOrgName",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateOrgName(TmCustomerOrgVo custOrgVo,HttpServletRequest request) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		Criterion cr = Restrictions.eq("enableStatus",Globals.ZERO);
		//验证
		if(StringUtil.isNotEmpty(custOrgVo.getId())){
			//修改
			Criterion cr1 = Restrictions.eq("customerOrgName",param);
			Criterion cr2 = Restrictions.ne("id", custOrgVo.getId());
			List<TmCustomerOrgEntity> tmOrgs = tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class, cr,cr1, cr2);
			if(!CollectionUtils.isEmpty(tmOrgs)){
				validForm.setStatus("n");
				validForm.setInfo("客户组织名称已存在");
			}
		}else{
			//新增
			Criterion cr3 = Restrictions.eq("customerOrgName", param);
			List<TmCustomerOrgEntity> tmOrgs = tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class, cr,cr3);
			if(!CollectionUtils.isEmpty(tmOrgs)){
				validForm.setStatus("n");
				validForm.setInfo("客户组织名称已存在");
			}
		}
		return validForm;
	}
	/**
	 * 获取上级组织.
	 * <p>获取上级组织的方法
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 * @return 下拉树
	 */
	@RequestMapping(value = "getParentCustOrgs", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<ComboTree> getParentOrgs(HttpServletRequest request, ComboTree comboTree,TmCustomerOrgVo custOrgVo) {
		return tmCustOrgService.getParentCustOrg(request, comboTree);
	}
	/**
	 * 客户组织关系列表excel导出
	 * @author wuzhujun
	 * @param custOrgVo 客户组织关系vo
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmCustomerOrgVo custOrgVo, HttpServletRequest request, HttpServletResponse response) {
		custOrgVo.setExportExcel("true");//设置为导出状态
		List<TmCustomerOrgVo> custOrgVoList = tmCustOrgService.findTmCustomerOrgList(custOrgVo);
		doExportXls(response, request, custOrgVoList, TmCustomerOrgVo.class, "客户组织列表");
	}
	
}
