package com.biz.eisp.mdm.custorg.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.custorg.vo.QueryTmCustOrgVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgBusinessVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgCustomerVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgTerminalVo;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;

/** 客户组织关系Dao接口.
 * <p>客户组织关系Dao，涉及表：tm_coustomer_org,tm_org,tm_position,tm_terminal,查询关联客户，关联终端<br>
 * @author wuzhujun
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@InterfaceDao
public interface TmCustOrgDao {
	/**
	 * 查询客户关系关联客户
	 * @author wuzhujun 
	 * @param tmCustOrgCustomerVo 关联客户vo
	 * @return 
	 */
	@Arguments({"tmCustOrgCustomerVo","page"})
	@ResultType(TmCustOrgCustomerVo.class)
	public List<TmCustOrgCustomerVo> findTmCustomerByCustOrg(TmCustOrgCustomerVo tmCustOrgCustomerVo,Page page);
	/**
	 * 查询客户关系关联终端
	 * @author wuzhujun
	 * @param tmCustOrgTerminalVo 客户组织关系_关联终端vo
	 * @return 客户组织关系_关联终端vo集合
	 */
	@Arguments({"tmCustOrgTerminalVo","page"})
	@ResultType(TmCustOrgTerminalVo.class)
	public List<TmCustOrgTerminalVo> findTmTerminalByCustOrg(TmCustOrgTerminalVo tmCustOrgTerminalVo,Page page);
	/**
	 * 分页查询客户组织未关联业务
	 * @author wuzhujun
	 * @param tmCustOrgBusinessVo 
	 * @return
	 */
	@Arguments({"tmCustOrgBusinessVo","page"})
	@ResultType(TmCustOrgBusinessVo.class)
	public List<TmCustOrgBusinessVo> findNotRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo,Page page);
	
	/**
	 * 查询客户组织关联业务
	 * @author wuzhujun
	 * @param tmCustOrgBusinessVo 
	 * @return
	 */
	@Arguments({"tmCustOrgBusinessVo"})
	@ResultType(TmCustOrgBusinessVo.class)
	public List<TmCustOrgBusinessVo> findRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo);
	
	/**
	 * 查询客户关系关联客户
	 * @author wuzhujun 
	 * @param tmCustOrgCustomerVo 关联客户vo
	 * @return 
	 */
	@Arguments({"tmCustOrgCustomerVo"})
	@ResultType(TmCustOrgCustomerVo.class)
	public List<TmCustOrgCustomerVo> findTmCustomerByCustOrg(TmCustOrgCustomerVo tmCustOrgCustomerVo);
	/**
	 * 查询客户关系关联终端
	 * @author wuzhujun
	 * @param tmCustOrgTerminalVo 客户组织关系_关联终端vo
	 * @return 客户组织关系_关联终端vo集合
	 */
	@Arguments({"tmCustOrgTerminalVo"})
	@ResultType(TmCustOrgTerminalVo.class)
	public List<TmCustOrgTerminalVo> findTmTerminalByCustOrg(TmCustOrgTerminalVo tmCustOrgTerminalVo);
	/**
	 * 客户组织导出.
	 * @author grover
	 * @param queryTmCustOrgVo 客户组织查询vo
	 * @return 客户组织信息
	 */
	@Arguments({"custOrgVo"})
	@ResultType(TmCustomerOrgVo.class)
	public List<TmCustomerOrgVo> findTmCustOrgExcel(TmCustomerOrgVo custOrgVo);
	/**
	 * 客户组织所有可能的查询.
	 * @author grover
	 * @param queryTmCustOrgVo 客户组织查询vo
	 * @return 客户组织信息
	 */
	@Arguments({"queryTmCustOrgVo","page"})
	@ResultType(TmCustomerOrgVo.class)
	public List<TmCustomerOrgVo> findTmCustOrgByAllPossible(QueryTmCustOrgVo queryTmCustOrgVo, Page page);
	
	@Arguments({"custOrgVo","fields","conditions"})
	@ResultType(TmCustomerOrgVo.class) 
	public List<TmCustomerOrgVo> findNodeCustomerOrgList(TmCustomerOrgVo custOrgVo, String fields, String conditions);
	
	@Arguments({"custOrgVo","fields","conditions"})
	@ResultType(TmCustomerOrgVo.class)  
	public List<TmCustomerOrgVo> findQueryCustomerOrgList(TmCustomerOrgVo custOrgVo, String fields, String conditions);
	
}
