package com.biz.eisp.mdm.custorg.entity;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Where;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;

/** 
 * 客户组织关系实体.
 * <p>关联数据库表：tm_customer_org<br>
 * @author wuzhujun
 * @version v1.0
 */
@Entity
@Table(name = "tm_customer_org")
public class TmCustomerOrgEntity extends IdEntity implements java.io.Serializable,Loggerable{
	private static final long serialVersionUID = 1L;
	/**
	 * 创建人
	 */
	private java.lang.String createName;
	/**
	 * 创建日期
	 */
	private java.util.Date createDate;
	/**
	 * 修改日期
	 */
	private java.util.Date updateDate;
	/**
	 * 修改名字
	 */
	private java.lang.String updateName;
	/**
	 * 客户组织编码
	 */
	private java.lang.String custOrgCode;
	/**
	 * 客户组织名称
	 */
	private java.lang.String customerOrgName;
	/**
	 * 客户组织名称拼音简写
	 */
	private java.lang.String headString;
	/**
	 * 客户组织描述
	 */
	private java.lang.String custOrgDesc;
	/**
	 * 客户组织类型，对应数据字典cust_org_type下的值
	 */
	private java.lang.String custOrgType;
	/**
	 * 客户组织级别
	 */
	private java.lang.Integer custOrgLevel;
	/**
	 * 启用状态：0-启用，1-不启用
	 */
	private java.lang.Integer enableStatus;
	/**
	 * 客户组织对应职位id
	 */
	private java.lang.String positionId;
	
	
	/**
	 * 字符类型（length=100）-扩展字段1
	 */
	private String extChar1;
	/**
	 * 字符类型（length=100）-扩展字段2
	 */
	private String extChar2;
	/**
	 * 字符类型（length=100）-扩展字段3
	 */
	private String extChar3;
	/**
	 * 字符类型（length=100）-扩展字段4
	 */
	private String extChar4;
	/**
	 * 字符类型（length=100）-扩展字段5
	 */
	private String extChar5;
	/**
	 * 数字类型-扩展字段1
	 */
	private Integer extNumber1;
	/*
	 * 数字类型-扩展字段2
	 */
	private Integer extNumber2;
	/**
	 * 数字类型-扩展字段3
	 */
	private Integer extNumber3;
	/**
	 * 是否叶子节点
	 */
	private Integer isLeaf;
	/**
	 * 上级客户组织关系
	 */
	private TmCustomerOrgEntity tmCustOrg;
	/**
	 * 下级客户组织关系
	 */
	private List<TmCustomerOrgEntity> tmCustOrgs  = new ArrayList<TmCustomerOrgEntity>();
	
	/**
	 *方法: 取得java.lang.String
	 *
	 *@return: java.lang.String  父级客户组织
	 */
	@Column(name = "position_id")
	public java.lang.String getPositionId() {
		return positionId;
	}
	/**
	 *方法: 设置java.lang.String
	 *
	 *@param: java.lang.String  父级客户组织
	 */
	public void setPositionId(java.lang.String positionId) {
		this.positionId = positionId;
	}
	/**
	 *方法: 取得java.lang.String
	 *
	 *@return: java.lang.String  创建人登录名称
	 */
	@Column(name ="create_name",nullable=false)
	public java.lang.String getCreateName() {
		return createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *
	 *@param: java.lang.String  创建人登录名称
	 */
	public void setCreateName(java.lang.String createName) {
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *
	 *@return: java.util.Date  创建日期
	 */
	@Column(name ="create_date",nullable=false)
	public java.util.Date getCreateDate() {
		return createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *
	 *@param: java.util.Date  创建日期
	 */
	public void setCreateDate(java.util.Date createDate) {
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.util.Date
	 *
	 *@return: java.util.Date  修改日期
	 */
	@Column(name = "update_date")
	public java.util.Date getUpdateDate() {
		return updateDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *
	 *@param: java.util.Date  修改日期
	 */
	public void setUpdateDate(java.util.Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *
	 *@return: java.lang.String  修改人登录名称
	 */
	@Column(name = "update_name")
	public java.lang.String getUpdateName() {
		return updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *
	 *@param: java.lang.String  修改人登录名称
	 */
	public void setUpdateName(java.lang.String updateName) {
		this.updateName = updateName;
	}
	/**
	 *方法: 取得java.lang.String
	 *
	 *@return: java.lang.String  客户组织关系编码
	 */
	@Column(name ="cust_org_code",nullable=false,unique=true)
	public java.lang.String getCustOrgCode() {
		return custOrgCode;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String  客户组织关系编码
	 */
	public void setCustOrgCode(java.lang.String custOrgCode) {
		this.custOrgCode = custOrgCode;
	}
	/**
	 *方法: 取得java.lang.String
	 *
	 *@return: java.lang.String  客户组合关系名称
	 */
	@Column(name ="cust_org_name",nullable=false,unique=true)
	public java.lang.String getCustomerOrgName() {
		return customerOrgName;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String  客户组织关系名称
	 */
	public void setCustomerOrgName(java.lang.String customerOrgName) {
		this.customerOrgName = customerOrgName;
	}
	/**
	 *方法: 取得java.lang.String
	 *
	 *@return: java.lang.String  客户组织名称拼音简写
	 */
	@Column(name ="headstring")
	public java.lang.String getHeadString() {
		return headString;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String  客户组织名称拼音简写
	 */
	public void setHeadString(java.lang.String headString) {
		this.headString = headString;
	}
	/**
	 *方法: 取得java.lang.String
	 *
	 *@return: java.lang.String  客户组织关系描述
	 */
	@Column(name ="cust_org_desc")
	public java.lang.String getCustOrgDesc() {
		return custOrgDesc;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String  客户组织关系描述
	 */
	public void setCustOrgDesc(java.lang.String custOrgDesc) {
		this.custOrgDesc = custOrgDesc;
	}
	/**
	 * 方法: 取得java.lang.String 
	 * 
	 * @return java.lang.String 客户组织关系类型
	 */
	@Column(name ="cust_org_type")
	public java.lang.String getCustOrgType() {
		return custOrgType;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String  客户组织关系类型
	 */
	public void setCustOrgType(java.lang.String custOrgType) {
		this.custOrgType = custOrgType;
	}
	/**
	 * 方法: 取得java.lang.Integer 
	 * 
	 * @return java.lang.Integer 客户组织关系级别
	 */
	@Column(name ="cust_org_level",nullable=false)
	public java.lang.Integer getCustOrgLevel() {
		return custOrgLevel;
	}
	/**
	 * 方法: 设置java.lang.Integer 
	 * 
	 * @param java.lang.Integer 客户组织关系级别
	 */
	public void setCustOrgLevel(java.lang.Integer custOrgLevel) {
		this.custOrgLevel = custOrgLevel;
	}
	/**
	 * 方法: 取得java.lang.Integer 
	 * 
	 * @return java.lang.Integer 客户组织关系状态
	 */
	@Column(name ="enable_status",nullable=true)
	public java.lang.Integer getEnableStatus() {
		return enableStatus;
	}
	/**
	 * 方法: 设置java.lang.Integer 
	 * 
	 * @param java.lang.Integer 客户组织关系状态
	 */
	public void setEnableStatus(java.lang.Integer enableStatus) {
		this.enableStatus = enableStatus;
	}
	/**
	 * 方法: 取得com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity
	 * 
	 * @return com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity 上级客户组织关系
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "parent_id")
	@JsonIgnore
	public TmCustomerOrgEntity getTmCustOrg() {
		return tmCustOrg;
	}
	/**
	 * 方法:设置com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity
	 * 
	 * @param  com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity 上级客户组织关系
	 */
	public void setTmCustOrg(TmCustomerOrgEntity tmCustOrg) {
		if(tmCustOrg != null && tmCustOrg.getId().equals(id)) {
			throw new BusinessException("上级客户组织不能选择当前组织");
		}
		this.tmCustOrg = tmCustOrg;
	}
	/**
	 * 方法：取得下级客户组织关系
	 * 
	 * @return com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity 下级客户组织关系
	 */
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "tmCustOrg")
	@Where(clause="enable_status=0")
	@JsonIgnore
	@Fetch(FetchMode.SUBSELECT)
	public List<TmCustomerOrgEntity> getTmCustOrgs() {
		return tmCustOrgs;
	}
	/**
	 * 方法：设置com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity
	 * 
	 * @param com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity 下级客户组织关系
	 */
	public void setTmCustOrgs(List<TmCustomerOrgEntity> tmCustOrgs) {
		this.tmCustOrgs = tmCustOrgs;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段1
	 */
	@Column(name = "ext_char_1")
	public String getExtChar1(){
		return extChar1;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段2
	 */
	@Column(name = "ext_char_2")
	public String getExtChar2(){
		return extChar2;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段3
	 */
	@Column(name = "ext_char_3")
	public String getExtChar3(){
		return extChar3;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段4
	 */
	@Column(name = "ext_char_4")
	public String getExtChar4(){
		return extChar4;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段5
	 */
	@Column(name = "ext_char_5")
	public String getExtChar5(){
		return extChar5;
	}
	/**
	 * 方法: 取得java.lang.Integer 
	 * 
	 * @return java.lang.Integer 数字扩展字段1
	 */
	@Column(name = "ext_number_1")
	public Integer getExtNumber1(){
		return extNumber1;
	}
	/**
	 * 方法: 取得java.lang.Integer 
	 * 
	 * @return java.lang.Integer 数字扩展字段2
	 */
	@Column(name = "ext_number_2")
	public Integer getExtNumber2(){
		return extNumber2;
	}
	/**
	 * 方法: 取得java.lang.Integer 
	 * 
	 * @return java.lang.Integer 数字扩展字段3
	 */
	@Column(name = "ext_number_3")
	public Integer getExtNumber3(){
		return extNumber3;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String 字符扩展字段1
	 */
	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String 字符扩展字段2
	 */
	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String 字符扩展字段3
	 */
	public void setExtChar3(String extChar3) {
		this.extChar3 = extChar3;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String 字符扩展字段4
	 */
	public void setExtChar4(String extChar4) {
		this.extChar4 = extChar4;
	}
	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param java.lang.String 字符扩展字段5
	 */
	public void setExtChar5(String extChar5) {
		this.extChar5 = extChar5;
	}
	/**
	 * 方法: 设置java.lang.Integer 
	 * 
	 * @param java.lang.Integer 数字扩展字段1
	 */
	public void setExtNumber1(Integer extNumber1) {
		this.extNumber1 = extNumber1;
	}
	/**
	 * 方法: 设置java.lang.Integer 
	 * 
	 * @param java.lang.Integer 数字扩展字段2
	 */
	public void setExtNumber2(Integer extNumber2) {
		this.extNumber2 = extNumber2;
	}
	/**
	 * 方法: 设置java.lang.Integer 
	 * 
	 * @param java.lang.Integer 数字扩展字段3
	 */
	public void setExtNumber3(Integer extNumber3) {
		this.extNumber3 = extNumber3;
	}

	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 是否是叶子节点
	 */
	@Column(name = "is_leaf")
	public Integer getIsLeaf() {
		return isLeaf;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 是否叶子节点
	 */
	public void setIsLeaf(Integer isLeaf) {
		this.isLeaf = isLeaf;
	}

	@Override
	public String businessDesc() {
		return "客户组织基本信息";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}
}
